/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.CommonPermissionUtil;
import com.liferay.portal.service.base.PhoneServiceBaseImpl;
import java.util.List;

public class PhoneServiceImpl
extends PhoneServiceBaseImpl {
    @Override
    public Phone addPhone(String className, long classPK, String number, String extension, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.phoneLocalService.addPhone(this.getUserId(), className, classPK, number, extension, typeId, primary, serviceContext);
    }

    @Override
    public void deletePhone(long phoneId) throws PortalException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        CommonPermissionUtil.check(this.getPermissionChecker(), phone.getClassNameId(), phone.getClassPK(), "UPDATE");
        this.phoneLocalService.deletePhone(phone);
    }

    @Override
    public Phone getPhone(long phoneId) throws PortalException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        CommonPermissionUtil.check(this.getPermissionChecker(), phone.getClassNameId(), phone.getClassPK(), "VIEW");
        return phone;
    }

    @Override
    public List<Phone> getPhones(String className, long classPK) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "VIEW");
        User user = this.getUser();
        return this.phoneLocalService.getPhones(user.getCompanyId(), className, classPK);
    }

    @Override
    public Phone updatePhone(long phoneId, String number, String extension, long typeId, boolean primary) throws PortalException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        CommonPermissionUtil.check(this.getPermissionChecker(), phone.getClassNameId(), phone.getClassPK(), "UPDATE");
        return this.phoneLocalService.updatePhone(phoneId, number, extension, typeId, primary);
    }
}

