/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.service.base.PermissionServiceBaseImpl;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.List;

public class PermissionServiceImpl
extends PermissionServiceBaseImpl {
    private static final ServiceTrackerMap<String, BaseModelPermissionChecker> _baseModelPermissionCheckers = ServiceTrackerCollections.openSingleValueMap(BaseModelPermissionChecker.class, "model.class.name");
    private static final ServiceTrackerMap<String, ModelResourcePermission> _modelPermissions = ServiceTrackerCollections.openSingleValueMap(ModelResourcePermission.class, "model.class.name");

    @Override
    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public void checkPermission(long groupId, String name, long primKey) throws PortalException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, String.valueOf(primKey));
    }

    @Override
    public void checkPermission(long groupId, String name, String primKey) throws PortalException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, primKey);
    }

    protected boolean checkBaseModelPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK) throws PortalException {
        ModelResourcePermission modelResourcePermission;
        String actionId = "PERMISSIONS";
        if (className.equals(Team.class.getName())) {
            className = Group.class.getName();
            Team team = this.teamLocalService.fetchTeam(classPK);
            classPK = team.getGroupId();
            actionId = "MANAGE_TEAMS";
        }
        if ((modelResourcePermission = _modelPermissions.getService(className)) != null) {
            PortletResourcePermission portletResourcePermission = modelResourcePermission.getPortletResourcePermission();
            if (portletResourcePermission == null) {
                modelResourcePermission.check(permissionChecker, classPK, actionId);
                return true;
            }
            ModelResourcePermissionHelper.check(modelResourcePermission, permissionChecker, groupId, classPK, actionId);
            return true;
        }
        BaseModelPermissionChecker baseModelPermissionChecker = _baseModelPermissionCheckers.getService(className);
        if (baseModelPermissionChecker != null) {
            baseModelPermissionChecker.checkBaseModel(permissionChecker, groupId, classPK, actionId);
            return true;
        }
        return false;
    }

    protected void checkPermission(PermissionChecker permissionChecker, long groupId, String name, String primKey) throws PortalException {
        if (this.checkBaseModelPermission(permissionChecker, groupId, name, GetterUtil.getLong(primKey))) {
            return;
        }
        if (primKey != null && primKey.contains("_LAYOUT_")) {
            int pos = primKey.indexOf("_LAYOUT_");
            long plid = GetterUtil.getLong(primKey.substring(0, pos));
            String portletId = primKey.substring(pos + "_LAYOUT_".length());
            PortletPermissionUtil.check(permissionChecker, groupId, plid, portletId, "CONFIGURATION");
        } else if (!permissionChecker.hasPermission(groupId, name, primKey, "PERMISSIONS")) {
            AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(name);
            if (assetRendererFactory != null) {
                try {
                    if (assetRendererFactory.hasPermission(permissionChecker, GetterUtil.getLong(primKey), "PERMISSIONS")) {
                        return;
                    }
                }
                catch (Exception plid) {
                    // empty catch block
                }
            }
            ResourcePermission resourcePermission = this.resourcePermissionLocalService.getResourcePermission(permissionChecker.getCompanyId(), name, 4, primKey, permissionChecker.getOwnerRoleId());
            long ownerId = resourcePermission.getOwnerId();
            if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), name, primKey, ownerId, "PERMISSIONS")) {
                return;
            }
            Role role = null;
            if (name.equals(Role.class.getName())) {
                long roleId = GetterUtil.getLong(primKey);
                role = this.rolePersistence.findByPrimaryKey(roleId);
            }
            if (role != null && role.isTeam()) {
                Team team = this.teamPersistence.findByPrimaryKey(role.getClassPK());
                TeamPermissionUtil.check(permissionChecker, team, "PERMISSIONS");
            } else {
                List<String> resourceActions = ResourceActionsUtil.getResourceActions(name);
                if (!resourceActions.contains("DEFINE_PERMISSIONS") || !permissionChecker.hasPermission(groupId, name, primKey, "DEFINE_PERMISSIONS")) {
                    throw new PrincipalException.MustHavePermission(permissionChecker, name, (long)Long.valueOf(primKey), "DEFINE_PERMISSIONS");
                }
            }
        }
    }
}

