/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchPasswordPolicyRelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PasswordPolicyRel;
import com.liferay.portal.service.base.PasswordPolicyRelLocalServiceBaseImpl;
import java.util.List;

public class PasswordPolicyRelLocalServiceImpl
extends PasswordPolicyRelLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PasswordPolicyRelLocalServiceImpl.class);

    @Override
    public PasswordPolicyRel addPasswordPolicyRel(long passwordPolicyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        if (passwordPolicyRel != null) {
            if (passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId) {
                return null;
            }
            this.passwordPolicyRelPersistence.remove(passwordPolicyRel);
        }
        long passwordPolicyRelId = this.counterLocalService.increment();
        passwordPolicyRel = this.passwordPolicyRelPersistence.create(passwordPolicyRelId);
        passwordPolicyRel.setPasswordPolicyId(passwordPolicyId);
        passwordPolicyRel.setClassNameId(classNameId);
        passwordPolicyRel.setClassPK(classPK);
        this.passwordPolicyRelPersistence.update(passwordPolicyRel);
        return passwordPolicyRel;
    }

    @Override
    public void addPasswordPolicyRels(long passwordPolicyId, String className, long[] classPKs) {
        for (long classPK : classPKs) {
            this.addPasswordPolicyRel(passwordPolicyId, className, classPK);
        }
    }

    @Override
    public void deletePasswordPolicyRel(long passwordPolicyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        if (passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId) {
            this.passwordPolicyRelPersistence.remove(passwordPolicyRel);
        }
    }

    @Override
    public void deletePasswordPolicyRel(String className, long classPK) {
        block2: {
            try {
                long classNameId = this.classNameLocalService.getClassNameId(className);
                PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.findByC_C(classNameId, classPK);
                this.deletePasswordPolicyRel(passwordPolicyRel);
            }
            catch (NoSuchPasswordPolicyRelException nsppre) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug(nsppre, nsppre);
            }
        }
    }

    @Override
    public void deletePasswordPolicyRels(long passwordPolicyId) {
        List<PasswordPolicyRel> passwordPolicyRels = this.passwordPolicyRelPersistence.findByPasswordPolicyId(passwordPolicyId);
        for (PasswordPolicyRel passwordPolicyRel : passwordPolicyRels) {
            this.deletePasswordPolicyRel(passwordPolicyRel);
        }
    }

    @Override
    public void deletePasswordPolicyRels(long passwordPolicyId, String className, long[] classPKs) {
        for (long classPK : classPKs) {
            this.deletePasswordPolicyRel(passwordPolicyId, className, classPK);
        }
    }

    @Override
    public PasswordPolicyRel fetchPasswordPolicyRel(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
    }

    @Override
    public PasswordPolicyRel getPasswordPolicyRel(long passwordPolicyId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        if (passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId) {
            return passwordPolicyRel;
        }
        StringBundler sb = new StringBundler(8);
        sb.append("No PasswordPolicyRel exists with the key {");
        sb.append("passwordPolicyId=");
        sb.append(passwordPolicyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchPasswordPolicyRelException(sb.toString());
    }

    @Override
    public PasswordPolicyRel getPasswordPolicyRel(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.passwordPolicyRelPersistence.findByC_C(classNameId, classPK);
    }

    @Override
    public boolean hasPasswordPolicyRel(long passwordPolicyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        return passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId;
    }
}

