/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.PasswordPolicyPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.OrganizationIdComparator;
import com.liferay.portal.service.base.OrganizationServiceBaseImpl;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class OrganizationServiceImpl
extends OrganizationServiceBaseImpl {
    @Override
    public void addGroupOrganizations(long groupId, long[] organizationIds) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "ASSIGN_MEMBERS");
        this.organizationLocalService.addGroupOrganizations(groupId, organizationIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Organization addOrganization(long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException {
        boolean indexingEnabled = true;
        if (serviceContext != null) {
            indexingEnabled = serviceContext.isIndexingEnabled();
            serviceContext.setIndexingEnabled(false);
        }
        try {
            Organization organization = this.addOrganization(parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
            UsersAdminUtil.updateAddresses(Organization.class.getName(), organization.getOrganizationId(), addresses);
            UsersAdminUtil.updateEmailAddresses(Organization.class.getName(), organization.getOrganizationId(), emailAddresses);
            UsersAdminUtil.updateOrgLabors(organization.getOrganizationId(), orgLabors);
            UsersAdminUtil.updatePhones(Organization.class.getName(), organization.getOrganizationId(), phones);
            UsersAdminUtil.updateWebsites(Organization.class.getName(), organization.getOrganizationId(), websites);
            if (indexingEnabled) {
                Indexer<Organization> indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
                indexer.reindex(organization);
            }
            Organization organization2 = organization;
            return organization2;
        }
        finally {
            if (serviceContext != null) {
                serviceContext.setIndexingEnabled(indexingEnabled);
            }
        }
    }

    @Override
    public Organization addOrganization(long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean site, ServiceContext serviceContext) throws PortalException {
        if (parentOrganizationId == 0L) {
            PortalPermissionUtil.check(this.getPermissionChecker(), "ADD_ORGANIZATION");
        } else {
            OrganizationPermissionUtil.check(this.getPermissionChecker(), parentOrganizationId, "ADD_ORGANIZATION");
        }
        Organization organization = this.organizationLocalService.addOrganization(this.getUserId(), parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
        OrganizationMembershipPolicyUtil.verifyPolicy(organization);
        return organization;
    }

    @Override
    public void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException {
        PasswordPolicyPermissionUtil.check(this.getPermissionChecker(), passwordPolicyId, "UPDATE");
        this.organizationLocalService.addPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    @Override
    public void deleteLogo(long organizationId) throws PortalException {
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "UPDATE");
        this.organizationLocalService.deleteLogo(organizationId);
    }

    @Override
    public void deleteOrganization(long organizationId) throws PortalException {
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "DELETE");
        this.organizationLocalService.deleteOrganization(organizationId);
    }

    @Override
    public Organization fetchOrganization(long organizationId) throws PortalException {
        Organization organization = this.organizationLocalService.fetchOrganization(organizationId);
        if (organization != null) {
            OrganizationPermissionUtil.check(this.getPermissionChecker(), organization, "VIEW");
        }
        return organization;
    }

    @Override
    public List<Organization> getGtOrganizations(long gtOrganizationId, long companyId, long parentOrganizationId, int size) {
        return this.organizationPersistence.filterFindByO_C_P(gtOrganizationId, companyId, parentOrganizationId, 0, size, new OrganizationIdComparator(true));
    }

    @Override
    public Organization getOrganization(long organizationId) throws PortalException {
        Organization organization = this.organizationLocalService.getOrganization(organizationId);
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organization, "VIEW");
        return organization;
    }

    @Override
    public long getOrganizationId(long companyId, String name) throws PortalException {
        long organizationId = this.organizationLocalService.getOrganizationId(companyId, name);
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "VIEW");
        return organizationId;
    }

    @Override
    public List<Organization> getOrganizations(long companyId, long parentOrganizationId) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterFindByCompanyId(companyId);
        }
        return this.organizationPersistence.filterFindByC_P(companyId, parentOrganizationId);
    }

    @Override
    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, int start, int end) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterFindByCompanyId(companyId, start, end);
        }
        return this.organizationPersistence.filterFindByC_P(companyId, parentOrganizationId, start, end);
    }

    @Override
    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, String name, int start, int end) {
        if (Validator.isNull(name)) {
            return this.getOrganizations(companyId, parentOrganizationId, start, end);
        }
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterFindByC_LikeN(companyId, name);
        }
        return this.organizationPersistence.filterFindByC_P_LikeN(companyId, parentOrganizationId, name, start, end);
    }

    @Override
    public int getOrganizationsCount(long companyId, long parentOrganizationId) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterCountByCompanyId(companyId);
        }
        return this.organizationPersistence.filterCountByC_P(companyId, parentOrganizationId);
    }

    @Override
    public int getOrganizationsCount(long companyId, long parentOrganizationId, String name) throws PortalException {
        if (Validator.isNull(name)) {
            return this.getOrganizationsCount(companyId, parentOrganizationId);
        }
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterCountByC_LikeN(companyId, name);
        }
        return this.organizationPersistence.filterCountByC_P_LikeN(companyId, parentOrganizationId, name);
    }

    @Override
    public List<Organization> getUserOrganizations(long userId) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "VIEW");
        return this.organizationLocalService.getUserOrganizations(userId);
    }

    @Override
    public void setGroupOrganizations(long groupId, long[] organizationIds) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "ASSIGN_MEMBERS");
        this.organizationLocalService.setGroupOrganizations(groupId, organizationIds);
    }

    @Override
    public void unsetGroupOrganizations(long groupId, long[] organizationIds) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "ASSIGN_MEMBERS");
        this.organizationLocalService.unsetGroupOrganizations(groupId, organizationIds);
    }

    @Override
    public void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException {
        PasswordPolicyPermissionUtil.check(this.getPermissionChecker(), passwordPolicyId, "UPDATE");
        this.organizationLocalService.unsetPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    @Override
    public Organization updateOrganization(long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean logo, byte[] logoBytes, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organization, "UPDATE");
        if (organization.getParentOrganizationId() != parentOrganizationId) {
            if (parentOrganizationId == 0L) {
                PortalPermissionUtil.check(this.getPermissionChecker(), "ADD_ORGANIZATION");
            } else {
                OrganizationPermissionUtil.check(this.getPermissionChecker(), parentOrganizationId, "ADD_ORGANIZATION");
            }
        }
        if (addresses != null) {
            UsersAdminUtil.updateAddresses(Organization.class.getName(), organizationId, addresses);
        }
        if (emailAddresses != null) {
            UsersAdminUtil.updateEmailAddresses(Organization.class.getName(), organizationId, emailAddresses);
        }
        if (orgLabors != null) {
            UsersAdminUtil.updateOrgLabors(organizationId, orgLabors);
        }
        if (phones != null) {
            UsersAdminUtil.updatePhones(Organization.class.getName(), organizationId, phones);
        }
        if (websites != null) {
            UsersAdminUtil.updateWebsites(Organization.class.getName(), organizationId, websites);
        }
        User user = this.getUser();
        Organization oldOrganization = organization;
        List<AssetCategory> oldAssetCategories = this.assetCategoryLocalService.getCategories(Organization.class.getName(), organizationId);
        List<AssetTag> oldAssetTags = this.assetTagLocalService.getTags(Organization.class.getName(), organizationId);
        ExpandoBridge oldExpandoBridge = oldOrganization.getExpandoBridge();
        Map<String, Serializable> oldExpandoAttributes = oldExpandoBridge.getAttributes();
        organization = this.organizationLocalService.updateOrganization(user.getCompanyId(), organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, logo, logoBytes, site, serviceContext);
        OrganizationMembershipPolicyUtil.verifyPolicy(organization, oldOrganization, oldAssetCategories, oldAssetTags, oldExpandoAttributes);
        return organization;
    }

    @Override
    public Organization updateOrganization(long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean site, ServiceContext serviceContext) throws PortalException {
        return this.updateOrganization(organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, true, null, site, null, null, null, null, null, serviceContext);
    }
}

