/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.DuplicateOrganizationException;
import com.liferay.portal.kernel.exception.OrganizationNameException;
import com.liferay.portal.kernel.exception.OrganizationParentException;
import com.liferay.portal.kernel.exception.OrganizationTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredOrganizationException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.tree.TreeModelTasksAdapter;
import com.liferay.portal.kernel.tree.TreePathUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.OrganizationIdComparator;
import com.liferay.portal.kernel.util.comparator.OrganizationNameComparator;
import com.liferay.portal.service.base.OrganizationLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.search.OrganizationUsersSearcher;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import com.liferay.users.admin.kernel.organization.types.OrganizationTypesSettings;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrganizationLocalServiceImpl
extends OrganizationLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationLocalServiceImpl.class);
    private static volatile OrganizationTypesSettings _organizationTypesSettings = ServiceProxyFactory.newServiceTrackedInstance(OrganizationTypesSettings.class, OrganizationLocalServiceImpl.class, "_organizationTypesSettings", false);
    private static volatile UserFileUploadsSettings _userFileUploadsSettings = ServiceProxyFactory.newServiceTrackedInstance(UserFileUploadsSettings.class, OrganizationLocalServiceImpl.class, "_userFileUploadsSettings", false);

    @Override
    public void addGroupOrganization(long groupId, long organizationId) {
        super.addGroupOrganization(groupId, organizationId);
        try {
            this.reindexUsers(organizationId);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public void addGroupOrganization(long groupId, Organization organization) {
        super.addGroupOrganization(groupId, organization);
        try {
            this.reindexUsers(organization);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public void addGroupOrganizations(long groupId, List<Organization> organizations) {
        super.addGroupOrganizations(groupId, organizations);
        try {
            this.reindexUsers(organizations);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public void addGroupOrganizations(long groupId, long[] organizationIds) {
        super.addGroupOrganizations(groupId, organizationIds);
        try {
            this.reindexUsers(organizationIds);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public Organization addOrganization(long userId, long parentOrganizationId, String name, boolean site) throws PortalException {
        String[] types = this.getTypes();
        return this.addOrganization(userId, parentOrganizationId, name, types[0], 0L, 0L, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, "", site, null);
    }

    @Override
    public Organization addOrganization(long userId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean site, ServiceContext serviceContext) throws PortalException {
        Organization parentOrganization;
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentOrganizationId = this.getParentOrganizationId(user.getCompanyId(), parentOrganizationId);
        this.validate(user.getCompanyId(), parentOrganizationId, name, type, countryId, statusId);
        long organizationId = this.counterLocalService.increment();
        Organization organization = this.organizationPersistence.create(organizationId);
        if (serviceContext != null) {
            organization.setUuid(serviceContext.getUuid());
        }
        organization.setCompanyId(user.getCompanyId());
        organization.setUserId(user.getUserId());
        organization.setUserName(user.getFullName());
        organization.setParentOrganizationId(parentOrganizationId);
        organization.setTreePath(organization.buildTreePath());
        organization.setName(name);
        organization.setType(type);
        organization.setRecursable(true);
        organization.setRegionId(regionId);
        organization.setCountryId(countryId);
        organization.setStatusId(statusId);
        organization.setComments(comments);
        organization.setExpandoBridgeAttributes(serviceContext);
        this.organizationPersistence.update(organization);
        long parentGroupId = 0L;
        if (parentOrganizationId != 0L && (parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId)) != null) {
            Group parentGroup = parentOrganization.getGroup();
            if (site && parentGroup.isSite()) {
                parentGroupId = parentOrganization.getGroupId();
            }
        }
        Group group = this.groupLocalService.addGroup(userId, parentGroupId, Organization.class.getName(), organizationId, 0L, this.getLocalizationMap(name), null, 3, false, 0, null, site, true, null);
        Role role = this.roleLocalService.getRole(organization.getCompanyId(), "Organization Owner");
        this.userGroupRoleLocalService.addUserGroupRoles(userId, group.getGroupId(), new long[]{role.getRoleId()});
        this.addOrganizationResources(userId, organization);
        if (serviceContext != null) {
            this.updateAsset(userId, organization, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        if (serviceContext == null || serviceContext.isIndexingEnabled()) {
            Indexer<Organization> indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
            indexer.reindex(organization);
        }
        return organization;
    }

    @Override
    public void addOrganizationResources(long userId, Organization organization) throws PortalException {
        String name = Organization.class.getName();
        this.resourceLocalService.addResources(organization.getCompanyId(), 0L, userId, name, organization.getOrganizationId(), false, false, false);
    }

    @Override
    public void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) {
        this.passwordPolicyRelLocalService.addPasswordPolicyRels(passwordPolicyId, Organization.class.getName(), organizationIds);
    }

    @Override
    public void deleteLogo(long organizationId) throws PortalException {
        Organization organization = this.getOrganization(organizationId);
        PortalUtil.updateImageId(organization, false, null, "logoId", 0L, 0, 0);
    }

    @Override
    public Organization deleteOrganization(long organizationId) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        return this.organizationLocalService.deleteOrganization(organization);
    }

    @Override
    @SystemEvent(type=1)
    public Organization deleteOrganization(Organization organization) throws PortalException {
        if (!CompanyThreadLocal.isDeleteInProcess()) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("usersOrgs", organization.getOrganizationId());
            int count1 = this.organizationPersistence.countByC_P(organization.getCompanyId(), organization.getOrganizationId());
            int count2 = this.userFinder.countByKeywords(organization.getCompanyId(), null, 0, params);
            if (count1 > 0 || count2 > 0) {
                throw new RequiredOrganizationException();
            }
        }
        this.assetEntryLocalService.deleteEntry(Organization.class.getName(), organization.getOrganizationId());
        this.addressLocalService.deleteAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this.emailAddressLocalService.deleteEmailAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this.expandoRowLocalService.deleteRows(organization.getOrganizationId());
        this.passwordPolicyRelLocalService.deletePasswordPolicyRel(Organization.class.getName(), organization.getOrganizationId());
        this.phoneLocalService.deletePhones(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this.websiteLocalService.deleteWebsites(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        Group group = organization.getGroup();
        if (group.isSite()) {
            group.setSite(false);
            this.groupPersistence.update(group);
        }
        this.groupLocalService.deleteGroup(group);
        String name = Organization.class.getName();
        this.resourceLocalService.deleteResource(organization.getCompanyId(), name, 4, organization.getOrganizationId());
        this.organizationPersistence.remove(organization);
        return organization;
    }

    @Override
    public Organization fetchOrganization(long companyId, String name) {
        return this.organizationPersistence.fetchByC_N(companyId, name);
    }

    @Override
    public String[] getChildrenTypes(String type) {
        return _organizationTypesSettings.getChildrenTypes(type);
    }

    @Override
    public List<Organization> getGroupUserOrganizations(long groupId, long userId) throws PortalException {
        long[] groupOrganizationIds = this.groupPersistence.getOrganizationPrimaryKeys(groupId);
        if (groupOrganizationIds.length == 0) {
            return Collections.emptyList();
        }
        long[] userOrganizationIds = this.userPersistence.getOrganizationPrimaryKeys(userId);
        if (userOrganizationIds.length == 0) {
            return Collections.emptyList();
        }
        Set<Long> organizationIds = SetUtil.intersect(groupOrganizationIds, userOrganizationIds);
        if (organizationIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Organization> organizations = new ArrayList<Organization>(organizationIds.size());
        for (Long organizationId : organizationIds) {
            organizations.add((Organization)this.organizationPersistence.findByPrimaryKey(organizationId));
        }
        return organizations;
    }

    @Override
    public List<Organization> getNoAssetOrganizations() {
        return this.organizationFinder.findO_ByNoAssets();
    }

    @Override
    public Organization getOrganization(long companyId, String name) throws PortalException {
        return this.organizationPersistence.findByC_N(companyId, name);
    }

    @Override
    public long getOrganizationId(long companyId, String name) {
        Organization organization = this.organizationPersistence.fetchByC_N(companyId, name);
        if (organization != null) {
            return organization.getOrganizationId();
        }
        return 0L;
    }

    @Override
    public List<Organization> getOrganizations(long userId, int start, int end, OrderByComparator<Organization> obc) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        List<Organization> organizations = ListUtil.copy(this.userPersistence.getOrganizations(userId));
        Iterator<Organization> iterator = organizations.iterator();
        while (iterator.hasNext()) {
            Organization organization = iterator.next();
            if (organization.getCompanyId() == user.getCompanyId()) continue;
            iterator.remove();
        }
        if (organizations.isEmpty()) {
            return organizations;
        }
        if (obc == null) {
            obc = new OrganizationNameComparator(true);
        }
        Collections.sort(organizations, obc);
        return ListUtil.subList(organizations, start, end);
    }

    @Override
    public List<Organization> getOrganizations(long companyId, long parentOrganizationId) {
        return this.getOrganizations(companyId, parentOrganizationId, -1, -1);
    }

    @Override
    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, int start, int end) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.findByCompanyId(companyId, start, end);
        }
        return this.organizationPersistence.findByC_P(companyId, parentOrganizationId, start, end);
    }

    @Override
    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, String name, int start, int end) {
        if (Validator.isNull(name)) {
            return this.organizationPersistence.findByC_P(companyId, parentOrganizationId, start, end);
        }
        return this.organizationPersistence.findByC_P_LikeN(companyId, parentOrganizationId, name, start, end);
    }

    @Override
    public List<Organization> getOrganizations(long companyId, String treePath) {
        return this.organizationPersistence.findByC_T(companyId, treePath);
    }

    @Override
    public List<Organization> getOrganizations(long[] organizationIds) throws PortalException {
        ArrayList<Organization> organizations = new ArrayList<Organization>(organizationIds.length);
        for (long organizationId : organizationIds) {
            Organization organization = this.getOrganization(organizationId);
            organizations.add(organization);
        }
        return organizations;
    }

    @Override
    public List<Object> getOrganizationsAndUsers(long companyId, long parentOrganizationId, int status, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0L, false, start, end, obc);
        return this.organizationFinder.findO_U_ByC_P(companyId, parentOrganizationId, queryDefinition);
    }

    @Override
    public int getOrganizationsAndUsersCount(long companyId, long parentOrganizationId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0L, false, -1, -1, null);
        return this.organizationFinder.countO_U_ByC_P(companyId, parentOrganizationId, queryDefinition);
    }

    @Override
    public int getOrganizationsCount(long companyId, long parentOrganizationId) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.countByCompanyId(companyId);
        }
        return this.organizationPersistence.countByC_P(companyId, parentOrganizationId);
    }

    @Override
    public int getOrganizationsCount(long companyId, long parentOrganizationId, String name) {
        if (Validator.isNull(name)) {
            return this.organizationPersistence.countByC_P(companyId, parentOrganizationId);
        }
        return this.organizationPersistence.countByC_P_LikeN(companyId, parentOrganizationId, name);
    }

    @Override
    public List<Organization> getParentOrganizations(long organizationId) throws PortalException {
        if (organizationId == 0L) {
            return new ArrayList<Organization>();
        }
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        return organization.getAncestors();
    }

    @Override
    public List<Organization> getSuborganizations(List<Organization> organizations) {
        ArrayList<Organization> allSuborganizations = new ArrayList<Organization>();
        for (Organization organization : organizations) {
            List<Organization> suborganizations = this.organizationPersistence.findByC_P(organization.getCompanyId(), organization.getOrganizationId());
            this.addSuborganizations(allSuborganizations, suborganizations);
        }
        return allSuborganizations;
    }

    @Override
    public List<Organization> getSuborganizations(long companyId, long organizationId) {
        return this.organizationPersistence.findByC_P(companyId, organizationId);
    }

    @Override
    public int getSuborganizationsCount(long companyId, long organizationId) {
        return this.organizationPersistence.countByC_P(companyId, organizationId);
    }

    @Override
    public List<Organization> getSubsetOrganizations(List<Organization> allOrganizations, List<Organization> availableOrganizations) {
        ArrayList<Organization> subsetOrganizations = new ArrayList<Organization>();
        for (Organization organization : allOrganizations) {
            if (!availableOrganizations.contains(organization)) continue;
            subsetOrganizations.add(organization);
        }
        return subsetOrganizations;
    }

    @Override
    public String[] getTypes() {
        return _organizationTypesSettings.getTypes();
    }

    @Override
    public long[] getUserOrganizationIds(long userId, boolean includeAdministrative) throws PortalException {
        if (!includeAdministrative) {
            return this.userPersistence.getOrganizationPrimaryKeys(userId);
        }
        Set<Long> organizationIds = SetUtil.fromArray(this.userPersistence.getOrganizationPrimaryKeys(userId));
        List<UserGroupRole> userGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner")) continue;
            Group group = userGroupRole.getGroup();
            organizationIds.add(group.getOrganizationId());
        }
        return ArrayUtil.toLongArray(organizationIds);
    }

    @Override
    public List<Organization> getUserOrganizations(long userId, boolean includeAdministrative) throws PortalException {
        if (!includeAdministrative) {
            return this.getUserOrganizations(userId);
        }
        HashSet<Organization> organizations = new HashSet<Organization>(this.getUserOrganizations(userId));
        List<UserGroupRole> userGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner")) continue;
            Group group = userGroupRole.getGroup();
            Organization organization = this.organizationPersistence.findByPrimaryKey(group.getOrganizationId());
            organizations.add(organization);
        }
        return new ArrayList<Organization>(organizations);
    }

    @Override
    public boolean hasPasswordPolicyOrganization(long passwordPolicyId, long organizationId) {
        return this.passwordPolicyRelLocalService.hasPasswordPolicyRel(passwordPolicyId, Organization.class.getName(), organizationId);
    }

    @Override
    public boolean hasUserOrganization(long userId, long organizationId, boolean inheritSuborganizations, boolean includeSpecifiedOrganization) throws PortalException {
        if (!inheritSuborganizations) {
            return this.userPersistence.containsOrganization(userId, organizationId);
        }
        ArrayList<Organization> organizationsTree = new ArrayList<Organization>();
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        if (includeSpecifiedOrganization) {
            organizationsTree.add(organization);
        } else {
            organizationsTree.addAll(organization.getSuborganizations());
        }
        if (!ListUtil.isEmpty(organizationsTree)) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("usersOrgsTree", organizationsTree);
            if (this.userFinder.countByUser(userId, params) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCountryEnabled(String type) {
        return _organizationTypesSettings.isCountryEnabled(type);
    }

    @Override
    public boolean isCountryRequired(String type) {
        return _organizationTypesSettings.isCountryRequired(type);
    }

    @Override
    public boolean isRootable(String type) {
        return _organizationTypesSettings.isRootable(type);
    }

    @Override
    public void rebuildTree(long companyId) throws PortalException {
        TreePathUtil.rebuildTree(companyId, 0L, "/", new TreeModelTasksAdapter<Organization>(){

            @Override
            public List<Organization> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                return OrganizationLocalServiceImpl.this.organizationPersistence.findByO_C_P(previousId, companyId, parentPrimaryKey, -1, size, new OrganizationIdComparator(true));
            }
        });
    }

    @Override
    public Hits search(long companyId, long parentOrganizationId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        String name = null;
        String type = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull(keywords)) {
            name = keywords;
            type = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andOperator, start, end, sort);
    }

    @Override
    public List<Organization> search(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, parentOrganizationId, keywords, type, regionId, countryId, params, start, end, new OrganizationNameComparator(true));
    }

    @Override
    public List<Organization> search(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Organization> obc) {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.findO_ByKeywords(companyId, parentOrganizationId, parentOrganizationIdComparator, keywords, type, regionId, countryId, params, start, end, obc);
    }

    @Override
    public List<Organization> search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, parentOrganizationId, name, type, street, city, zip, regionId, countryId, params, andOperator, start, end, new OrganizationNameComparator(true));
    }

    @Override
    public List<Organization> search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Organization> obc) {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.findO_ByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, name, type, street, city, zip, regionId, countryId, params, andOperator, start, end, obc);
    }

    @Override
    public Hits search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, String region, String country, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        try {
            Indexer<Organization> indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
            SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andSearch, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    public int searchCount(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params) {
        Indexer<Organization> indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.ORGANIZATIONS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            String parentOrganizationIdComparator = "=";
            if (parentOrganizationId == -1L) {
                parentOrganizationIdComparator = "!=";
            }
            return this.organizationFinder.countO_ByKeywords(companyId, parentOrganizationId, parentOrganizationIdComparator, keywords, type, regionId, countryId, params);
        }
        try {
            String name = null;
            String street = null;
            String city = null;
            String zip = null;
            boolean andOperator = false;
            if (Validator.isNotNull(keywords)) {
                name = keywords;
                street = keywords;
                city = keywords;
                zip = keywords;
            } else {
                andOperator = true;
            }
            if (params != null) {
                params.put("keywords", keywords);
            }
            SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, regionId, countryId, params, andOperator, -1, -1, null);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    public int searchCount(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) {
        Indexer<Organization> indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.ORGANIZATIONS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            String parentOrganizationIdComparator = "=";
            if (parentOrganizationId == -1L) {
                parentOrganizationIdComparator = "!=";
            }
            return this.organizationFinder.countO_ByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, name, type, street, city, zip, regionId, countryId, params, andOperator);
        }
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, regionId, countryId, params, andOperator, -1, -1, null);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    public BaseModelSearchResult<Organization> searchOrganizations(long companyId, long parentOrganizationId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        String name = null;
        String type = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull(keywords)) {
            name = keywords;
            type = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.searchOrganizations(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andOperator, start, end, sort);
    }

    @Override
    public BaseModelSearchResult<Organization> searchOrganizations(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, String region, String country, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        Indexer<Organization> indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andSearch, start, end, sort);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<Organization> organizations = UsersAdminUtil.getOrganizations(hits);
            if (organizations == null) continue;
            return new BaseModelSearchResult<Organization>(organizations, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Override
    public Hits searchOrganizationsAndUsers(long companyId, long parentOrganizationId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort[] sorts) throws PortalException {
        Indexer<?> indexer = OrganizationUsersSearcher.getInstance();
        SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, keywords, status, params, start, end, sorts);
        return indexer.search(searchContext);
    }

    @Override
    public int searchOrganizationsAndUsersCount(long companyId, long parentOrganizationId, String keywords, int status, LinkedHashMap<String, Object> params) throws PortalException {
        Indexer<?> indexer = OrganizationUsersSearcher.getInstance();
        SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, keywords, status, params, -1, -1, null);
        Hits hits = indexer.search(searchContext);
        return hits.getLength();
    }

    @Override
    public void unsetGroupOrganizations(long groupId, long[] organizationIds) {
        this.groupPersistence.removeOrganizations(groupId, organizationIds);
        try {
            this.reindexUsers(organizationIds);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) {
        this.passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId, Organization.class.getName(), organizationIds);
    }

    @Override
    public void updateAsset(long userId, Organization organization, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        Group companyGroup = company.getGroup();
        this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), null, null, Organization.class.getName(), organization.getOrganizationId(), organization.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, null, organization.getName(), "", null, null, null, 0, 0, null);
    }

    @Override
    public Organization updateOrganization(long companyId, long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean logo, byte[] logoBytes, boolean site, ServiceContext serviceContext) throws PortalException {
        parentOrganizationId = this.getParentOrganizationId(companyId, parentOrganizationId);
        this.validate(companyId, organizationId, parentOrganizationId, name, type, countryId, statusId);
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        long oldParentOrganizationId = organization.getParentOrganizationId();
        String oldName = organization.getName();
        organization.setParentOrganizationId(parentOrganizationId);
        organization.setTreePath(organization.buildTreePath());
        organization.setName(name);
        organization.setType(type);
        organization.setRecursable(true);
        organization.setRegionId(regionId);
        organization.setCountryId(countryId);
        organization.setStatusId(statusId);
        organization.setComments(comments);
        PortalUtil.updateImageId(organization, logo, logoBytes, "logoId", _userFileUploadsSettings.getImageMaxSize(), _userFileUploadsSettings.getImageMaxHeight(), _userFileUploadsSettings.getImageMaxWidth());
        organization.setExpandoBridgeAttributes(serviceContext);
        this.organizationPersistence.update(organization);
        Group group = organization.getGroup();
        long parentGroupId = group.getParentGroupId();
        boolean createSite = false;
        if (!group.isSite() && site) {
            createSite = true;
        }
        boolean organizationGroup = this.isOrganizationGroup(oldParentOrganizationId, group.getParentGroupId());
        if (createSite || organizationGroup) {
            if (parentOrganizationId != 0L) {
                Organization parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId);
                Group parentGroup = parentOrganization.getGroup();
                parentGroupId = site && parentGroup.isSite() ? parentOrganization.getGroupId() : 0L;
            } else {
                parentGroupId = 0L;
            }
        }
        if (createSite || !oldName.equals(name) || organizationGroup) {
            this.groupLocalService.updateGroup(group.getGroupId(), parentGroupId, this.getLocalizationMap(name), group.getDescriptionMap(), group.getType(), group.isManualMembership(), group.getMembershipRestriction(), group.getFriendlyURL(), group.isInheritContent(), group.isActive(), null);
        }
        if (group.isSite() != site) {
            this.groupLocalService.updateSite(group.getGroupId(), site);
            this.reindexUsers(organizationId);
        }
        if (createSite) {
            List<Organization> childOrganizations = this.organizationLocalService.getOrganizations(companyId, organizationId);
            for (Organization childOrganization : childOrganizations) {
                Group childGroup = childOrganization.getGroup();
                if (!childGroup.isSite() || childGroup.getParentGroupId() != 0L) continue;
                childGroup.setParentGroupId(group.getGroupId());
                this.groupLocalService.updateGroup(childGroup);
            }
        }
        if (serviceContext != null) {
            this.updateAsset(serviceContext.getUserId(), organization, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        Indexer<Organization> indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        if (!oldName.equals(name) || oldParentOrganizationId != parentOrganizationId) {
            long[] reindexOrganizationIds = this.getReindexOrganizationIds(organization);
            ArrayList<Organization> reindexOrganizations = new ArrayList<Organization>(reindexOrganizationIds.length);
            for (long reindexOrganizationId : reindexOrganizationIds) {
                Organization reindexOrganization = this.fetchOrganization(reindexOrganizationId);
                reindexOrganizations.add(reindexOrganization);
            }
            indexer.reindex((Organization)((Object)reindexOrganizations));
        } else {
            indexer.reindex(organization);
        }
        return organization;
    }

    protected void addSuborganizations(List<Organization> allSuborganizations, List<Organization> organizations) {
        for (Organization organization : organizations) {
            if (allSuborganizations.contains(organization)) continue;
            allSuborganizations.add(organization);
            List<Organization> suborganizations = this.organizationPersistence.findByC_P(organization.getCompanyId(), organization.getOrganizationId());
            this.addSuborganizations(allSuborganizations, suborganizations);
        }
    }

    protected SearchContext buildSearchContext(long companyId, long parentOrganizationId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort[] sorts) {
        String city = null;
        String country = null;
        String emailAddress = null;
        String firstName = null;
        String fullName = null;
        String lastName = null;
        String middleName = null;
        String name = null;
        String region = null;
        String screenName = null;
        String street = null;
        String type = null;
        String zip = null;
        boolean andOperator = false;
        if (Validator.isNotNull(keywords)) {
            city = keywords;
            country = keywords;
            emailAddress = keywords;
            firstName = keywords;
            fullName = keywords;
            lastName = keywords;
            middleName = keywords;
            name = keywords;
            region = keywords;
            screenName = keywords;
            street = keywords;
            type = keywords;
            zip = keywords;
        } else {
            andOperator = true;
        }
        if (params == null) {
            params = new LinkedHashMap();
        }
        params.put("keywords", keywords);
        params.put("usersOrgs", parentOrganizationId);
        SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andOperator, start, end, null);
        Map<String, Serializable> attributes = searchContext.getAttributes();
        attributes.put("emailAddress", (Serializable)((Object)emailAddress));
        attributes.put("firstName", (Serializable)((Object)firstName));
        attributes.put("fullName", (Serializable)((Object)fullName));
        attributes.put("lastName", (Serializable)((Object)lastName));
        attributes.put("middleName", (Serializable)((Object)middleName));
        attributes.put("screenName", (Serializable)((Object)screenName));
        attributes.put("status", Integer.valueOf(status));
        searchContext.setAttributes(attributes);
        if (sorts != null) {
            searchContext.setSorts(sorts);
        }
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        String regionCode = null;
        if (regionId != null) {
            Region region = (Region)this.regionPersistence.fetchByPrimaryKey(regionId);
            regionCode = region.getRegionCode();
        }
        String countryName = null;
        if (countryId != null) {
            Country country = (Country)this.countryPersistence.fetchByPrimaryKey(countryId);
            countryName = country.getName();
        }
        return this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, regionCode, countryName, params, andSearch, start, end, sort);
    }

    protected SearchContext buildSearchContext(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, String region, String country, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        String keywords;
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put("city", (Serializable)((Object)city));
        attributes.put("country", (Serializable)((Object)country));
        attributes.put("name", (Serializable)((Object)name));
        attributes.put("params", params);
        attributes.put("parentOrganizationId", (Serializable)((Object)String.valueOf(parentOrganizationId)));
        attributes.put("region", (Serializable)((Object)region));
        attributes.put("street", (Serializable)((Object)street));
        attributes.put("type", (Serializable)((Object)type));
        attributes.put("zip", (Serializable)((Object)zip));
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (params != null && Validator.isNotNull(keywords = (String)params.remove("keywords"))) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(sort);
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected long getParentOrganizationId(long companyId, long parentOrganizationId) {
        Organization parentOrganization;
        if (parentOrganizationId != 0L && ((parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId)) == null || companyId != parentOrganization.getCompanyId())) {
            parentOrganizationId = 0L;
        }
        return parentOrganizationId;
    }

    protected long[] getReindexOrganizationIds(Organization organization) throws PortalException {
        StringBundler sb = new StringBundler(3);
        sb.append("/");
        sb.append(organization.getOrganizationId());
        sb.append("/");
        List<Organization> organizations = this.organizationPersistence.findByC_T(organization.getCompanyId(), CustomSQLUtil.keywords(sb.toString())[0], -1, -1, new OrganizationNameComparator(true));
        long[] organizationIds = new long[organizations.size()];
        for (int i = 0; i < organizations.size(); ++i) {
            Organization curOrganization = organizations.get(i);
            curOrganization.setTreePath(curOrganization.buildTreePath());
            this.organizationPersistence.update(curOrganization);
            organizationIds[i] = curOrganization.getOrganizationId();
        }
        if (!ArrayUtil.contains(organizationIds, organization.getOrganizationId())) {
            organizationIds = ArrayUtil.append(organizationIds, organization.getOrganizationId());
        }
        return organizationIds;
    }

    protected boolean isOrganizationGroup(long organizationId, long groupId) {
        Organization organization;
        if (organizationId == 0L && groupId == 0L) {
            return true;
        }
        return organizationId != 0L && (organization = this.organizationPersistence.fetchByPrimaryKey(organizationId)).getGroupId() == groupId;
    }

    protected boolean isParentOrganization(long parentOrganizationId, long organizationId) throws PortalException {
        if (organizationId == 0L) {
            return false;
        }
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        String treePath = organization.getTreePath();
        return treePath.contains("/" + parentOrganizationId + "/");
    }

    protected boolean isUseCustomSQL(LinkedHashMap<String, Object> params) {
        return !MapUtil.isEmpty(params);
    }

    protected void reindex(long companyId, long[] userIds) throws PortalException {
        Indexer<User> indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.userLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property userId = PropertyFactoryUtil.forName("userId");
            dynamicQuery.add(userId.in(userIds));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(user -> {
            block3: {
                if (!user.isDefaultUser()) {
                    try {
                        Document document = indexer.getDocument((User)user);
                        indexableActionableDynamicQuery.addDocuments(document);
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn("Unable to index user " + user.getUserId(), pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(indexer.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    protected void reindexUsers(List<Organization> organizations) throws PortalException {
        for (Organization organization : organizations) {
            this.reindexUsers(organization);
        }
    }

    protected void reindexUsers(long organizationId) throws PortalException {
        Organization organization = this.getOrganization(organizationId);
        this.reindexUsers(organization);
    }

    protected void reindexUsers(long[] organizationIds) throws PortalException {
        for (long organizationId : organizationIds) {
            this.reindexUsers(organizationId);
        }
    }

    protected void reindexUsers(Organization organization) throws PortalException {
        long companyId = organization.getCompanyId();
        long[] userIds = this.getUserPrimaryKeys(organization.getOrganizationId());
        if (ArrayUtil.isNotEmpty(userIds)) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this.reindex(companyId, userIds);
                return null;
            });
        }
    }

    protected void validate(long companyId, long organizationId, long parentOrganizationId, String name, String type, long countryId, long statusId) throws PortalException {
        if (!ArrayUtil.contains(this.getTypes(), type)) {
            throw new OrganizationTypeException("Invalid organization type " + type);
        }
        if (parentOrganizationId == 0L) {
            if (!this.isRootable(type)) {
                throw new OrganizationParentException.MustBeRootable(type);
            }
        } else {
            Organization parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId);
            if (parentOrganization == null) {
                throw new OrganizationParentException("Organization " + parentOrganizationId + " does not exist");
            }
            Object[] childrenTypes = this.getChildrenTypes(parentOrganization.getType());
            if (childrenTypes.length == 0) {
                throw new OrganizationParentException.MustNotHaveChildren(type);
            }
            if (companyId != parentOrganization.getCompanyId() || parentOrganizationId == organizationId) {
                throw new OrganizationParentException();
            }
            if (!ArrayUtil.contains(childrenTypes, type)) {
                throw new OrganizationParentException.MustHaveValidChildType(type, parentOrganization.getType());
            }
        }
        if (organizationId > 0L && parentOrganizationId != 0L && this.isParentOrganization(organizationId, parentOrganizationId)) {
            throw new OrganizationParentException();
        }
        if (Validator.isNull(name)) {
            throw new OrganizationNameException();
        }
        Organization organization = this.organizationPersistence.fetchByC_N(companyId, name);
        if (organization != null && StringUtil.equalsIgnoreCase(organization.getName(), name) && (organizationId <= 0L || organization.getOrganizationId() != organizationId)) {
            throw new DuplicateOrganizationException("There is another organization named " + name);
        }
        boolean countryRequired = _organizationTypesSettings.isCountryRequired(type);
        if (countryRequired || countryId > 0L) {
            this.countryPersistence.findByPrimaryKey(countryId);
        }
        this.listTypeLocalService.validate(statusId, ListTypeConstants.ORGANIZATION_STATUS);
    }

    protected void validate(long companyId, long parentOrganizationId, String name, String type, long countryId, long statusId) throws PortalException {
        this.validate(companyId, 0L, parentOrganizationId, name, type, countryId, statusId);
    }
}

