/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.base.OrgLaborServiceBaseImpl;
import java.util.List;

public class OrgLaborServiceImpl
extends OrgLaborServiceBaseImpl {
    @Override
    public OrgLabor addOrgLabor(long organizationId, long typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException {
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "UPDATE");
        return this.orgLaborLocalService.addOrgLabor(organizationId, typeId, sunOpen, sunClose, monOpen, monClose, tueOpen, tueClose, wedOpen, wedClose, thuOpen, thuClose, friOpen, friClose, satOpen, satClose);
    }

    @Override
    public void deleteOrgLabor(long orgLaborId) throws PortalException {
        OrgLabor orgLabor = this.orgLaborPersistence.findByPrimaryKey(orgLaborId);
        OrganizationPermissionUtil.check(this.getPermissionChecker(), orgLabor.getOrganizationId(), "UPDATE");
        this.orgLaborLocalService.deleteOrgLabor(orgLaborId);
    }

    @Override
    public OrgLabor getOrgLabor(long orgLaborId) throws PortalException {
        OrgLabor orgLabor = this.orgLaborPersistence.findByPrimaryKey(orgLaborId);
        OrganizationPermissionUtil.check(this.getPermissionChecker(), orgLabor.getOrganizationId(), "VIEW");
        return orgLabor;
    }

    @Override
    public List<OrgLabor> getOrgLabors(long organizationId) throws PortalException {
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "VIEW");
        return this.orgLaborLocalService.getOrgLabors(organizationId);
    }

    @Override
    public OrgLabor updateOrgLabor(long orgLaborId, long typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException {
        OrgLabor orgLabor = this.orgLaborPersistence.findByPrimaryKey(orgLaborId);
        OrganizationPermissionUtil.check(this.getPermissionChecker(), orgLabor.getOrganizationId(), "UPDATE");
        return this.orgLaborLocalService.updateOrgLabor(orgLaborId, typeId, sunOpen, sunClose, monOpen, monClose, tueOpen, tueClose, wedOpen, wedClose, thuOpen, thuClose, friOpen, friClose, satOpen, satClose);
    }
}

