/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.service.base.OrgLaborLocalServiceBaseImpl;
import java.util.List;

public class OrgLaborLocalServiceImpl
extends OrgLaborLocalServiceBaseImpl {
    @Override
    public OrgLabor addOrgLabor(long organizationId, long typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException {
        this.validate(typeId);
        long orgLaborId = this.counterLocalService.increment();
        OrgLabor orgLabor = this.orgLaborPersistence.create(orgLaborId);
        orgLabor.setOrganizationId(organizationId);
        orgLabor.setTypeId(typeId);
        orgLabor.setSunOpen(sunOpen);
        orgLabor.setSunClose(sunClose);
        orgLabor.setMonOpen(monOpen);
        orgLabor.setMonClose(monClose);
        orgLabor.setTueOpen(tueOpen);
        orgLabor.setTueClose(tueClose);
        orgLabor.setWedOpen(wedOpen);
        orgLabor.setWedClose(wedClose);
        orgLabor.setThuOpen(thuOpen);
        orgLabor.setThuClose(thuClose);
        orgLabor.setFriOpen(friOpen);
        orgLabor.setFriClose(friClose);
        orgLabor.setSatOpen(satOpen);
        orgLabor.setSatClose(satClose);
        this.orgLaborPersistence.update(orgLabor);
        return orgLabor;
    }

    @Override
    public List<OrgLabor> getOrgLabors(long organizationId) {
        return this.orgLaborPersistence.findByOrganizationId(organizationId);
    }

    @Override
    public OrgLabor updateOrgLabor(long orgLaborId, long typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException {
        this.validate(typeId);
        OrgLabor orgLabor = this.orgLaborPersistence.findByPrimaryKey(orgLaborId);
        orgLabor.setTypeId(typeId);
        orgLabor.setSunOpen(sunOpen);
        orgLabor.setSunClose(sunClose);
        orgLabor.setMonOpen(monOpen);
        orgLabor.setMonClose(monClose);
        orgLabor.setTueOpen(tueOpen);
        orgLabor.setTueClose(tueClose);
        orgLabor.setWedOpen(wedOpen);
        orgLabor.setWedClose(wedClose);
        orgLabor.setThuOpen(thuOpen);
        orgLabor.setThuClose(thuClose);
        orgLabor.setFriOpen(friOpen);
        orgLabor.setFriClose(friClose);
        orgLabor.setSatOpen(satOpen);
        orgLabor.setSatClose(satClose);
        this.orgLaborPersistence.update(orgLabor);
        return orgLabor;
    }

    protected void validate(long typeId) throws PortalException {
        this.listTypeLocalService.validate(typeId, ListTypeConstants.ORGANIZATION_SERVICE);
    }
}

