/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.MembershipRequest;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.base.MembershipRequestServiceBaseImpl;

public class MembershipRequestServiceImpl
extends MembershipRequestServiceBaseImpl {
    @Override
    public MembershipRequest addMembershipRequest(long groupId, String comments, ServiceContext serviceContext) throws PortalException {
        return this.membershipRequestLocalService.addMembershipRequest(this.getUserId(), groupId, comments, serviceContext);
    }

    @Override
    public void deleteMembershipRequests(long groupId, long statusId) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "ASSIGN_MEMBERS");
        this.membershipRequestLocalService.deleteMembershipRequests(groupId, statusId);
    }

    @Override
    public MembershipRequest getMembershipRequest(long membershipRequestId) throws PortalException {
        MembershipRequest membershipRequest = this.membershipRequestLocalService.getMembershipRequest(membershipRequestId);
        GroupPermissionUtil.check(this.getPermissionChecker(), membershipRequest.getGroupId(), "ASSIGN_MEMBERS");
        return membershipRequest;
    }

    @Override
    public void updateStatus(long membershipRequestId, String reviewComments, long statusId, ServiceContext serviceContext) throws PortalException {
        MembershipRequest membershipRequest = this.membershipRequestPersistence.findByPrimaryKey(membershipRequestId);
        GroupPermissionUtil.check(this.getPermissionChecker(), membershipRequest.getGroupId(), "ASSIGN_MEMBERS");
        this.membershipRequestLocalService.updateStatus(this.getUserId(), membershipRequestId, reviewComments, statusId, true, serviceContext);
    }
}

