/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.service.base.ListTypeLocalServiceBaseImpl;
import java.util.List;
import java.util.Objects;

public class ListTypeLocalServiceImpl
extends ListTypeLocalServiceBaseImpl {
    @Override
    public ListType addListType(String name, String type) {
        ListType listType = this.listTypePersistence.fetchByN_T(name, type);
        if (listType != null) {
            return listType;
        }
        long listTypeId = this.counterLocalService.increment(ListType.class.getName());
        listType = this.listTypePersistence.create(listTypeId);
        listType.setName(name);
        listType.setType(type);
        this.listTypePersistence.update(listType);
        return listType;
    }

    @Override
    public ListType getListType(long listTypeId) throws PortalException {
        return this.listTypePersistence.findByPrimaryKey(listTypeId);
    }

    @Override
    public ListType getListType(String name, String type) {
        return this.listTypePersistence.fetchByN_T(name, type);
    }

    @Override
    public List<ListType> getListTypes(String type) {
        return this.listTypePersistence.findByType(type);
    }

    @Override
    public void validate(long listTypeId, long classNameId, String type) throws PortalException {
        ClassName className = this.classNameLocalService.getClassName(classNameId);
        this.validate(listTypeId, className.getValue() + type);
    }

    @Override
    public void validate(long listTypeId, String type) throws PortalException {
        ListType listType = this.listTypePersistence.fetchByPrimaryKey(listTypeId);
        if (listType == null || !Objects.equals(listType.getType(), type)) {
            NoSuchListTypeException nslte = new NoSuchListTypeException();
            nslte.setType(type);
            throw nslte;
        }
    }
}

