/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.DummyWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.layoutconfiguration.util.velocity.InitColumnProcessor;
import com.liferay.portal.model.impl.LayoutTemplateImpl;
import com.liferay.portal.service.base.LayoutTemplateLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

@Transactional(enabled=false)
public class LayoutTemplateLocalServiceImpl
extends LayoutTemplateLocalServiceBaseImpl {
    public static final Set<String> supportedLangTypes = new HashSet<String>(Arrays.asList("vm", "ftl"));
    private static final Log _log = LogFactoryUtil.getLog(LayoutTemplateLocalServiceImpl.class);
    private static final Map<String, Map<String, LayoutTemplate>> _customThemes = new HashMap<String, Map<String, LayoutTemplate>>();
    private static final Map<String, LayoutTemplate> _portalCustom = new LinkedHashMap<String, LayoutTemplate>();
    private static final Map<String, LayoutTemplate> _portalStandard = new HashMap<String, LayoutTemplate>();
    private static final Map<String, Map<String, LayoutTemplate>> _standardThemes = new HashMap<String, Map<String, LayoutTemplate>>();
    private static final Map<String, LayoutTemplate> _warCustom = new LinkedHashMap<String, LayoutTemplate>();
    private static final Map<String, LayoutTemplate> _warStandard = new HashMap<String, LayoutTemplate>();

    @Override
    public String getContent(String layoutTemplateId, boolean standard, String themeId) {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(layoutTemplateId, standard, themeId);
        if (layoutTemplate == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("Layout template " + layoutTemplateId + " does not exist");
            }
            if ((layoutTemplate = this.getLayoutTemplate(PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID, standard, themeId)) == null) {
                StringBundler sb = new StringBundler(5);
                sb.append("Layout template ");
                sb.append(layoutTemplateId);
                sb.append(" and default layout template ");
                sb.append(PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID);
                sb.append(" do not exist");
                _log.error(sb.toString());
                return "";
            }
        }
        if (PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return layoutTemplate.getContent();
        }
        try {
            return layoutTemplate.getUncachedContent();
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
    }

    @Override
    public String getLangType(String layoutTemplateId, boolean standard, String themeId) {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(layoutTemplateId, standard, themeId);
        if (layoutTemplate == null) {
            return "vm";
        }
        return this._getSupportedLangType(layoutTemplate);
    }

    @Override
    public LayoutTemplate getLayoutTemplate(String layoutTemplateId, boolean standard, String themeId) {
        if (Validator.isNull(layoutTemplateId)) {
            return null;
        }
        LayoutTemplate layoutTemplate = null;
        if (themeId != null) {
            if (standard) {
                Map<String, LayoutTemplate> themesStandard = this._getThemesStandard(themeId);
                layoutTemplate = themesStandard.get(layoutTemplateId);
            } else {
                Map<String, LayoutTemplate> themesCustom = this._getThemesCustom(themeId);
                layoutTemplate = themesCustom.get(layoutTemplateId);
            }
            if (layoutTemplate != null) {
                return layoutTemplate;
            }
        }
        if (standard) {
            layoutTemplate = _warStandard.get(layoutTemplateId);
            if (layoutTemplate == null) {
                layoutTemplate = _portalStandard.get(layoutTemplateId);
            }
        } else {
            layoutTemplate = _warCustom.get(layoutTemplateId);
            if (layoutTemplate == null) {
                layoutTemplate = _portalCustom.get(layoutTemplateId);
            }
        }
        return layoutTemplate;
    }

    @Override
    public List<LayoutTemplate> getLayoutTemplates() {
        ArrayList<LayoutTemplate> customLayoutTemplates = new ArrayList<LayoutTemplate>(_portalCustom.size() + _warCustom.size());
        customLayoutTemplates.addAll(_portalCustom.values());
        customLayoutTemplates.addAll(_warCustom.values());
        return customLayoutTemplates;
    }

    @Override
    public List<LayoutTemplate> getLayoutTemplates(String themeId) {
        String layoutTemplateId;
        Map<String, LayoutTemplate> themesCustom = this._getThemesCustom(themeId);
        ArrayList<LayoutTemplate> customLayoutTemplates = new ArrayList<LayoutTemplate>(_portalCustom.size() + _warCustom.size() + themesCustom.size());
        for (Map.Entry<String, LayoutTemplate> entry : _portalCustom.entrySet()) {
            layoutTemplateId = entry.getKey();
            LayoutTemplate themeCustomLayoutTemplate = themesCustom.get(layoutTemplateId);
            if (themeCustomLayoutTemplate != null) {
                customLayoutTemplates.add(themeCustomLayoutTemplate);
                continue;
            }
            LayoutTemplate warCustomLayoutTemplate = _warCustom.get(layoutTemplateId);
            if (warCustomLayoutTemplate != null) {
                customLayoutTemplates.add(warCustomLayoutTemplate);
                continue;
            }
            customLayoutTemplates.add(entry.getValue());
        }
        for (Map.Entry<String, LayoutTemplate> entry : _warCustom.entrySet()) {
            layoutTemplateId = entry.getKey();
            if (_portalCustom.containsKey(layoutTemplateId) || themesCustom.containsKey(layoutTemplateId)) continue;
            customLayoutTemplates.add(_warCustom.get(layoutTemplateId));
        }
        for (Map.Entry<String, LayoutTemplate> entry : themesCustom.entrySet()) {
            layoutTemplateId = entry.getKey();
            if (_portalCustom.containsKey(layoutTemplateId) || _warCustom.containsKey(layoutTemplateId)) continue;
            customLayoutTemplates.add(themesCustom.get(layoutTemplateId));
        }
        return customLayoutTemplates;
    }

    @Override
    public List<LayoutTemplate> init(ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        return this.init(null, servletContext, xmls, pluginPackage);
    }

    @Override
    public List<LayoutTemplate> init(String servletContextName, ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        LinkedHashSet<LayoutTemplate> layoutTemplates = new LinkedHashSet<LayoutTemplate>();
        try {
            for (String xml : xmls) {
                layoutTemplates.addAll(this._readLayoutTemplates(servletContextName, servletContext, xml, pluginPackage));
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return new ArrayList<LayoutTemplate>(layoutTemplates);
    }

    @Override
    public void readLayoutTemplate(String servletContextName, ServletContext servletContext, Set<LayoutTemplate> layoutTemplates, Element element, boolean standard, String themeId, PluginPackage pluginPackage) {
        Map<String, LayoutTemplate> installedLayoutTemplates = null;
        installedLayoutTemplates = themeId != null ? (standard ? this._getThemesStandard(themeId) : this._getThemesCustom(themeId)) : (servletContextName != null ? (standard ? _warStandard : _warCustom) : (standard ? _portalStandard : _portalCustom));
        List<Element> layoutTemplateElements = element.elements("layout-template");
        for (Element layoutTemplateElement : layoutTemplateElements) {
            String layoutTemplateId = layoutTemplateElement.attributeValue("id");
            LayoutTemplate layoutTemplateModel = installedLayoutTemplates.get(layoutTemplateId);
            if (layoutTemplateModel == null) {
                layoutTemplateModel = new LayoutTemplateImpl(layoutTemplateId);
                installedLayoutTemplates.put(layoutTemplateId, layoutTemplateModel);
            }
            PluginSetting pluginSetting = this.pluginSettingLocalService.getDefaultPluginSetting();
            layoutTemplateModel.setPluginPackage(pluginPackage);
            layoutTemplateModel.setServletContext(servletContext);
            if (servletContextName != null) {
                layoutTemplateModel.setServletContextName(servletContextName);
            }
            layoutTemplateModel.setStandard(standard);
            layoutTemplateModel.setThemeId(themeId);
            String templateName = GetterUtil.getString(layoutTemplateElement.attributeValue("name"));
            if (Validator.isNotNull(templateName)) {
                layoutTemplateModel.setName(templateName);
            }
            layoutTemplateModel.setTemplatePath(GetterUtil.getString(layoutTemplateElement.elementText("template-path"), layoutTemplateModel.getTemplatePath()));
            layoutTemplateModel.setThumbnailPath(GetterUtil.getString(layoutTemplateElement.elementText("thumbnail-path"), layoutTemplateModel.getThumbnailPath()));
            String content = null;
            try {
                content = HttpUtil.URLtoString(servletContext.getResource(layoutTemplateModel.getTemplatePath()));
            }
            catch (Exception e) {
                _log.error(StringBundler.concat("Unable to get content at template path ", layoutTemplateModel.getTemplatePath(), ": ", e.getMessage()));
            }
            if (Validator.isNull(content)) {
                _log.error("No content found at template path " + layoutTemplateModel.getTemplatePath());
            } else {
                StringBundler sb = new StringBundler(3);
                sb.append(themeId);
                if (standard) {
                    sb.append("_STANDARD_");
                } else {
                    sb.append("_CUSTOM_");
                }
                sb.append(layoutTemplateId);
                String velocityTemplateId = sb.toString();
                layoutTemplateModel.setContent(content);
                layoutTemplateModel.setColumns(this._getColumns(velocityTemplateId, content, this._getSupportedLangType(layoutTemplateModel)));
            }
            Element rolesElement = layoutTemplateElement.element("roles");
            if (rolesElement != null) {
                List<Element> roleNameElements = rolesElement.elements("role-name");
                for (Element roleNameElement : roleNameElements) {
                    pluginSetting.addRole(roleNameElement.getText());
                }
            }
            layoutTemplateModel.setDefaultPluginSetting(pluginSetting);
            if (layoutTemplates == null) continue;
            layoutTemplates.add(layoutTemplateModel);
        }
    }

    @Override
    public void uninstallLayoutTemplate(String layoutTemplateId, boolean standard) {
        String templateId = null;
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(layoutTemplateId, standard, null);
        try {
            if (standard) {
                templateId = "null_STANDARD_" + layoutTemplateId;
                TemplateResourceLoaderUtil.clearCache(this._getSupportedLangType(layoutTemplate), templateId);
                _warStandard.remove(layoutTemplateId);
            } else {
                templateId = "null_CUSTOM_" + layoutTemplateId;
                TemplateResourceLoaderUtil.clearCache(this._getSupportedLangType(layoutTemplate), templateId);
                _warCustom.remove(layoutTemplateId);
            }
        }
        catch (Exception e) {
            _log.error("Unable to uninstall layout template " + layoutTemplateId, e);
        }
    }

    @Override
    public void uninstallLayoutTemplates(String themeId) {
        Map<String, LayoutTemplate> themesStandard = this._getThemesStandard(themeId);
        for (Map.Entry<String, LayoutTemplate> entry : themesStandard.entrySet()) {
            LayoutTemplate layoutTemplate = entry.getValue();
            String templateId = themeId + "_STANDARD_" + layoutTemplate.getLayoutTemplateId();
            try {
                TemplateResourceLoaderUtil.clearCache(this._getSupportedLangType(layoutTemplate), templateId);
            }
            catch (Exception e) {
                _log.error("Unable to uninstall layout template " + layoutTemplate.getLayoutTemplateId(), e);
            }
        }
        themesStandard.clear();
        Map<String, LayoutTemplate> themesCustom = this._getThemesCustom(themeId);
        for (Map.Entry<String, LayoutTemplate> entry : themesCustom.entrySet()) {
            LayoutTemplate layoutTemplate = entry.getValue();
            String templateId = themeId + "_CUSTOM_" + layoutTemplate.getLayoutTemplateId();
            try {
                TemplateResourceLoaderUtil.clearCache(this._getSupportedLangType(layoutTemplate), templateId);
            }
            catch (Exception e) {
                _log.error("Unable to uninstall layout template " + layoutTemplate.getLayoutTemplateId(), e);
            }
        }
        themesCustom.clear();
    }

    private List<String> _getColumns(String templateId, String templateContent, String langType) {
        try {
            InitColumnProcessor processor = new InitColumnProcessor();
            Template template = TemplateManagerUtil.getTemplate(langType, new StringTemplateResource(templateId, templateContent), false);
            template.put("processor", processor);
            template.processTemplate(new DummyWriter());
            return ListUtil.sort(processor.getColumns());
        }
        catch (Exception e) {
            _log.error("Unable to get layout template columns", e);
            return new ArrayList<String>();
        }
    }

    private String _getSupportedLangType(LayoutTemplate layoutTemplate) {
        String langType;
        String templatePath = layoutTemplate.getTemplatePath();
        int index = templatePath.lastIndexOf(".");
        if (index != -1 && supportedLangTypes.contains(langType = templatePath.substring(index + 1))) {
            return langType;
        }
        return "vm";
    }

    private Map<String, LayoutTemplate> _getThemesCustom(String themeId) {
        Map<String, LayoutTemplate> layoutTemplates = _customThemes.get(themeId);
        if (layoutTemplates == null) {
            layoutTemplates = new LinkedHashMap<String, LayoutTemplate>();
            _customThemes.put(themeId, layoutTemplates);
        }
        return layoutTemplates;
    }

    private Map<String, LayoutTemplate> _getThemesStandard(String themeId) {
        Map<String, LayoutTemplate> layoutTemplates = _standardThemes.get(themeId);
        if (layoutTemplates == null) {
            layoutTemplates = new LinkedHashMap<String, LayoutTemplate>();
            _standardThemes.put(themeId, layoutTemplates);
        }
        return layoutTemplates;
    }

    private Set<LayoutTemplate> _readLayoutTemplates(String servletContextName, ServletContext servletContext, String xml, PluginPackage pluginPackage) throws Exception {
        Element customElement;
        HashSet<LayoutTemplate> layoutTemplates = new HashSet<LayoutTemplate>();
        if (xml == null) {
            return layoutTemplates;
        }
        Document document = UnsecureSAXReaderUtil.read(xml, true);
        Element rootElement = document.getRootElement();
        Element standardElement = rootElement.element("standard");
        if (standardElement != null) {
            this.readLayoutTemplate(servletContextName, servletContext, layoutTemplates, standardElement, true, null, pluginPackage);
        }
        if ((customElement = rootElement.element("custom")) != null) {
            this.readLayoutTemplate(servletContextName, servletContext, layoutTemplates, customElement, false, null, pluginPackage);
        }
        return layoutTemplates;
    }
}

