/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.base.LayoutSetServiceBaseImpl;
import java.io.File;
import java.io.InputStream;

public class LayoutSetServiceImpl
extends LayoutSetServiceBaseImpl {
    @Override
    public void updateLayoutSetPrototypeLinkEnabled(long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled, String layoutSetPrototypeUuid) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "UPDATE");
        LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
        if (layoutSet.isLayoutSetPrototypeLinkEnabled() && !layoutSetPrototypeLinkEnabled) {
            PortalPermissionUtil.check(this.getPermissionChecker(), "UNLINK_LAYOUT_SET_PROTOTYPE");
        }
        this.layoutSetLocalService.updateLayoutSetPrototypeLinkEnabled(groupId, privateLayout, layoutSetPrototypeLinkEnabled, layoutSetPrototypeUuid);
    }

    @Override
    public void updateLogo(long groupId, boolean privateLayout, boolean logo, byte[] bytes) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "MANAGE_LAYOUTS");
        this.layoutSetLocalService.updateLogo(groupId, privateLayout, logo, bytes);
    }

    @Override
    public void updateLogo(long groupId, boolean privateLayout, boolean logo, File file) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "MANAGE_LAYOUTS");
        this.layoutSetLocalService.updateLogo(groupId, privateLayout, logo, file);
    }

    @Override
    public void updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream inputStream) throws PortalException {
        this.updateLogo(groupId, privateLayout, logo, inputStream, true);
    }

    @Override
    public void updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream inputStream, boolean cleanUpStream) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "MANAGE_LAYOUTS");
        this.layoutSetLocalService.updateLogo(groupId, privateLayout, logo, inputStream, cleanUpStream);
    }

    @Override
    public LayoutSet updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "MANAGE_LAYOUTS");
        this.pluginSettingLocalService.checkPermission(this.getUserId(), themeId, "theme");
        return this.layoutSetLocalService.updateLookAndFeel(groupId, privateLayout, themeId, colorSchemeId, css);
    }

    @Override
    public LayoutSet updateSettings(long groupId, boolean privateLayout, String settings) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "MANAGE_LAYOUTS");
        return this.layoutSetLocalService.updateSettings(groupId, privateLayout, settings);
    }

    @Override
    public LayoutSet updateVirtualHost(long groupId, boolean privateLayout, String virtualHost) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "UPDATE");
        return this.layoutSetLocalService.updateVirtualHost(groupId, privateLayout, virtualHost);
    }
}

