/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.LayoutSetPrototypeServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutSetPrototypeServiceImpl
extends LayoutSetPrototypeServiceBaseImpl {
    @Override
    public LayoutSetPrototype addLayoutSetPrototype(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check(this.getPermissionChecker(), "ADD_LAYOUT_PROTOTYPE");
        User user = this.getUser();
        return this.layoutSetPrototypeLocalService.addLayoutSetPrototype(user.getUserId(), user.getCompanyId(), nameMap, descriptionMap, active, layoutsUpdateable, serviceContext);
    }

    @Override
    public void deleteLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException {
        LayoutSetPrototypePermissionUtil.check(this.getPermissionChecker(), layoutSetPrototypeId, "DELETE");
        this.layoutSetPrototypeLocalService.deleteLayoutSetPrototype(layoutSetPrototypeId);
    }

    @Override
    public LayoutSetPrototype fetchLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException {
        LayoutSetPrototypePermissionUtil.check(this.getPermissionChecker(), layoutSetPrototypeId, "VIEW");
        return this.layoutSetPrototypeLocalService.fetchLayoutSetPrototype(layoutSetPrototypeId);
    }

    @Override
    public LayoutSetPrototype getLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException {
        LayoutSetPrototypePermissionUtil.check(this.getPermissionChecker(), layoutSetPrototypeId, "VIEW");
        return this.layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
    }

    @Override
    public List<LayoutSetPrototype> search(long companyId, Boolean active, OrderByComparator<LayoutSetPrototype> obc) throws PortalException {
        ArrayList<LayoutSetPrototype> filteredLayoutSetPrototypes = new ArrayList<LayoutSetPrototype>();
        List<LayoutSetPrototype> layoutSetPrototypes = this.layoutSetPrototypeLocalService.search(companyId, active, -1, -1, obc);
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            if (!LayoutSetPrototypePermissionUtil.contains(this.getPermissionChecker(), layoutSetPrototype.getLayoutSetPrototypeId(), "VIEW")) continue;
            filteredLayoutSetPrototypes.add(layoutSetPrototype);
        }
        return filteredLayoutSetPrototypes;
    }

    @Override
    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException {
        LayoutSetPrototypePermissionUtil.check(this.getPermissionChecker(), layoutSetPrototypeId, "UPDATE");
        return this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototypeId, nameMap, descriptionMap, active, layoutsUpdateable, serviceContext);
    }

    @Override
    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, String settings) throws PortalException {
        LayoutSetPrototypePermissionUtil.check(this.getPermissionChecker(), layoutSetPrototypeId, "UPDATE");
        return this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototypeId, settings);
    }
}

