/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutSetPrototypeException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.service.base.LayoutSetPrototypeLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutSetPrototypeLocalServiceImpl
extends LayoutSetPrototypeLocalServiceBaseImpl {
    @Override
    public LayoutSetPrototype addLayoutSetPrototype(long userId, long companyId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long layoutSetPrototypeId = this.counterLocalService.increment();
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.create(layoutSetPrototypeId);
        layoutSetPrototype.setUuid(serviceContext.getUuid());
        layoutSetPrototype.setCompanyId(companyId);
        layoutSetPrototype.setUserId(userId);
        layoutSetPrototype.setUserName(user.getFullName());
        layoutSetPrototype.setCreateDate(serviceContext.getCreateDate(now));
        layoutSetPrototype.setModifiedDate(serviceContext.getModifiedDate(now));
        layoutSetPrototype.setNameMap(nameMap);
        layoutSetPrototype.setDescriptionMap(descriptionMap);
        layoutSetPrototype.setActive(active);
        UnicodeProperties settingsProperties = layoutSetPrototype.getSettingsProperties();
        settingsProperties.put("layoutsUpdateable", String.valueOf(layoutsUpdateable));
        layoutSetPrototype.setSettingsProperties(settingsProperties);
        this.layoutSetPrototypePersistence.update(layoutSetPrototype);
        this.resourceLocalService.addResources(companyId, 0L, userId, LayoutSetPrototype.class.getName(), layoutSetPrototype.getLayoutSetPrototypeId(), false, true, false);
        String friendlyURL = "/template-" + layoutSetPrototype.getLayoutSetPrototypeId();
        Group group = this.groupLocalService.addGroup(userId, 0L, LayoutSetPrototype.class.getName(), layoutSetPrototype.getLayoutSetPrototypeId(), 0L, layoutSetPrototype.getNameMap(), null, 0, true, 0, friendlyURL, false, true, serviceContext);
        if (GetterUtil.getBoolean(serviceContext.getAttribute("addDefaultLayout"), true)) {
            this.layoutLocalService.addLayout(userId, group.getGroupId(), true, 0L, "Home", null, null, "portlet", false, "/home", serviceContext);
        }
        return layoutSetPrototype;
    }

    @Override
    @SystemEvent(action=1, type=1)
    public LayoutSetPrototype deleteLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype) throws PortalException {
        if (!CompanyThreadLocal.isDeleteInProcess() && this.layoutSetPersistence.countByLayoutSetPrototypeUuid_Head(layoutSetPrototype.getUuid(), false) > 0) {
            throw new RequiredLayoutSetPrototypeException();
        }
        Group group = layoutSetPrototype.getGroup();
        this.groupLocalService.deleteGroup(group);
        this.resourceLocalService.deleteResource(layoutSetPrototype.getCompanyId(), LayoutSetPrototype.class.getName(), 4, layoutSetPrototype.getLayoutSetPrototypeId());
        this.layoutSetPrototypePersistence.remove(layoutSetPrototype);
        return layoutSetPrototype;
    }

    @Override
    public LayoutSetPrototype deleteLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        return this.deleteLayoutSetPrototype(layoutSetPrototype);
    }

    @Override
    public void deleteLayoutSetPrototypes() throws PortalException {
        List<LayoutSetPrototype> layoutSetPrototypes = this.layoutSetPrototypePersistence.findAll();
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            this.layoutSetPrototypeLocalService.deleteLayoutSetPrototype(layoutSetPrototype);
        }
    }

    @Override
    public void deleteNondefaultLayoutSetPrototypes(long companyId) throws PortalException {
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        List<LayoutSetPrototype> layoutSetPrototypes = this.layoutSetPrototypePersistence.findByCompanyId(companyId);
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            if (layoutSetPrototype.getUserId() == defaultUserId) continue;
            this.deleteLayoutSetPrototype(layoutSetPrototype);
        }
    }

    @Override
    public LayoutSetPrototype getLayoutSetPrototypeByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.layoutSetPrototypePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    @Override
    public List<LayoutSetPrototype> getLayoutSetPrototypes(long companyId) {
        return this.layoutSetPrototypePersistence.findByCompanyId(companyId);
    }

    @Override
    public List<LayoutSetPrototype> search(long companyId, Boolean active, int start, int end, OrderByComparator<LayoutSetPrototype> obc) {
        if (active != null) {
            return this.layoutSetPrototypePersistence.findByC_A(companyId, active, start, end, obc);
        }
        return this.layoutSetPrototypePersistence.findByCompanyId(companyId, start, end, obc);
    }

    @Override
    public int searchCount(long companyId, Boolean active) {
        if (active != null) {
            return this.layoutSetPrototypePersistence.countByC_A(companyId, active);
        }
        return this.layoutSetPrototypePersistence.countByCompanyId(companyId);
    }

    @Override
    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        layoutSetPrototype.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutSetPrototype.setNameMap(nameMap);
        layoutSetPrototype.setDescriptionMap(descriptionMap);
        layoutSetPrototype.setActive(active);
        UnicodeProperties settingsProperties = layoutSetPrototype.getSettingsProperties();
        settingsProperties.put("layoutsUpdateable", String.valueOf(layoutsUpdateable));
        layoutSetPrototype.setSettingsProperties(settingsProperties);
        this.layoutSetPrototypePersistence.update(layoutSetPrototype);
        return layoutSetPrototype;
    }

    @Override
    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, String settings) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        layoutSetPrototype.setModifiedDate(new Date());
        layoutSetPrototype.setSettings(settings);
        this.layoutSetPrototypePersistence.update(layoutSetPrototype);
        UnicodeProperties settingsProperties = layoutSetPrototype.getSettingsProperties();
        if (!settingsProperties.containsKey("customJspServletContextName")) {
            return layoutSetPrototype;
        }
        Group group = this.groupLocalService.getLayoutSetPrototypeGroup(layoutSetPrototype.getCompanyId(), layoutSetPrototypeId);
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("customJspServletContextName", settingsProperties.getProperty("customJspServletContextName"));
        group.setTypeSettings(typeSettingsProperties.toString());
        this.groupPersistence.update(group);
        return layoutSetPrototype;
    }
}

