/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.LayoutSetPrototypeUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Date;

public class LayoutSetPrototypeLayoutSetModelListener
extends BaseModelListener<LayoutSet> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeLayoutSetModelListener.class);

    @Override
    public void onAfterCreate(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet, layoutSet.getModifiedDate());
    }

    @Override
    public void onAfterRemove(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet, new Date());
    }

    @Override
    public void onAfterUpdate(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet, layoutSet.getModifiedDate());
    }

    protected void updateLayoutSetPrototype(LayoutSet layoutSet, Date modifiedDate) {
        if (layoutSet == null || !layoutSet.isHead()) {
            return;
        }
        Group group = null;
        try {
            group = layoutSet.getGroup();
            if (!group.isLayoutSetPrototype()) {
                return;
            }
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(pe, pe);
            }
            return;
        }
        try {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype(group.getClassPK());
            layoutSetPrototype.setModifiedDate(modifiedDate);
            UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
            settingsProperties.remove("merge-fail-count");
            LayoutSetPrototypeUtil.update(layoutSetPrototype);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }
}

