/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Date;

public class LayoutSetPrototypeLayoutModelListener
extends BaseModelListener<Layout> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeLayoutModelListener.class);

    @Override
    public void onAfterCreate(Layout layout) {
        this.updateLayoutSetPrototype(layout, layout.getModifiedDate());
    }

    @Override
    public void onAfterRemove(Layout layout) {
        this.updateLayoutSetPrototype(layout, new Date());
    }

    @Override
    public void onAfterUpdate(Layout layout) {
        this.updateLayoutSetPrototype(layout, layout.getModifiedDate());
    }

    protected void updateLayoutSetPrototype(Layout layout, Date modifiedDate) {
        if (layout == null) {
            return;
        }
        Group group = layout.getGroup();
        if (group == null || !group.isLayoutSetPrototype()) {
            return;
        }
        try {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype(group.getClassPK());
            layoutSetPrototype.setModifiedDate(modifiedDate);
            LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype(layoutSetPrototype);
            LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
            layoutSet.setModifiedDate(layout.getModifiedDate());
            UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
            settingsProperties.remove("merge-fail-count");
            LayoutSetLocalServiceUtil.updateLayoutSet(layoutSet);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }
}

