/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.exception.LayoutSetVirtualHostException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetStagingHandler;
import com.liferay.portal.kernel.model.LayoutSetVersion;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.version.VersionServiceListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutSetImpl;
import com.liferay.portal.model.impl.LayoutSetModelImpl;
import com.liferay.portal.service.base.LayoutSetLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public class LayoutSetLocalServiceImpl
extends LayoutSetLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetLocalServiceImpl.class);

    @Override
    public LayoutSet addLayoutSet(long groupId, boolean privateLayout) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Date now = new Date();
        LayoutSet draftLayoutSet = this.create();
        draftLayoutSet.setGroupId(groupId);
        draftLayoutSet.setCompanyId(group.getCompanyId());
        draftLayoutSet.setCreateDate(now);
        draftLayoutSet.setModifiedDate(now);
        draftLayoutSet.setPrivateLayout(privateLayout);
        draftLayoutSet = this.initLayoutSet(draftLayoutSet);
        return this.updateDraft(draftLayoutSet);
    }

    @Override
    public LayoutSet checkout(LayoutSet layoutSet, int version) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public LayoutSet delete(LayoutSet layoutSet) throws PortalException {
        return this.layoutSetPersistence.remove(layoutSet);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public LayoutSet deleteDraft(LayoutSet layoutSet) throws PortalException {
        return this.layoutSetPersistence.remove(layoutSet);
    }

    @Override
    public void deleteLayoutSet(long groupId, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        block8: {
            LayoutSet layoutSet;
            Group group;
            block7: {
                group = this.groupPersistence.findByPrimaryKey(groupId);
                layoutSet = this.layoutSetPersistence.findByG_P_Head(groupId, privateLayout, false);
                serviceContext.setAttribute("updatePageCount", Boolean.FALSE);
                this.layoutLocalService.deleteLayouts(groupId, privateLayout, serviceContext);
                if (group.isStagingGroup() || !group.isOrganization() || !group.isSite()) {
                    try {
                        this.imageLocalService.deleteImage(layoutSet.getLogoId());
                    }
                    catch (NoSuchImageException nsie) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn("Unable to delete image " + layoutSet.getLogoId(), nsie);
                    }
                }
            }
            if (!group.isStagingGroup() && group.isOrganization() && group.isSite()) {
                LayoutSet draftLayoutSet = this.getDraft(layoutSet);
                draftLayoutSet = this.initLayoutSet(draftLayoutSet);
                draftLayoutSet.setLogoId(layoutSet.getLogoId());
                layoutSet = this.updateDraft(draftLayoutSet);
            } else {
                this.layoutSetPersistence.removeByG_P_Head(groupId, privateLayout, false);
            }
            try {
                this.virtualHostPersistence.removeByC_L(layoutSet.getCompanyId(), layoutSet.getLayoutSetId());
            }
            catch (NoSuchVirtualHostException nsvhe) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug(nsvhe, nsvhe);
            }
        }
    }

    @Override
    public LayoutSet fetchDraft(LayoutSet layoutSet) {
        return layoutSet;
    }

    @Override
    public LayoutSet fetchDraft(long primaryKey) {
        return this.layoutSetPersistence.fetchByPrimaryKey(primaryKey);
    }

    @Override
    public LayoutSetVersion fetchLatestVersion(LayoutSet layoutSet) {
        return null;
    }

    @Override
    public LayoutSet fetchLayoutSet(long groupId, boolean privateLayout) {
        return this.layoutSetPersistence.fetchByG_P_Head(groupId, privateLayout, false);
    }

    @Override
    public LayoutSet fetchLayoutSet(String virtualHostname) {
        VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname = StringUtil.toLowerCase(StringUtil.trim(virtualHostname)));
        if (virtualHost == null || virtualHost.getLayoutSetId() == 0L) {
            return null;
        }
        return this.layoutSetPersistence.fetchByPrimaryKey(virtualHost.getLayoutSetId());
    }

    @Override
    public LayoutSet fetchLayoutSetByLogoId(boolean privateLayout, long logoId) throws PortalException {
        return this.layoutSetPersistence.fetchByP_L_Head(privateLayout, logoId, false);
    }

    @Override
    public LayoutSet fetchPublished(LayoutSet layoutSet) {
        return layoutSet;
    }

    @Override
    public LayoutSet fetchPublished(long primaryKey) {
        return this.layoutSetPersistence.fetchByPrimaryKey(primaryKey);
    }

    @Override
    public LayoutSet getDraft(LayoutSet layoutSet) throws PortalException {
        return layoutSet;
    }

    @Override
    public LayoutSet getDraft(long primaryKey) throws PortalException {
        return this.layoutSetPersistence.findByPrimaryKey(primaryKey);
    }

    @Override
    public LayoutSet getLayoutSet(long groupId, boolean privateLayout) throws PortalException {
        return this.layoutSetPersistence.findByG_P_Head(groupId, privateLayout, false);
    }

    @Override
    public LayoutSet getLayoutSet(String virtualHostname) throws PortalException {
        VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname = StringUtil.toLowerCase(StringUtil.trim(virtualHostname)));
        if (virtualHost.getLayoutSetId() == 0L) {
            throw new LayoutSetVirtualHostException("Virtual host is associated with company " + virtualHost.getCompanyId());
        }
        return this.layoutSetPersistence.findByPrimaryKey(virtualHost.getLayoutSetId());
    }

    @Override
    public List<LayoutSet> getLayoutSetsByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid) {
        return this.layoutSetPersistence.findByLayoutSetPrototypeUuid_Head(layoutSetPrototypeUuid, false);
    }

    @Override
    public LayoutSetVersion getVersion(LayoutSet layoutSet, int version) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LayoutSetVersion> getVersions(LayoutSet layoutSet) {
        return Collections.emptyList();
    }

    @Override
    public LayoutSet publishDraft(LayoutSet layoutSet) throws PortalException {
        return this.layoutSetPersistence.update(layoutSet);
    }

    @Override
    public void registerListener(VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterListener(VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LayoutSet updateDraft(LayoutSet layoutSet) throws PortalException {
        return this.layoutSetPersistence.update(layoutSet);
    }

    @Override
    public LayoutSet updateLayoutSet(LayoutSet layoutSet) throws PortalException {
        return this.updateDraft(this.getDraft(layoutSet));
    }

    @Override
    public void updateLayoutSetPrototypeLinkEnabled(long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled, String layoutSetPrototypeUuid) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P_Head(groupId, privateLayout, false);
        LayoutSetBranch layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        if (layoutSetBranch == null) {
            if (Validator.isNull(layoutSetPrototypeUuid)) {
                layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
            }
            if (Validator.isNull(layoutSetPrototypeUuid)) {
                layoutSetPrototypeLinkEnabled = false;
            }
            LayoutSet draftLayoutSet = this.getDraft(layoutSet);
            draftLayoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
            draftLayoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
            this.updateDraft(draftLayoutSet);
            return;
        }
        if (Validator.isNull(layoutSetPrototypeUuid)) {
            layoutSetPrototypeUuid = layoutSetBranch.getLayoutSetPrototypeUuid();
        }
        if (Validator.isNull(layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            throw new IllegalStateException("Cannot set layoutSetPrototypeLinkEnabled to true when layoutSetPrototypeUuid is null");
        }
        layoutSetBranch.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
        layoutSetBranch.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
        this.layoutSetBranchPersistence.update(layoutSetBranch);
    }

    @Override
    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, byte[] bytes) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P_Head(groupId, privateLayout, false);
        LayoutSetBranch layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        if (layoutSetBranch == null) {
            LayoutSet draftLayoutSet = this.getDraft(layoutSet);
            draftLayoutSet.setModifiedDate(new Date());
            PortalUtil.updateImageId(draftLayoutSet, logo, bytes, "logoId", 0L, 0, 0);
            return this.updateDraft(draftLayoutSet);
        }
        layoutSetBranch.setModifiedDate(new Date());
        PortalUtil.updateImageId(layoutSetBranch, logo, bytes, "logoId", 0L, 0, 0);
        this.layoutSetBranchPersistence.update(layoutSetBranch);
        return layoutSet;
    }

    @Override
    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, File file) throws PortalException {
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes(file);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        return this.updateLogo(groupId, privateLayout, logo, bytes);
    }

    @Override
    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream is) throws PortalException {
        return this.updateLogo(groupId, privateLayout, logo, is, true);
    }

    @Override
    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream is, boolean cleanUpStream) throws PortalException {
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes(is, -1, cleanUpStream);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        return this.updateLogo(groupId, privateLayout, logo, bytes);
    }

    @Override
    public LayoutSet updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutSetBranch layoutSetBranch;
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P_Head(groupId, privateLayout, false);
        if (Validator.isNull(themeId)) {
            themeId = ThemeFactoryUtil.getDefaultRegularThemeId(layoutSet.getCompanyId());
        }
        if (Validator.isNull(colorSchemeId)) {
            colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
        }
        if ((layoutSetBranch = this._getLayoutSetBranch(layoutSet)) == null) {
            LayoutSet draftLayoutSet = this.getDraft(layoutSet);
            draftLayoutSet.setModifiedDate(new Date());
            draftLayoutSet.setThemeId(themeId);
            draftLayoutSet.setColorSchemeId(colorSchemeId);
            draftLayoutSet.setCss(css);
            layoutSet = this.updateDraft(draftLayoutSet);
            if (PrefsPropsUtil.getBoolean("theme.sync.on.group", PropsValues.THEME_SYNC_ON_GROUP)) {
                LayoutSet otherLayoutSet = this.layoutSetPersistence.findByG_P_Head(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), false);
                LayoutSet otherDraftLayoutSet = this.getDraft(otherLayoutSet);
                otherDraftLayoutSet.setThemeId(themeId);
                otherDraftLayoutSet.setColorSchemeId(colorSchemeId);
                this.updateDraft(otherDraftLayoutSet);
            }
            return layoutSet;
        }
        layoutSetBranch.setModifiedDate(new Date());
        layoutSetBranch.setThemeId(themeId);
        layoutSetBranch.setColorSchemeId(colorSchemeId);
        layoutSetBranch.setCss(css);
        this.layoutSetBranchPersistence.update(layoutSetBranch);
        return layoutSet;
    }

    @Override
    public void updateLookAndFeel(long groupId, String themeId, String colorSchemeId, String css) throws PortalException {
        this.updateLookAndFeel(groupId, false, themeId, colorSchemeId, css);
        this.updateLookAndFeel(groupId, true, themeId, colorSchemeId, css);
    }

    @Override
    public LayoutSet updatePageCount(long groupId, boolean privateLayout) throws PortalException {
        int pageCount = this.layoutPersistence.countByG_P_Head(groupId, privateLayout, false);
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P_Head(groupId, privateLayout, false);
        LayoutSet draftLayoutSet = this.getDraft(layoutSet);
        draftLayoutSet.setModifiedDate(new Date());
        draftLayoutSet.setPageCount(pageCount);
        return this.updateDraft(draftLayoutSet);
    }

    @Override
    public LayoutSet updateSettings(long groupId, boolean privateLayout, String settings) throws PortalException {
        UnicodeProperties settingsProperties = new UnicodeProperties();
        settingsProperties.fastLoad(settings);
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P_Head(groupId, privateLayout, false);
        LayoutSetBranch layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        if (layoutSetBranch == null) {
            LayoutSet draftLayoutSet = this.getDraft(layoutSet);
            draftLayoutSet.setModifiedDate(new Date());
            this.validateSettings(draftLayoutSet.getSettingsProperties(), settingsProperties);
            draftLayoutSet.setSettingsProperties(settingsProperties);
            return this.updateDraft(draftLayoutSet);
        }
        layoutSetBranch.setModifiedDate(new Date());
        this.validateSettings(layoutSetBranch.getSettingsProperties(), settingsProperties);
        layoutSetBranch.setSettingsProperties(settingsProperties);
        this.layoutSetBranchPersistence.update(layoutSetBranch);
        return layoutSet;
    }

    @Override
    public LayoutSet updateVirtualHost(long groupId, boolean privateLayout, String virtualHostname) throws PortalException {
        LayoutSet layoutSet;
        block8: {
            if (Validator.isNotNull(virtualHostname = StringUtil.toLowerCase(StringUtil.trim(virtualHostname))) && !Validator.isDomain(virtualHostname)) {
                throw new LayoutSetVirtualHostException();
            }
            layoutSet = this.layoutSetPersistence.findByG_P_Head(groupId, privateLayout, false);
            if (Validator.isNotNull(virtualHostname)) {
                VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname);
                if (virtualHost == null) {
                    this.virtualHostLocalService.updateVirtualHost(layoutSet.getCompanyId(), layoutSet.getLayoutSetId(), virtualHostname);
                } else if (virtualHost.getCompanyId() != layoutSet.getCompanyId() || virtualHost.getLayoutSetId() != layoutSet.getLayoutSetId()) {
                    throw new LayoutSetVirtualHostException();
                }
            } else {
                try {
                    this.virtualHostPersistence.removeByC_L(layoutSet.getCompanyId(), layoutSet.getLayoutSetId());
                    this.layoutSetPersistence.clearCache(layoutSet);
                    TransactionCommitCallbackUtil.registerCallback(new Callable<Void>(){

                        @Override
                        public Void call() {
                            EntityCacheUtil.removeResult(LayoutSetModelImpl.ENTITY_CACHE_ENABLED, LayoutSetImpl.class, Long.valueOf(layoutSet.getLayoutSetId()));
                            return null;
                        }
                    });
                }
                catch (NoSuchVirtualHostException nsvhe) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug(nsvhe, nsvhe);
                }
            }
        }
        return layoutSet;
    }

    protected LayoutSet initLayoutSet(LayoutSet layoutSet) throws PortalException {
        Group group = layoutSet.getGroup();
        if (group.isStagingGroup()) {
            LayoutSet liveLayoutSet = null;
            Group liveGroup = group.getLiveGroup();
            liveLayoutSet = layoutSet.isPrivateLayout() ? liveGroup.getPrivateLayoutSet() : liveGroup.getPublicLayoutSet();
            layoutSet.setLogoId(liveLayoutSet.getLogoId());
            if (liveLayoutSet.isLogo()) {
                Image logoImage = this.imageLocalService.getImage(liveLayoutSet.getLogoId());
                long logoId = this.counterLocalService.increment();
                this.imageLocalService.updateImage(logoId, logoImage.getTextObj(), logoImage.getType(), logoImage.getHeight(), logoImage.getWidth(), logoImage.getSize());
                layoutSet.setLogoId(logoId);
            }
            layoutSet.setThemeId(liveLayoutSet.getThemeId());
            layoutSet.setColorSchemeId(liveLayoutSet.getColorSchemeId());
            layoutSet.setCss(liveLayoutSet.getCss());
            layoutSet.setSettings(liveLayoutSet.getSettings());
        } else {
            layoutSet.setThemeId(ThemeFactoryUtil.getDefaultRegularThemeId(group.getCompanyId()));
            layoutSet.setColorSchemeId(ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId());
            layoutSet.setCss("");
            layoutSet.setSettings("");
        }
        return layoutSet;
    }

    protected void validateSettings(UnicodeProperties oldSettingsProperties, UnicodeProperties newSettingsProperties) {
        boolean enableJavaScript = PropsValues.FIELD_ENABLE_COM_LIFERAY_PORTAL_KERNEL_MODEL_LAYOUTSET_JAVASCRIPT;
        if (!enableJavaScript) {
            String javaScript = oldSettingsProperties.getProperty("javascript");
            newSettingsProperties.setProperty("javascript", javaScript);
        }
    }

    private LayoutSetBranch _getLayoutSetBranch(LayoutSet layoutSet) throws PortalException {
        LayoutSetStagingHandler layoutSetStagingHandler = LayoutStagingUtil.getLayoutSetStagingHandler(layoutSet);
        if (layoutSetStagingHandler != null) {
            return layoutSetStagingHandler.getLayoutSetBranch();
        }
        if (LayoutStagingUtil.isBranchingLayoutSet(layoutSet.getGroup(), layoutSet.isPrivateLayout())) {
            layoutSetStagingHandler = new LayoutSetStagingHandler(layoutSet);
            return layoutSetStagingHandler.getLayoutSetBranch();
        }
        return null;
    }
}

