/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutReference;
import com.liferay.portal.kernel.model.LayoutSoap;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.service.base.LayoutServiceBaseImpl;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class LayoutServiceImpl
extends LayoutServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutServiceImpl.class);

    @Override
    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, long classNameId, long classPK, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check(permissionChecker, groupId, "ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check(permissionChecker, groupId, privateLayout, parentLayoutId, "ADD_LAYOUT");
        }
        Layout layout = this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, classNameId, classPK, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, system, friendlyURLMap, serviceContext);
        this.checkLayoutTypeSettings(layout, "", typeSettings);
        return layout;
    }

    @Override
    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(groupId, privateLayout, parentLayoutId, 0L, 0L, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, false, friendlyURLMap, serviceContext);
    }

    @Override
    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check(permissionChecker, groupId, "ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check(permissionChecker, groupId, privateLayout, parentLayoutId, "ADD_LAYOUT");
        }
        return this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext);
    }

    @Override
    public FileEntry addTempFileEntry(long groupId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "EXPORT_IMPORT_LAYOUTS");
        return TempFileEntryUtil.addTempFileEntry(groupId, this.getUserId(), DigesterUtil.digestHex("SHA-256", folderName), fileName, inputStream, mimeType);
    }

    @Override
    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), groupId, privateLayout, layoutId, "DELETE");
        this.layoutLocalService.deleteLayout(groupId, privateLayout, layoutId, serviceContext);
    }

    @Override
    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), plid, "DELETE");
        this.layoutLocalService.deleteLayout(plid, serviceContext);
    }

    @Override
    public void deleteTempFileEntry(long groupId, String folderName, String fileName) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "EXPORT_IMPORT_LAYOUTS");
        TempFileEntryUtil.deleteTempFileEntry(groupId, this.getUserId(), DigesterUtil.digestHex("SHA-256", folderName), fileName);
    }

    @Override
    public List<Layout> getAncestorLayouts(long plid) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        List<Layout> ancestors = layout.getAncestors();
        return this.filterLayouts(ancestors);
    }

    @Override
    public long getControlPanelLayoutPlid() throws PortalException {
        Group group = this.groupLocalService.fetchGroup(CompanyThreadLocal.getCompanyId(), "Control Panel");
        List<Layout> layouts = this.layoutLocalService.getLayouts(group.getGroupId(), true);
        if (ListUtil.isEmpty(layouts)) {
            throw new NoSuchLayoutException("Unable to get control panel layout");
        }
        Layout layout = layouts.get(0);
        LayoutPermissionUtil.check(this.getPermissionChecker(), layout, "VIEW");
        return layout.getPlid();
    }

    @Override
    public long getDefaultPlid(long groupId, boolean privateLayout) {
        return this.layoutLocalService.getDefaultPlid(groupId, privateLayout);
    }

    @Override
    public long getDefaultPlid(long groupId, long scopeGroupId, boolean privateLayout, String portletId) throws PortalException {
        if (groupId <= 0L) {
            return 0L;
        }
        PermissionChecker permissionChecker = this.getPermissionChecker();
        String scopeGroupLayoutUuid = null;
        Group scopeGroup = this.groupLocalService.getGroup(scopeGroupId);
        if (scopeGroup.isLayout()) {
            Layout scopeGroupLayout = this.layoutLocalService.getLayout(scopeGroup.getClassPK());
            scopeGroupLayoutUuid = scopeGroupLayout.getUuid();
        }
        Map<Long, PortletPreferences> jxPortletPreferencesMap = PortletPreferencesFactoryUtil.getPortletSetupMap(scopeGroup.getCompanyId(), groupId, 0L, 3, portletId, privateLayout);
        for (Map.Entry<Long, PortletPreferences> entry : jxPortletPreferencesMap.entrySet()) {
            LayoutTypePortlet layoutTypePortlet;
            long plid = entry.getKey();
            Layout layout = null;
            try {
                layout = this.layoutLocalService.getLayout(plid);
            }
            catch (NoSuchLayoutException nsle) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(nsle, nsle);
                continue;
            }
            if (!LayoutPermissionUtil.contains(permissionChecker, layout, "VIEW") || !layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
            PortletPreferences jxPortletPreferences = entry.getValue();
            String scopeType = GetterUtil.getString(jxPortletPreferences.getValue("lfrScopeType", null));
            if (scopeGroup.isLayout()) {
                String scopeLayoutUuid = GetterUtil.getString(jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
                if (!Validator.isNotNull(scopeType) || !Validator.isNotNull(scopeLayoutUuid) || !scopeLayoutUuid.equals(scopeGroupLayoutUuid)) continue;
                return layout.getPlid();
            }
            if (!(scopeGroup.isCompany() ? Validator.isNotNull(scopeType) && scopeType.equals("company") : Validator.isNull(scopeType))) continue;
            return layout.getPlid();
        }
        return 0L;
    }

    @Override
    @ThreadLocalCachable
    public long getDefaultPlid(long groupId, long scopeGroupId, String portletId) throws PortalException {
        long plid = this.getDefaultPlid(groupId, scopeGroupId, false, portletId);
        if (plid == 0L) {
            plid = this.getDefaultPlid(groupId, scopeGroupId, true, portletId);
        }
        return plid;
    }

    @Override
    public Layout getLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this.layoutLocalService.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        LayoutPermissionUtil.check(this.getPermissionChecker(), layout, "VIEW");
        return layout;
    }

    @Override
    public String getLayoutName(long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.check(this.getPermissionChecker(), layout, "VIEW");
        return layout.getName(languageId);
    }

    @Override
    public long getLayoutPlid(String uuid, long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this.layoutLocalService.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        LayoutPermissionUtil.check(this.getPermissionChecker(), layout, "VIEW");
        return layout.getPlid();
    }

    @Override
    public LayoutReference[] getLayoutReferences(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        LayoutReference[] layoutReferences = this.layoutLocalService.getLayouts(companyId, portletId, preferencesKey, preferencesValue);
        ArrayList<LayoutReference> filteredLayoutReferences = new ArrayList<LayoutReference>(layoutReferences.length);
        for (LayoutReference layoutReference : layoutReferences) {
            try {
                LayoutSoap layoutSoap = layoutReference.getLayoutSoap();
                if (!LayoutPermissionUtil.contains(this.getPermissionChecker(), layoutSoap.getPlid(), "VIEW")) continue;
                filteredLayoutReferences.add(layoutReference);
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(pe, pe);
            }
        }
        return filteredLayoutReferences.toArray(new LayoutReference[0]);
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout) {
        return this.layoutPersistence.filterFindByG_P_Head(groupId, privateLayout, false);
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) throws PortalException {
        List<Layout> layouts = this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId);
        return this.filterLayouts(layouts);
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) throws PortalException {
        List<Layout> layouts = this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end);
        return this.filterLayouts(layouts);
    }

    @Override
    public List<Layout> getLayouts(long groupId, String type) {
        return this.layoutPersistence.filterFindByG_T_Head(groupId, type, false);
    }

    @Override
    public List<Layout> getLayouts(long groupId, String type, int start, int end) {
        return this.layoutPersistence.filterFindByG_T_Head(groupId, type, false, start, end);
    }

    @Override
    public int getLayoutsCount(long groupId, boolean privateLayout) {
        return this.layoutPersistence.filterCountByG_P_Head(groupId, privateLayout, false);
    }

    @Override
    public int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.filterCountByG_P_P_Head(groupId, privateLayout, parentLayoutId, false);
    }

    @Override
    public int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId, int priority) {
        return this.layoutPersistence.filterCountByG_P_P_LtP_Head(groupId, privateLayout, parentLayoutId, priority, false);
    }

    @Override
    public int getLayoutsCount(long groupId, String type) {
        return this.layoutPersistence.filterCountByG_T_Head(groupId, type, false);
    }

    @Override
    public String[] getTempFileNames(long groupId, String folderName) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "EXPORT_IMPORT_LAYOUTS");
        return TempFileEntryUtil.getTempFileNames(groupId, this.getUserId(), DigesterUtil.digestHex("SHA-256", folderName));
    }

    @Override
    public boolean hasLayout(String uuid, long groupId, boolean privateLayout) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "VIEW");
        return this.layoutLocalService.hasLayout(uuid, groupId, privateLayout);
    }

    @Override
    public boolean hasPortletId(long plid, String portletId) throws PortalException {
        Layout layout = this.layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return false;
        }
        LayoutPermissionUtil.check(this.getPermissionChecker(), layout, "VIEW");
        LayoutType layoutType = layout.getLayoutType();
        return layoutType instanceof LayoutTypePortlet && ((LayoutTypePortlet)layoutType).hasPortletId(portletId);
    }

    @Override
    public void schedulePublishToLive(long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), targetGroupId, "PUBLISH_STAGING");
        Trigger trigger = TriggerFactoryUtil.createTrigger(PortalUUIDUtil.generate(), groupName, schedulerStartDate, schedulerEndDate, cronText);
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Map<String, Serializable> publishLayoutLocalSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildPublishLayoutLocalSettingsMap(user, sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap);
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(this.getUserId(), description, 3, publishLayoutLocalSettingsMap);
        SchedulerEngineHelperUtil.schedule(trigger, StorageType.PERSISTED, description, "liferay/layouts_local_publisher", exportImportConfiguration.getExportImportConfigurationId(), 0);
    }

    @Override
    public void schedulePublishToRemote(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), sourceGroupId, "PUBLISH_STAGING");
        Trigger trigger = TriggerFactoryUtil.createTrigger(PortalUUIDUtil.generate(), groupName, schedulerStartDate, schedulerEndDate, cronText);
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Map<String, Serializable> publishLayoutRemoteSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildPublishLayoutRemoteSettingsMap(this.getUserId(), sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, user.getLocale(), user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(this.getUserId(), description, 4, publishLayoutRemoteSettingsMap);
        SchedulerEngineHelperUtil.schedule(trigger, StorageType.PERSISTED, description, "liferay/layouts_remote_publisher", exportImportConfiguration.getExportImportConfigurationId(), 0);
    }

    @Override
    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "UPDATE");
        this.layoutLocalService.setLayouts(groupId, privateLayout, parentLayoutId, layoutIds, serviceContext);
    }

    @Override
    public void unschedulePublishToLive(long groupId, String jobName, String groupName) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete(jobName, groupName, StorageType.PERSISTED);
    }

    @Override
    public void unschedulePublishToRemote(long groupId, String jobName, String groupName) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete(jobName, groupName, StorageType.PERSISTED);
    }

    @Override
    public Layout updateIconImage(long plid, byte[] bytes) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), plid, "UPDATE");
        return this.layoutLocalService.updateIconImage(plid, bytes);
    }

    @Override
    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.check(this.getPermissionChecker(), layout, "UPDATE");
        Layout updatedLayout = this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, iconImage, iconBytes, serviceContext);
        if (!(layout.getLayoutType() instanceof LayoutTypePortlet)) {
            this.checkLayoutTypeSettings(layout, "", updatedLayout.getTypeSettings());
        }
        return updatedLayout;
    }

    @Override
    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.check(this.getPermissionChecker(), layout, "UPDATE");
        this.checkLayoutTypeSettings(layout, layout.getTypeSettings(), typeSettings);
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
    }

    @Override
    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), groupId, privateLayout, layoutId, "UPDATE");
        if (Validator.isNotNull(themeId)) {
            this.pluginSettingLocalService.checkPermission(this.getUserId(), themeId, "theme");
        }
        return this.layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
    }

    @Override
    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), groupId, privateLayout, layoutId, "UPDATE");
        return this.layoutLocalService.updateName(groupId, privateLayout, layoutId, name, languageId);
    }

    @Override
    public Layout updateName(long plid, String name, String languageId) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), plid, "UPDATE");
        return this.layoutLocalService.updateName(plid, name, languageId);
    }

    @Override
    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), groupId, privateLayout, layoutId, "UPDATE");
        return this.layoutLocalService.updateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
    }

    @Override
    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), plid, "UPDATE");
        return this.layoutLocalService.updateParentLayoutId(plid, parentPlid);
    }

    @Override
    public Layout updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), plid, "UPDATE");
        return this.layoutLocalService.updateParentLayoutIdAndPriority(plid, parentPlid, priority);
    }

    @Override
    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), groupId, privateLayout, layoutId, "UPDATE");
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, priority);
    }

    @Override
    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), groupId, privateLayout, layoutId, "UPDATE");
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, nextLayoutId, previousLayoutId);
    }

    @Override
    public Layout updatePriority(long plid, int priority) throws PortalException {
        LayoutPermissionUtil.check(this.getPermissionChecker(), plid, "UPDATE");
        return this.layoutLocalService.updatePriority(plid, priority);
    }

    protected void checkLayoutTypeSettings(Layout layout, String originalTypeSettings, String newTypeSettings) throws PortalException {
        if (!(layout.getLayoutType() instanceof LayoutTypePortlet)) {
            return;
        }
        List<String> originalPortletIds = this.getPortletIds(layout, originalTypeSettings);
        List<String> newPortletIds = this.getPortletIds(layout, newTypeSettings);
        for (String portletId : newPortletIds) {
            if (originalPortletIds.contains(portletId)) continue;
            PortletPermissionUtil.check(this.getPermissionChecker(), layout.getPlid(), portletId, "ADD_TO_PAGE");
        }
    }

    protected List<Layout> filterLayouts(List<Layout> layouts) throws PortalException {
        ArrayList<Layout> filteredLayouts = new ArrayList<Layout>();
        for (Layout layout : layouts) {
            if (!LayoutPermissionUtil.contains(this.getPermissionChecker(), layout, "VIEW")) continue;
            filteredLayouts.add(layout);
        }
        return filteredLayouts;
    }

    protected List<String> getPortletIds(Layout layout, String typeSettings) {
        if (Validator.isBlank(typeSettings)) {
            return Collections.emptyList();
        }
        Layout clonedLayout = (Layout)layout.clone();
        clonedLayout.setType("portlet");
        clonedLayout.setTypeSettings(typeSettings);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)clonedLayout.getLayoutType();
        return layoutTypePortlet.getPortletIds();
    }
}

