/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchLayoutPrototypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutPrototypeException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.LayoutPrototypeLocalServiceBaseImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutPrototypeLocalServiceImpl
extends LayoutPrototypeLocalServiceBaseImpl {
    @Override
    public LayoutPrototype addLayoutPrototype(long userId, long companyId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long layoutPrototypeId = this.counterLocalService.increment();
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.create(layoutPrototypeId);
        layoutPrototype.setUuid(serviceContext.getUuid());
        layoutPrototype.setCompanyId(companyId);
        layoutPrototype.setUserId(userId);
        layoutPrototype.setUserName(user.getFullName());
        layoutPrototype.setCreateDate(serviceContext.getCreateDate(now));
        layoutPrototype.setModifiedDate(serviceContext.getModifiedDate(now));
        layoutPrototype.setNameMap(nameMap);
        layoutPrototype.setDescriptionMap(descriptionMap);
        layoutPrototype.setActive(active);
        this.layoutPrototypePersistence.update(layoutPrototype);
        this.resourceLocalService.addResources(companyId, 0L, userId, LayoutPrototype.class.getName(), layoutPrototype.getLayoutPrototypeId(), false, true, false);
        String friendlyURL = "/template-" + layoutPrototype.getLayoutPrototypeId();
        Group group = this.groupLocalService.addGroup(userId, 0L, LayoutPrototype.class.getName(), layoutPrototype.getLayoutPrototypeId(), 0L, layoutPrototype.getNameMap(), null, 0, true, 0, friendlyURL, false, true, null);
        if (GetterUtil.getBoolean(serviceContext.getAttribute("addDefaultLayout"), true)) {
            HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
            friendlyURLMap.put(LocaleUtil.getSiteDefault(), "/layout");
            this.layoutLocalService.addLayout(userId, group.getGroupId(), true, 0L, layoutPrototype.getNameMap(), null, null, null, null, "portlet", "", false, friendlyURLMap, serviceContext);
        }
        return layoutPrototype;
    }

    @Override
    @SystemEvent(action=1, type=1)
    public LayoutPrototype deleteLayoutPrototype(LayoutPrototype layoutPrototype) throws PortalException {
        if (!CompanyThreadLocal.isDeleteInProcess() && this.layoutPersistence.countByC_L_Head(layoutPrototype.getCompanyId(), layoutPrototype.getUuid(), false) > 0) {
            throw new RequiredLayoutPrototypeException();
        }
        Group group = layoutPrototype.getGroup();
        this.groupLocalService.deleteGroup(group);
        this.resourceLocalService.deleteResource(layoutPrototype.getCompanyId(), LayoutPrototype.class.getName(), 4, layoutPrototype.getLayoutPrototypeId());
        this.layoutPrototypePersistence.remove(layoutPrototype);
        return layoutPrototype;
    }

    @Override
    public LayoutPrototype deleteLayoutPrototype(long layoutPrototypeId) throws PortalException {
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.findByPrimaryKey(layoutPrototypeId);
        return this.layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototype);
    }

    @Override
    public void deleteNondefaultLayoutPrototypes(long companyId) throws PortalException {
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        List<LayoutPrototype> layoutPrototypes = this.layoutPrototypePersistence.findByCompanyId(companyId);
        for (LayoutPrototype layoutPrototype : layoutPrototypes) {
            if (layoutPrototype.getUserId() == defaultUserId) continue;
            this.layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototype);
        }
    }

    @Override
    public LayoutPrototype fetchLayoutPrototype(long companyId, String name, Locale locale) {
        List<LayoutPrototype> layoutPrototypes = this.layoutPrototypePersistence.findByCompanyId(companyId);
        for (LayoutPrototype layoutPrototype : layoutPrototypes) {
            String layoutPrototypeName = layoutPrototype.getName(locale);
            if (!layoutPrototypeName.equals(name)) continue;
            return layoutPrototype;
        }
        return null;
    }

    @Override
    public LayoutPrototype fetchLayoutProtoype(long companyId, String name) {
        return this.layoutPrototypeLocalService.fetchLayoutPrototype(companyId, name, LocaleUtil.getDefault());
    }

    @Override
    public LayoutPrototype getLayoutPrototype(long companyId, String name) throws PortalException {
        return this.layoutPrototypeLocalService.getLayoutPrototype(companyId, name, LocaleUtil.getDefault());
    }

    @Override
    public LayoutPrototype getLayoutPrototype(long companyId, String name, Locale locale) throws PortalException {
        LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.fetchLayoutPrototype(companyId, name, locale);
        if (layoutPrototype == null) {
            throw new NoSuchLayoutPrototypeException();
        }
        return layoutPrototype;
    }

    @Override
    public LayoutPrototype getLayoutPrototypeByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.layoutPrototypePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    @Override
    public List<LayoutPrototype> search(long companyId, Boolean active, int start, int end, OrderByComparator<LayoutPrototype> obc) {
        if (active != null) {
            return this.layoutPrototypePersistence.findByC_A(companyId, active, start, end, obc);
        }
        return this.layoutPrototypePersistence.findByCompanyId(companyId, start, end, obc);
    }

    @Override
    public int searchCount(long companyId, Boolean active) {
        if (active != null) {
            return this.layoutPrototypePersistence.countByC_A(companyId, active);
        }
        return this.layoutPrototypePersistence.countByCompanyId(companyId);
    }

    @Override
    public LayoutPrototype updateLayoutPrototype(long layoutPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.findByPrimaryKey(layoutPrototypeId);
        layoutPrototype.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPrototype.setNameMap(nameMap);
        layoutPrototype.setDescriptionMap(descriptionMap);
        layoutPrototype.setActive(active);
        this.layoutPrototypePersistence.update(layoutPrototype);
        Layout layout = layoutPrototype.getLayout();
        layout.setModifiedDate(layoutPrototype.getModifiedDate());
        layout.setNameMap(nameMap);
        this.layoutPersistence.update(layout);
        return layoutPrototype;
    }
}

