/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.SystemEventLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.portlet.exportimport.staging.ProxiedLayoutsThreadLocal;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class LayoutLocalServiceStagingAdvice
implements BeanFactoryAware {
    protected LayoutLocalServiceHelper layoutLocalServiceHelper;
    private static final Class<?>[] _GET_LAYOUTS_TYPES = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE};
    private static final Class<?>[] _UPDATE_LAYOUT_PARAMETER_TYPES = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class, String.class, Boolean.TYPE, String.class, Boolean.class, byte[].class, ServiceContext.class};
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceStagingAdvice.class);
    private static final Set<String> _layoutLocalServiceStagingAdviceMethodNames = new HashSet<String>(Arrays.asList("create", "createLayout", "deleteLayout", "getLayouts", "updateLayout", "updateLookAndFeel", "updateName"));
    private BeanFactory _beanFactory;

    public LayoutLocalServiceStagingAdvice() {
        if (_log.isDebugEnabled()) {
            _log.debug("Instantiating " + this.hashCode());
        }
    }

    public void afterPropertiesSet() throws BeansException {
        AopInvocationHandler aopInvocationHandler = ProxyUtil.fetchInvocationHandler(this._beanFactory.getBean(LayoutLocalService.class.getName()), AopInvocationHandler.class);
        aopInvocationHandler.setTarget(ProxyUtil.newProxyInstance(LayoutLocalServiceStagingAdvice.class.getClassLoader(), new Class[]{LayoutLocalService.class}, new LayoutLocalServiceStagingInvocationHandler(this, aopInvocationHandler.getTarget())));
        this.layoutLocalServiceHelper = (LayoutLocalServiceHelper)this._beanFactory.getBean(LayoutLocalServiceHelper.class.getName());
    }

    public void deleteLayout(LayoutLocalService layoutLocalService, Layout layout, boolean updateLayoutSet, ServiceContext serviceContext) throws PortalException {
        long layoutSetBranchId = ParamUtil.getLong(serviceContext, "layoutSetBranchId");
        if (layoutSetBranchId > 0L) {
            LayoutRevisionLocalServiceUtil.deleteLayoutRevisions(layoutSetBranchId, layout.getPlid());
            List<LayoutRevision> notIncompleteLayoutRevisions = LayoutRevisionUtil.findByP_NotS(layout.getPlid(), 6);
            if (notIncompleteLayoutRevisions.isEmpty()) {
                LayoutRevisionLocalServiceUtil.deleteLayoutLayoutRevisions(layout.getPlid());
                this.doDeleteLayout(layoutLocalService, layout, updateLayoutSet, serviceContext);
            }
        } else {
            this.doDeleteLayout(layoutLocalService, layout, updateLayoutSet, serviceContext);
        }
    }

    public void deleteLayout(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        Layout layout = layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        this.deleteLayout(layoutLocalService, layout, true, serviceContext);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this._beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layout updateLayout(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException {
        LayoutRevision layoutRevision;
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        Map<Locale, String> layoutFriendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = layoutFriendlyURLMap.get(LocaleUtil.getSiteDefault());
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, layoutFriendlyURLMap, serviceContext);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Layout layout = LayoutUtil.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        if (LayoutStagingUtil.isBranchingLayout(layout)) {
            layout = this.getProxiedLayout(layout);
        }
        if ((layoutRevision = LayoutStagingUtil.getLayoutRevision(layout)) == null) {
            return layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, iconImage, iconBytes, serviceContext);
        }
        layoutLocalService.updateAsset(serviceContext.getUserId(), layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setParentLayoutId(parentLayoutId);
        layoutRevision.setNameMap(nameMap);
        layoutRevision.setTitleMap(titleMap);
        layoutRevision.setDescriptionMap(descriptionMap);
        layoutRevision.setKeywordsMap(keywordsMap);
        layoutRevision.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        if (!iconImage) {
            layout.setIconImageId(0L);
            layoutRevision.setIconImageId(0L);
        } else {
            PortalUtil.updateImageId(layout, iconImage, iconBytes, "iconImageId", 0L, 0, 0);
        }
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean(serviceContext, "layoutPrototypeLinkEnabled");
        layout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        layout.setExpandoBridgeAttributes(serviceContext);
        LayoutUtil.update(layout);
        LayoutFriendlyURLLocalServiceUtil.updateLayoutFriendlyURLs(layout.getUserId(), layout.getCompanyId(), layout.getGroupId(), layout.getPlid(), layout.isPrivateLayout(), layoutFriendlyURLMap, serviceContext);
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask(serviceContext.getUserId(), layoutRevision);
        serviceContext.setAttribute("revisionInProgress", Boolean.valueOf(hasWorkflowTask));
        int workflowAction = serviceContext.getWorkflowAction();
        try {
            serviceContext.setWorkflowAction(2);
            LayoutRevisionLocalServiceUtil.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getCss(), serviceContext);
        }
        finally {
            serviceContext.setWorkflowAction(workflowAction);
        }
        return layout;
    }

    public Layout updateLayout(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        LayoutRevision layoutRevision;
        Layout layout = LayoutUtil.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        if (LayoutStagingUtil.isBranchingLayout(layout)) {
            layout = this.getProxiedLayout(layout);
        }
        if ((layoutRevision = LayoutStagingUtil.getLayoutRevision(layout)) == null) {
            return layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
        }
        layout.setTypeSettings(typeSettings);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask(serviceContext.getUserId(), layoutRevision);
        serviceContext.setAttribute("revisionInProgress", Boolean.valueOf(hasWorkflowTask));
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        LayoutRevisionLocalServiceUtil.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getCss(), serviceContext);
        return layout;
    }

    public Layout updateLookAndFeel(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutRevision layoutRevision;
        Layout layout = LayoutUtil.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        if (LayoutStagingUtil.isBranchingLayout(layout)) {
            layout = this.getProxiedLayout(layout);
        }
        if ((layoutRevision = LayoutStagingUtil.getLayoutRevision(layout)) == null) {
            return layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
        }
        layout.setThemeId(themeId);
        layout.setColorSchemeId(colorSchemeId);
        layout.setCss(css);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask(serviceContext.getUserId(), layoutRevision);
        serviceContext.setAttribute("revisionInProgress", Boolean.valueOf(hasWorkflowTask));
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        LayoutRevisionLocalServiceUtil.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getCss(), serviceContext);
        return layout;
    }

    public Layout updateName(LayoutLocalService layoutLocalService, Layout layout, String name, String languageId) throws PortalException {
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision(layout = this.wrapLayout(layout));
        if (layoutRevision == null) {
            return layoutLocalService.updateName(layout, name, languageId);
        }
        this.layoutLocalServiceHelper.validateName(name, languageId);
        layout.setName(name, LocaleUtil.fromLanguageId(languageId));
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask(serviceContext.getUserId(), layoutRevision);
        serviceContext.setAttribute("revisionInProgress", Boolean.valueOf(hasWorkflowTask));
        serviceContext.setWorkflowAction(2);
        LayoutRevisionLocalServiceUtil.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getCss(), serviceContext);
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeleteLayout(LayoutLocalService layoutLocalService, Layout layout, boolean updateLayoutSet, ServiceContext serviceContext) throws PortalException {
        if (SystemEventHierarchyEntryThreadLocal.push(Layout.class, layout.getPlid()) == null) {
            layoutLocalService.deleteLayout(layout, updateLayoutSet, serviceContext);
        } else {
            try {
                layoutLocalService.deleteLayout(layout, updateLayoutSet, serviceContext);
                SystemEventHierarchyEntry systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek();
                SystemEventLocalServiceUtil.addSystemEvent(0L, layout.getGroupId(), Layout.class.getName(), layout.getPlid(), layout.getUuid(), null, 1, systemEventHierarchyEntry.getExtraData());
            }
            finally {
                SystemEventHierarchyEntryThreadLocal.pop(Layout.class, layout.getPlid());
            }
        }
    }

    protected Layout getProxiedLayout(Layout layout) {
        ServiceContext serviceContext;
        ObjectValuePair<ServiceContext, Map<Layout, Object>> objectValuePair = ProxiedLayoutsThreadLocal.getProxiedLayouts();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        if (objectValuePair != null && (serviceContext = objectValuePair.getKey()) == currentServiceContext) {
            Map<Layout, Object> proxiedLayouts = objectValuePair.getValue();
            Object proxiedLayout = proxiedLayouts.get(layout);
            if (proxiedLayout != null) {
                Layout cachedProxiedLayout = (Layout)proxiedLayout;
                if (layout.getMvccVersion() == cachedProxiedLayout.getMvccVersion()) {
                    return cachedProxiedLayout;
                }
                proxiedLayouts.remove(layout);
            }
            proxiedLayout = ProxyUtil.newProxyInstance(PortalClassLoaderUtil.getClassLoader(), new Class[]{Layout.class, ModelWrapper.class}, new LayoutStagingHandler(layout));
            proxiedLayouts.put(layout, proxiedLayout);
            return (Layout)proxiedLayout;
        }
        Object proxiedLayout = ProxyUtil.newProxyInstance(PortalClassLoaderUtil.getClassLoader(), new Class[]{Layout.class, ModelWrapper.class}, new LayoutStagingHandler(layout));
        HashMap<Layout, Object> proxiedLayouts = new HashMap<Layout, Object>();
        proxiedLayouts.put(layout, proxiedLayout);
        ProxiedLayoutsThreadLocal.setProxiedLayouts(new ObjectValuePair<ServiceContext, Map<Layout, Object>>(currentServiceContext, proxiedLayouts));
        return (Layout)proxiedLayout;
    }

    protected Layout unwrapLayout(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler(layout);
        if (layoutStagingHandler == null) {
            return layout;
        }
        return layoutStagingHandler.getLayout();
    }

    protected Layout wrapLayout(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler(layout);
        if (layoutStagingHandler != null) {
            return layout;
        }
        if (!LayoutStagingUtil.isBranchingLayout(layout)) {
            return layout;
        }
        return this.getProxiedLayout(layout);
    }

    protected List<Layout> wrapLayouts(List<Layout> layouts, boolean showIncomplete) {
        long layoutSetBranchId;
        block7: {
            if (layouts.isEmpty()) {
                return layouts;
            }
            Layout firstLayout = layouts.get(0);
            Layout wrappedFirstLayout = this.wrapLayout(firstLayout);
            if (wrappedFirstLayout == firstLayout) {
                return layouts;
            }
            layoutSetBranchId = 0L;
            if (!showIncomplete) {
                long userId = 0L;
                try {
                    userId = GetterUtil.getLong(PrincipalThreadLocal.getName());
                    if (userId > 0L) {
                        User user = UserLocalServiceUtil.getUser(userId);
                        LayoutSet layoutSet = firstLayout.getLayoutSet();
                        layoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId(user, layoutSet.getLayoutSetId());
                    }
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug("No layout set branch found for user " + userId);
                }
            }
        }
        ArrayList<Layout> wrappedLayouts = new ArrayList<Layout>(layouts.size());
        for (Layout layout : layouts) {
            Layout wrappedLayout = this.wrapLayout(layout);
            if (!showIncomplete && StagingUtil.isIncomplete(wrappedLayout, layoutSetBranchId)) continue;
            wrappedLayouts.add(wrappedLayout);
        }
        return wrappedLayouts;
    }

    protected Object wrapReturnValue(Object returnValue, boolean showIncomplete) {
        if (returnValue instanceof Layout) {
            returnValue = this.wrapLayout((Layout)((Object)returnValue));
        } else if (returnValue instanceof List) {
            Object object;
            List list = returnValue;
            if (!list.isEmpty() && (object = list.get(0)) instanceof Layout) {
                returnValue = this.wrapLayouts(returnValue, showIncomplete);
            }
        } else if (returnValue instanceof Map) {
            Map map = (Map)((Object)returnValue);
            if (map.isEmpty()) {
                return returnValue;
            }
            map.replaceAll((key, value) -> this.wrapReturnValue(value, showIncomplete));
        }
        return returnValue;
    }

    private class LayoutLocalServiceStagingInvocationHandler
    implements InvocationHandler {
        private final LayoutLocalServiceStagingAdvice _layoutLocalServiceStagingAdvice;
        private final Object _targetObject;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            if (!StagingAdvicesThreadLocal.isEnabled()) {
                return this._invoke(method, arguments);
            }
            String methodName = method.getName();
            if (!_layoutLocalServiceStagingAdviceMethodNames.contains(methodName)) {
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), false);
            }
            Object returnValue = null;
            Object[] parameterTypes = method.getParameterTypes();
            if (methodName.equals("create")) return this._invoke(method, arguments);
            if (methodName.equals("createLayout")) {
                return this._invoke(method, arguments);
            }
            if (methodName.equals("deleteLayout")) {
                if (arguments.length == 3) {
                    LayoutLocalServiceStagingAdvice.this.deleteLayout((LayoutLocalService)this._targetObject, (Layout)arguments[0], (Boolean)arguments[1], (ServiceContext)arguments[2]);
                    return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
                } else {
                    if (arguments.length != 4) return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), false);
                    LayoutLocalServiceStagingAdvice.this.deleteLayout((LayoutLocalService)this._targetObject, (Long)arguments[0], (Boolean)arguments[1], (Long)arguments[2], (ServiceContext)arguments[3]);
                }
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
            }
            if (methodName.equals("getLayouts")) {
                boolean showIncomplete = false;
                if (arguments.length == 6 && parameterTypes[3].equals(Boolean.TYPE)) {
                    showIncomplete = (Boolean)arguments[3];
                    return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), showIncomplete);
                } else if (arguments.length == 7 && parameterTypes[3].equals(Boolean.TYPE)) {
                    showIncomplete = (Boolean)arguments[3];
                    return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), showIncomplete);
                } else {
                    if (!Arrays.equals(parameterTypes, _GET_LAYOUTS_TYPES)) return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), showIncomplete);
                    showIncomplete = true;
                }
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), showIncomplete);
            }
            if (methodName.equals("updateLayout") && arguments.length == 15) {
                HashMap<Locale, String> friendlyURLMap = null;
                if (Arrays.equals(parameterTypes, _UPDATE_LAYOUT_PARAMETER_TYPES)) {
                    friendlyURLMap = new HashMap<Locale, String>();
                    friendlyURLMap.put(LocaleUtil.getSiteDefault(), (String)arguments[11]);
                } else {
                    friendlyURLMap = (Map)arguments[11];
                }
                returnValue = LayoutLocalServiceStagingAdvice.this.updateLayout((LayoutLocalService)this._targetObject, (Long)arguments[0], (Boolean)arguments[1], (Long)arguments[2], (Long)arguments[3], (Map)arguments[4], (Map)arguments[5], (Map)arguments[6], (Map)arguments[7], (Map)arguments[8], (String)arguments[9], (Boolean)arguments[10], friendlyURLMap, (Boolean)arguments[12], (byte[])arguments[13], (ServiceContext)arguments[14]);
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
            }
            try {
                Class<LayoutLocalServiceStagingAdvice> clazz = LayoutLocalServiceStagingAdvice.class;
                parameterTypes = (Class[])ArrayUtil.append(new Class[]{LayoutLocalService.class}, parameterTypes);
                Method layoutLocalServiceStagingAdviceMethod = clazz.getMethod(methodName, (Class<?>[])parameterTypes);
                arguments = ArrayUtil.append(new Object[]{this._targetObject}, arguments);
                returnValue = layoutLocalServiceStagingAdviceMethod.invoke((Object)this._layoutLocalServiceStagingAdvice, arguments);
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            catch (NoSuchMethodException nsme) {
                returnValue = this._invoke(method, arguments);
            }
            return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
        }

        private LayoutLocalServiceStagingInvocationHandler(LayoutLocalServiceStagingAdvice layoutLocalServiceStagingAdvice2, Object targetObject) {
            this._layoutLocalServiceStagingAdvice = layoutLocalServiceStagingAdvice2;
            this._targetObject = targetObject;
        }

        private Object _invoke(Method method, Object[] arguments) throws Throwable {
            try {
                return method.invoke(this._targetObject, arguments);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }
}

