/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutException;
import com.liferay.portal.kernel.exception.SitemapChangeFrequencyException;
import com.liferay.portal.kernel.exception.SitemapIncludeException;
import com.liferay.portal.kernel.exception.SitemapPagePriorityException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutReference;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.LayoutVersion;
import com.liferay.portal.kernel.model.PortalPreferences;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.version.VersionServiceListener;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.LayoutComparator;
import com.liferay.portal.kernel.util.comparator.LayoutPriorityComparator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.service.base.LayoutLocalServiceBaseImpl;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class LayoutLocalServiceImpl
extends LayoutLocalServiceBaseImpl {
    @BeanReference(type=LayoutLocalServiceHelper.class)
    protected LayoutLocalServiceHelper layoutLocalServiceHelper;
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceImpl.class);
    private static final ThreadLocal<Long> _virtualLayoutTargetGroupId = new CentralizedThreadLocal<Long>(LayoutLocalServiceImpl.class + "._virtualLayoutTargetGroupId", () -> 0L);

    public static String getCounterName(long groupId, boolean privateLayout) {
        StringBundler sb = new StringBundler(5);
        sb.append(Layout.class.getName());
        sb.append("#");
        sb.append(groupId);
        sb.append("#");
        sb.append(privateLayout);
        return sb.toString();
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, long classNameId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        LayoutTypePortlet layoutTypePortlet;
        User user = this.userPersistence.findByPrimaryKey(userId);
        long layoutId = this.getNextLayoutId(groupId, privateLayout);
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        friendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = friendlyURLMap.get(LocaleUtil.getSiteDefault());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(typeSettings);
        int priority = Integer.MAX_VALUE;
        if (!system) {
            priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, null, -1);
        }
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURLMap, serviceContext);
        Date now = new Date();
        Layout draftLayout = this.create();
        String uuid = serviceContext.getUuid();
        if (Validator.isNotNull(uuid)) {
            draftLayout.setUuid(uuid);
        }
        draftLayout.setGroupId(groupId);
        draftLayout.setCompanyId(user.getCompanyId());
        draftLayout.setUserId(user.getUserId());
        draftLayout.setUserName(user.getFullName());
        draftLayout.setCreateDate(serviceContext.getCreateDate(now));
        draftLayout.setModifiedDate(serviceContext.getModifiedDate(now));
        draftLayout.setParentPlid(this._getParentPlid(groupId, privateLayout, parentLayoutId));
        draftLayout.setPrivateLayout(privateLayout);
        draftLayout.setLayoutId(layoutId);
        draftLayout.setParentLayoutId(parentLayoutId);
        draftLayout.setClassNameId(classNameId);
        draftLayout.setClassPK(classPK);
        draftLayout.setNameMap(nameMap);
        draftLayout.setTitleMap(titleMap);
        draftLayout.setDescriptionMap(descriptionMap);
        draftLayout.setKeywordsMap(keywordsMap);
        draftLayout.setRobotsMap(robotsMap);
        draftLayout.setType(type);
        draftLayout.setHidden(hidden);
        draftLayout.setSystem(system);
        draftLayout.setFriendlyURL(friendlyURL);
        draftLayout.setPriority(priority);
        draftLayout.setPublishDate(serviceContext.getModifiedDate(now));
        boolean layoutUpdateable = ParamUtil.getBoolean(serviceContext, "layoutUpdateable", true);
        if (!layoutUpdateable) {
            typeSettingsProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
        }
        if (privateLayout) {
            typeSettingsProperties.put("privateLayout", String.valueOf(privateLayout));
        }
        this.validateTypeSettingsProperties(draftLayout, typeSettingsProperties);
        draftLayout.setTypeSettingsProperties(typeSettingsProperties);
        String layoutPrototypeUuid = ParamUtil.getString(serviceContext, "layoutPrototypeUuid");
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean(serviceContext, "layoutPrototypeLinkEnabled", PropsValues.LAYOUT_PROTOTYPE_LINK_ENABLED_DEFAULT);
        if (Validator.isNotNull(layoutPrototypeUuid)) {
            draftLayout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            draftLayout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        }
        draftLayout.setExpandoBridgeAttributes(serviceContext);
        if (type.equals("portlet") && Validator.isNull((layoutTypePortlet = (LayoutTypePortlet)draftLayout.getLayoutType()).getLayoutTemplateId())) {
            layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.LAYOUT_DEFAULT_TEMPLATE_ID, false);
        }
        Layout layout = this.updateDraft(draftLayout);
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURLs(user.getUserId(), user.getCompanyId(), groupId, layout.getPlid(), privateLayout, friendlyURLMap, serviceContext);
        if (Validator.isNotNull(layoutPrototypeUuid) && !layoutPrototypeLinkEnabled) {
            this._applyLayoutPrototype(layoutPrototypeUuid, layout, layoutPrototypeLinkEnabled);
        }
        boolean addGroupPermissions = true;
        Group group = this.groupLocalService.getGroup(groupId);
        if (privateLayout && (group.isUser() || group.isUserGroup())) {
            addGroupPermissions = false;
        }
        boolean addGuestPermissions = false;
        if (!privateLayout || type.equals("control_panel") || group.isLayoutSetPrototype()) {
            addGuestPermissions = true;
        }
        this.resourceLocalService.addResources(user.getCompanyId(), groupId, user.getUserId(), Layout.class.getName(), layout.getPlid(), false, addGroupPermissions, addGuestPermissions);
        this.groupLocalService.updateSite(groupId, true);
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
        layout.setLayoutSet(null);
        this.updateAsset(userId, layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        if (!system && (Objects.equals(type, "content") || Objects.equals(type, "asset_display"))) {
            serviceContext.setModifiedDate(now);
            this.addLayout(userId, groupId, privateLayout, parentLayoutId, this.classNameLocalService.getClassNameId(Layout.class), layout.getPlid(), nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, true, true, Collections.emptyMap(), serviceContext);
        }
        return this.layoutLocalService.getLayout(layout.getPlid());
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, 0L, 0L, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, system, friendlyURLMap, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, false, friendlyURLMap, serviceContext);
    }

    @Override
    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, boolean system, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(locale, name);
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(locale, title);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, description);
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        friendlyURLMap.put(LocaleUtil.getSiteDefault(), friendlyURL);
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, new HashMap<Locale, String>(), new HashMap<Locale, String>(), type, "", hidden, system, friendlyURLMap, serviceContext);
    }

    @Override
    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, false, friendlyURL, serviceContext);
    }

    @Override
    public void anonymizeLayout(Layout layout, long userId, User anonymousUser) throws PortalException {
        if (layout == null) {
            throw new NoSuchLayoutException();
        }
        if (layout.getUserId() != userId) {
            return;
        }
        List<LayoutVersion> layoutVersions = this.layoutVersionPersistence.findByPlid(layout.getPlid());
        Stream layoutVersionStream = layoutVersions.stream();
        layoutVersionStream.forEach(layoutVersion -> {
            if (layoutVersion.getUserId() == userId) {
                layoutVersion = this.layoutVersionPersistence.remove(layoutVersion);
                layoutVersion.setNew(true);
                layoutVersion.setUserId(anonymousUser.getUserId());
                layoutVersion.setUserName(anonymousUser.getFullName());
                this.layoutVersionPersistence.update(layoutVersion);
            }
        });
        layout.setUserId(anonymousUser.getUserId());
        layout.setUserName(anonymousUser.getFullName());
        this.layoutPersistence.update(layout);
    }

    @Override
    public Layout checkout(Layout layout, int version) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Layout delete(Layout layout) throws PortalException {
        return this.layoutPersistence.remove(layout);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Layout deleteDraft(Layout layout) throws PortalException {
        return this.layoutPersistence.remove(layout);
    }

    @Override
    public Layout deleteLayout(Layout layout) throws PortalException {
        this.layoutLocalService.deleteLayout(layout, true, new ServiceContext());
        return layout;
    }

    @Override
    @SystemEvent(action=1, type=1)
    public void deleteLayout(Layout layout, boolean updateLayoutSet, ServiceContext serviceContext) throws PortalException {
        Object firstLayout;
        List<Layout> rootLayouts;
        if (layout.getParentLayoutId() == 0L && (rootLayouts = this.layoutPersistence.findByG_P_P_Head(layout.getGroupId(), layout.isPrivateLayout(), 0L, layout.isHead(), 0, 2)).size() > 1 && (firstLayout = rootLayouts.get(0)).getLayoutId() == layout.getLayoutId()) {
            Layout secondLayout = rootLayouts.get(1);
            this.layoutLocalServiceHelper.validateFirstLayout(secondLayout);
        }
        List<Layout> childLayouts = this.layoutPersistence.findByG_P_P_Head(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.isHead());
        for (Layout childLayout : childLayouts) {
            this.layoutLocalService.deleteLayout(childLayout, updateLayoutSet, serviceContext);
        }
        this.layoutFriendlyURLLocalService.deleteLayoutFriendlyURLs(layout.getPlid());
        this.portletPreferencesLocalService.deletePortletPreferencesByPlid(layout.getPlid());
        this.assetEntryLocalService.deleteEntry(Layout.class.getName(), layout.getPlid());
        this.ratingsStatsLocalService.deleteStats(Layout.class.getName(), layout.getPlid());
        this.expandoRowLocalService.deleteRows(layout.getPlid());
        this.imageLocalService.deleteImage(layout.getIconImageId());
        Group scopeGroup = layout.getScopeGroup();
        if (scopeGroup != null) {
            this.groupLocalService.deleteGroup(scopeGroup.getGroupId());
        }
        String primKey = layout.getPlid() + "_LAYOUT_" + "%";
        List<ResourcePermission> resourcePermissions = this.resourcePermissionPersistence.findByC_LikeP(layout.getCompanyId(), primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
        }
        this.resourceLocalService.deleteResource(layout.getCompanyId(), Layout.class.getName(), 4, layout.getPlid());
        Layout draftLayout = this.fetchLayout(this.classNameLocalService.getClassNameId(Layout.class), layout.getPlid());
        if (draftLayout != null) {
            this.layoutLocalService.deleteLayout(draftLayout);
        }
        layout = this.delete(layout);
        if (updateLayoutSet) {
            this.layoutSetLocalService.updatePageCount(layout.getGroupId(), layout.isPrivateLayout());
        }
        this._resetPortalPreferences(layout);
        SystemEventHierarchyEntry systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek();
        if (systemEventHierarchyEntry != null && systemEventHierarchyEntry.hasTypedModel(Layout.class.getName(), layout.getPlid())) {
            systemEventHierarchyEntry.setExtraDataValue("privateLayout", String.valueOf(layout.isPrivateLayout()));
        }
        Indexer<Layout> indexer = IndexerRegistryUtil.getIndexer(Layout.class);
        indexer.delete(layout);
    }

    @Override
    public Layout deleteLayout(long plid) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        this.layoutLocalService.deleteLayout(layout, true, new ServiceContext());
        return layout;
    }

    @Override
    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        this.layoutLocalService.deleteLayout(layout, true, serviceContext);
    }

    @Override
    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        this.layoutLocalService.deleteLayout(layout, true, serviceContext);
    }

    @Override
    public void deleteLayouts(long groupId, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        List<Layout> layouts = this.layoutPersistence.findByG_P_P_Head(groupId, privateLayout, 0L, false, -1, -1, (OrderByComparator<Layout>)new LayoutPriorityComparator(false));
        for (Layout layout : layouts) {
            try {
                this.layoutLocalService.deleteLayout(layout, false, serviceContext);
            }
            catch (NoSuchLayoutException nsle) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(nsle, nsle);
            }
        }
        if (GetterUtil.getBoolean(serviceContext.getAttribute("updatePageCount"), true)) {
            this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
        }
        this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
    }

    @Override
    public Layout fetchDefaultLayout(long groupId, boolean privateLayout) {
        List<Layout> layouts;
        if (groupId > 0L && !(layouts = this.layoutPersistence.findByG_P_Head(groupId, privateLayout, false, 0, 1)).isEmpty()) {
            return layouts.get(0);
        }
        return null;
    }

    @Override
    public Layout fetchDraft(Layout layout) {
        return layout;
    }

    @Override
    public Layout fetchDraft(long primaryKey) {
        return this.layoutPersistence.fetchByPrimaryKey(primaryKey);
    }

    @Override
    public Layout fetchFirstLayout(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.fetchByG_P_P_Head_First(groupId, privateLayout, parentLayoutId, false, new LayoutPriorityComparator());
    }

    @Override
    public Layout fetchFirstLayout(long groupId, boolean privateLayout, long parentLayoutId, boolean hidden) {
        return this.layoutPersistence.fetchByG_P_P_H_Head_First(groupId, privateLayout, parentLayoutId, hidden, false, new LayoutPriorityComparator());
    }

    @Override
    public LayoutVersion fetchLatestVersion(Layout layout) {
        return null;
    }

    @Override
    public Layout fetchLayout(long groupId, boolean privateLayout, long layoutId) {
        return this.layoutPersistence.fetchByG_P_L_Head(groupId, privateLayout, layoutId, false);
    }

    @Override
    public Layout fetchLayout(long classNameId, long classPK) {
        return this.layoutPersistence.fetchByC_C_Head(classNameId, classPK, false);
    }

    @Override
    public Layout fetchLayout(String uuid, long groupId, boolean privateLayout) {
        return this.layoutPersistence.fetchByUUID_G_P_Head(uuid, groupId, privateLayout, false);
    }

    @Override
    public Layout fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        return this.layoutPersistence.fetchByG_P_F_Head(groupId, privateLayout, friendlyURL, false);
    }

    @Override
    public Layout fetchLayoutByIconImageId(boolean privateLayout, long iconImageId) throws PortalException {
        return this.layoutPersistence.fetchByP_I_Head(privateLayout, iconImageId, false);
    }

    @Override
    public Layout fetchLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) {
        return this.layoutPersistence.fetchByUUID_G_P_Head(uuid, groupId, privateLayout, false);
    }

    @Override
    public LayoutVersion fetchLayoutVersion(long layoutVersionId) {
        return this.layoutVersionPersistence.fetchByPrimaryKey(layoutVersionId);
    }

    @Override
    public Layout fetchPublished(Layout layout) {
        return layout;
    }

    @Override
    public Layout fetchPublished(long primaryKey) {
        return this.layoutPersistence.fetchByPrimaryKey(primaryKey);
    }

    @Override
    public long getDefaultPlid(long groupId) {
        List<Layout> layouts;
        if (groupId > 0L && !(layouts = this.layoutPersistence.findByGroupId_Head(groupId, false, 0, 1)).isEmpty()) {
            Layout layout = layouts.get(0);
            return layout.getPlid();
        }
        return 0L;
    }

    @Override
    public long getDefaultPlid(long groupId, boolean privateLayout) {
        Layout layout = this.fetchDefaultLayout(groupId, privateLayout);
        if (layout != null) {
            return layout.getPlid();
        }
        return 0L;
    }

    @Override
    public long getDefaultPlid(long groupId, boolean privateLayout, String portletId) throws PortalException {
        if (groupId > 0L) {
            List<Layout> layouts = this.layoutPersistence.findByG_P_Head(groupId, privateLayout, false);
            for (Layout layout : layouts) {
                LayoutTypePortlet layoutTypePortlet;
                if (!layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
                return layout.getPlid();
            }
        }
        return 0L;
    }

    @Override
    public Layout getDraft(Layout layout) throws PortalException {
        return layout;
    }

    @Override
    public Layout getDraft(long primaryKey) throws PortalException {
        return this.layoutPersistence.findByPrimaryKey(primaryKey);
    }

    @Override
    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        if (Validator.isNull(friendlyURL)) {
            StringBundler sb = new StringBundler(5);
            sb.append("{groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append("}");
            throw new NoSuchLayoutException(sb.toString());
        }
        friendlyURL = HttpUtil.decodeURL(friendlyURL);
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(friendlyURL);
        Layout layout = null;
        List<LayoutFriendlyURL> layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByG_P_F(groupId, privateLayout, friendlyURL, 0, 1);
        if (!layoutFriendlyURLs.isEmpty()) {
            LayoutFriendlyURL layoutFriendlyURL = layoutFriendlyURLs.get(0);
            layout = this.layoutPersistence.findByPrimaryKey(layoutFriendlyURL.getPlid());
        }
        if (layout == null && friendlyURL.startsWith("/") && Validator.isNumber(friendlyURL.substring(1))) {
            long layoutId = GetterUtil.getLong(friendlyURL.substring(1));
            layout = this.layoutPersistence.fetchByG_P_L_Head(groupId, privateLayout, layoutId, false);
        }
        if (layout == null) {
            StringBundler sb = new StringBundler(7);
            sb.append("{groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append(", friendlyURL=");
            sb.append(friendlyURL);
            sb.append("}");
            throw new NoSuchLayoutException(sb.toString());
        }
        return layout;
    }

    @Override
    public Layout getLayout(long plid) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        if (this._mergeLayout(layout, plid)) {
            return this.layoutPersistence.findByPrimaryKey(plid);
        }
        return layout;
    }

    @Override
    public Layout getLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        if (this._mergeLayout(layout, groupId, privateLayout, layoutId)) {
            return this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        }
        return layout;
    }

    @Override
    public Layout getLayoutByIconImageId(long iconImageId) throws PortalException {
        return this.layoutPersistence.findByIconImageId_Head(iconImageId, false);
    }

    @Override
    public Layout getLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) throws PortalException {
        return this.layoutPersistence.findByUUID_G_P_Head(uuid, groupId, privateLayout, false);
    }

    @Override
    @Deprecated
    public Map<Long, List<Layout>> getLayoutChildLayouts(LayoutSet layoutSet, List<Layout> parentLayouts) {
        return this.getLayoutChildLayouts(parentLayouts);
    }

    @Override
    public Map<Long, List<Layout>> getLayoutChildLayouts(List<Layout> parentLayouts) {
        HashMap<LayoutSet, List> layoutsMap = new HashMap<LayoutSet, List>();
        for (Layout layout : parentLayouts) {
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                Layout sourceLayout = virtualLayout.getSourceLayout();
                LayoutSet sourceLayoutSet = sourceLayout.getLayoutSet();
                List layouts = layoutsMap.computeIfAbsent(sourceLayoutSet, key -> new ArrayList());
                layouts.add(sourceLayout);
                continue;
            }
            List list = layoutsMap.computeIfAbsent(layout.getLayoutSet(), key -> new ArrayList());
            list.add(layout);
        }
        ArrayList<Layout> childLayouts = new ArrayList<Layout>();
        for (Map.Entry entry : layoutsMap.entrySet()) {
            List<Layout> newChildLayouts = this._getChildLayouts((LayoutSet)entry.getKey(), ListUtil.toLongArray((List)entry.getValue(), LayoutModel::getLayoutId));
            childLayouts.addAll(newChildLayouts);
        }
        HashMap<Long, List<Layout>> hashMap = new HashMap<Long, List<Layout>>();
        for (Layout childLayout : childLayouts) {
            List layoutChildLayouts = hashMap.computeIfAbsent(childLayout.getParentPlid(), parentPlid -> new ArrayList());
            layoutChildLayouts.add(childLayout);
        }
        for (List layoutChildLayouts : hashMap.values()) {
            layoutChildLayouts.sort(Comparator.comparing(LayoutModel::getPriority));
        }
        return hashMap;
    }

    @Override
    public List<Layout> getLayouts(long companyId) {
        return this.layoutPersistence.findByCompanyId_Head(companyId, false);
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout) {
        return this.layoutPersistence.findByG_P_Head(groupId, privateLayout, false);
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout, int start, int end, OrderByComparator<Layout> obc) {
        return this.layoutPersistence.findByG_P_Head(groupId, privateLayout, false, start, end, obc);
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.getLayouts(groupId, privateLayout, parentLayoutId, false, -1, -1, null);
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) {
        return this.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end, null);
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end, OrderByComparator<Layout> obc) {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return this.layoutPersistence.findByG_P_P_Head(groupId, privateLayout, parentLayoutId, false, start, end, obc);
        }
        try {
            Group group = this.groupLocalService.getGroup(groupId);
            LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
            if (layoutSet.isLayoutSetPrototypeLinkActive() && !this._mergeLayouts(group, layoutSet, groupId, privateLayout, parentLayoutId, start, end, obc)) {
                return this.layoutPersistence.findByG_P_P_Head(groupId, privateLayout, parentLayoutId, false, start, end, obc);
            }
            List<Layout> layouts = this.layoutPersistence.findByG_P_P_Head(groupId, privateLayout, parentLayoutId, false, start, end, obc);
            return this._injectVirtualLayouts(group, layoutSet, layouts, parentLayoutId);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout, long[] layoutIds) throws PortalException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (long layoutId : layoutIds) {
            Layout layout = this.getLayout(groupId, privateLayout, layoutId);
            layouts.add(layout);
        }
        return layouts;
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        List<Layout> layouts = this.layoutPersistence.findByG_P_T_Head(groupId, privateLayout, type, false);
        if (!group.isUser()) {
            return layouts;
        }
        layouts = new ArrayList<Layout>(layouts);
        HashSet<Long> checkedPlids = new HashSet<Long>();
        ArrayDeque<Long> checkParentLayoutIds = new ArrayDeque<Long>();
        checkParentLayoutIds.add(0L);
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P_Head(groupId, privateLayout, false);
        while (!checkParentLayoutIds.isEmpty()) {
            long parentLayoutId = (Long)checkParentLayoutIds.poll();
            List<Layout> userGroupLayouts = this._addUserGroupLayouts(group, layoutSet, Collections.emptyList(), parentLayoutId);
            for (Layout userGroupLayout : userGroupLayouts) {
                long userGroupPlid = userGroupLayout.getPlid();
                if (!checkedPlids.add(userGroupPlid)) continue;
                layouts.add(userGroupLayout);
                checkParentLayoutIds.add(userGroupLayout.getLayoutId());
            }
        }
        return layouts;
    }

    @Override
    public List<Layout> getLayouts(long groupId, boolean privateLayout, String keywords, String[] types, int start, int end, OrderByComparator<Layout> obc) throws PortalException {
        if (Validator.isNull(keywords)) {
            return this.getLayouts(groupId, privateLayout, start, end, obc);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(groupId, privateLayout, keywords, types, start, end, obc));
        List<Document> documents = hits.toList();
        ArrayList<Layout> layouts = new ArrayList<Layout>(documents.size());
        for (Document document : documents) {
            layouts.add(this.getLayout(GetterUtil.getLong(document.get("entryClassPK"))));
        }
        return layouts;
    }

    @Override
    public List<Layout> getLayouts(long groupId, int start, int end, OrderByComparator<Layout> obc) {
        return this.layoutPersistence.findByGroupId_Head(groupId, false, start, end, obc);
    }

    @Override
    public LayoutReference[] getLayouts(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        List<LayoutReference> layoutReferences = this.layoutFinder.findByC_P_P(companyId, portletId, preferencesKey, preferencesValue);
        return layoutReferences.toArray(new LayoutReference[0]);
    }

    @Override
    public List<Layout> getLayouts(long groupId, String keywords, String[] types, int start, int end, OrderByComparator<Layout> obc) throws PortalException {
        if (Validator.isNull(keywords)) {
            return this.getLayouts(groupId, start, end, obc);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(groupId, null, keywords, types, start, end, obc));
        List<Document> documents = hits.toList();
        ArrayList<Layout> layouts = new ArrayList<Layout>(documents.size());
        for (Document document : documents) {
            layouts.add(this.getLayout(GetterUtil.getLong(document.get("entryClassPK"))));
        }
        return layouts;
    }

    @Override
    public List<Layout> getLayoutsByLayoutPrototypeUuid(String layoutPrototypeUuid) {
        return this.layoutPersistence.findByLayoutPrototypeUuid_Head(layoutPrototypeUuid, false);
    }

    @Override
    public int getLayoutsByLayoutPrototypeUuidCount(String layoutPrototypeUuid) {
        return this.layoutPersistence.countByLayoutPrototypeUuid_Head(layoutPrototypeUuid, false);
    }

    @Override
    public List<Layout> getLayoutsByUuidAndCompanyId(String uuid, long companyId) {
        return this.layoutPersistence.findByUuid_C_Head(uuid, companyId, false);
    }

    @Override
    public List<Layout> getLayoutsByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<Layout> orderByComparator) {
        return this.layoutPersistence.findByUuid_C_Head(uuid, companyId, false, start, end, orderByComparator);
    }

    @Override
    public int getLayoutsCount(Group group, boolean privateLayout) throws PortalException {
        return this.getLayoutsCount(group, privateLayout, true);
    }

    @Override
    public int getLayoutsCount(Group group, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        int count = this.layoutPersistence.countByG_P_Head(group.getGroupId(), privateLayout, false);
        if (!group.isUser() || !includeUserGroups) {
            return count;
        }
        long[] userGroupIds = this.userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                count += this.layoutPersistence.countByG_P_Head(userGroupGroup.getGroupId(), privateLayout, false);
            }
        }
        return count;
    }

    @Override
    public int getLayoutsCount(Group group, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.countByG_P_P_Head(group.getGroupId(), privateLayout, parentLayoutId, false);
    }

    @Override
    public int getLayoutsCount(Group group, boolean privateLayout, long[] layoutIds) {
        if (ArrayUtil.isEmpty(layoutIds)) {
            return 0;
        }
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property groupIdProperty = PropertyFactoryUtil.forName("groupId");
        dynamicQuery.add(groupIdProperty.eq(group.getGroupId()));
        Property privateLayoutProperty = PropertyFactoryUtil.forName("privateLayout");
        dynamicQuery.add(privateLayoutProperty.eq(privateLayout));
        Property layoutIdProperty = PropertyFactoryUtil.forName("layoutId");
        dynamicQuery.add(layoutIdProperty.in(layoutIds));
        return GetterUtil.getInteger(this.dynamicQueryCount(dynamicQuery));
    }

    @Override
    public int getLayoutsCount(Group group, boolean privateLayout, String keywords, String[] types) throws PortalException {
        if (Validator.isNull(keywords)) {
            return this.getLayoutsCount(group, privateLayout);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(group.getGroupId(), privateLayout, keywords, types, -1, -1, null));
        return hits.getLength();
    }

    @Override
    public int getLayoutsCount(long groupId) {
        return this.layoutPersistence.countByGroupId_Head(groupId, false);
    }

    @Override
    public int getLayoutsCount(long groupId, String keywords, String[] types) throws PortalException {
        if (Validator.isNull(keywords)) {
            return this.getLayoutsCount(groupId);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(groupId, null, keywords, types, -1, -1, null));
        return hits.getLength();
    }

    @Override
    public int getLayoutsCount(User user, boolean privateLayout) throws PortalException {
        return this.getLayoutsCount(user, privateLayout, true);
    }

    @Override
    public int getLayoutsCount(User user, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        Group group = this.groupPersistence.findByC_C_C(user.getCompanyId(), classNameId, user.getUserId());
        return this.getLayoutsCount(group, privateLayout, includeUserGroups);
    }

    @Override
    public long getNextLayoutId(long groupId, boolean privateLayout) {
        List<Layout> layouts;
        long nextLayoutId = this.counterLocalService.increment(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
        if (nextLayoutId == 1L && !(layouts = this.layoutPersistence.findByG_P_Head(groupId, privateLayout, false, 0, 1, new LayoutComparator())).isEmpty()) {
            Layout layout = layouts.get(0);
            nextLayoutId = layout.getLayoutId() + 1L;
            this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout), nextLayoutId);
        }
        return nextLayoutId;
    }

    @Override
    @Deprecated
    public List<Layout> getNoPermissionLayouts(long roleId) {
        return this.layoutFinder.findByNoPermissions(roleId);
    }

    @Override
    @Deprecated
    public List<Layout> getNullFriendlyURLLayouts() {
        return this.layoutFinder.findByNullFriendlyURL();
    }

    @Override
    public Layout getParentLayout(Layout layout) throws PortalException {
        Layout parentLayout = null;
        if (layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            Layout sourceLayout = virtualLayout.getSourceLayout();
            parentLayout = this.getLayout(sourceLayout.getGroupId(), sourceLayout.isPrivateLayout(), sourceLayout.getParentLayoutId());
            parentLayout = new VirtualLayout(parentLayout, layout.getGroup());
        } else {
            parentLayout = this.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        }
        return parentLayout;
    }

    @Override
    public List<Layout> getScopeGroupLayouts(long parentGroupId) throws PortalException {
        int count;
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_ENABLED) {
            return this.layoutFinder.findByScopeGroup(parentGroupId);
        }
        Group parentGroup = this.groupPersistence.findByPrimaryKey(parentGroupId);
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD >= 0 && (count = this.groupLocalService.getGroupsCount(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId)) >= PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD) {
            return this.layoutFinder.findByScopeGroup(parentGroupId);
        }
        List<Group> groups = this.groupLocalService.getGroups(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId);
        ArrayList<Layout> layouts = new ArrayList<Layout>(groups.size());
        for (Group group : groups) {
            layouts.add(this.layoutPersistence.findByPrimaryKey(group.getClassPK()));
        }
        return layouts;
    }

    @Override
    public List<Layout> getScopeGroupLayouts(long parentGroupId, boolean privateLayout) throws PortalException {
        int count;
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_ENABLED) {
            return this.layoutFinder.findByScopeGroup(parentGroupId, privateLayout);
        }
        Group parentGroup = this.groupPersistence.findByPrimaryKey(parentGroupId);
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD >= 0 && (count = this.groupLocalService.getGroupsCount(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId)) >= PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD) {
            return this.layoutFinder.findByScopeGroup(parentGroupId, privateLayout);
        }
        List<Group> groups = this.groupLocalService.getGroups(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId);
        ArrayList<Layout> layouts = new ArrayList<Layout>(groups.size());
        for (Group group : groups) {
            Layout layout = this.layoutPersistence.findByPrimaryKey(group.getClassPK());
            if (layout.isPrivateLayout() != privateLayout) continue;
            layouts.add(layout);
        }
        return layouts;
    }

    @Override
    public LayoutVersion getVersion(Layout layout, int version) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LayoutVersion> getVersions(Layout layout) {
        return Collections.emptyList();
    }

    @Override
    public boolean hasLayout(String uuid, long groupId, boolean privateLayout) throws PortalException {
        try {
            this.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
            return true;
        }
        catch (NoSuchLayoutException nsle) {
            if (_log.isDebugEnabled()) {
                _log.debug(nsle, nsle);
            }
            return false;
        }
    }

    @Override
    public boolean hasLayouts(Group group) throws PortalException {
        List<LayoutSet> groupLayoutSets = this.layoutSetPersistence.findByGroupId_Head(group.getGroupId(), false);
        for (LayoutSet layoutSet : groupLayoutSets) {
            if (layoutSet.getPageCount() <= 0) continue;
            return true;
        }
        if (!group.isUser()) {
            return false;
        }
        long[] userGroupIds = this.userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                List<LayoutSet> userGroupGroupLayoutSets = this.layoutSetPersistence.findByGroupId_Head(userGroupGroup.getGroupId(), false);
                for (LayoutSet layoutSet : userGroupGroupLayoutSets) {
                    if (layoutSet.getPageCount() <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasLayouts(Group group, boolean privateLayout) throws PortalException {
        return this.hasLayouts(group, privateLayout, true);
    }

    @Override
    public boolean hasLayouts(Group group, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P_Head(group.getGroupId(), privateLayout, false);
        if (layoutSet.getPageCount() > 0) {
            return true;
        }
        if (!group.isUser() || !includeUserGroups) {
            return false;
        }
        long[] userGroupIds = this.userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                layoutSet = this.layoutSetPersistence.findByG_P_Head(userGroupGroup.getGroupId(), privateLayout, false);
                if (layoutSet.getPageCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasLayouts(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.countByG_P_P_Head(groupId, privateLayout, parentLayoutId, false) > 0;
    }

    @Override
    public boolean hasLayouts(User user, boolean privateLayout) throws PortalException {
        return this.hasLayouts(user, privateLayout, true);
    }

    @Override
    public boolean hasLayouts(User user, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        Group group = this.groupPersistence.findByC_C_C(user.getCompanyId(), classNameId, user.getUserId());
        return this.hasLayouts(group, privateLayout, includeUserGroups);
    }

    @Override
    public boolean hasLayoutSetPrototypeLayout(long layoutSetPrototypeId, String layoutUuid) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
        return this.layoutLocalServiceHelper.hasLayoutSetPrototypeLayout(layoutSetPrototype, layoutUuid);
    }

    @Override
    public boolean hasLayoutSetPrototypeLayout(String layoutSetPrototypeUuid, long companyId, String layoutUuid) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, companyId);
        return this.layoutLocalServiceHelper.hasLayoutSetPrototypeLayout(layoutSetPrototype, layoutUuid);
    }

    @Override
    public Layout publishDraft(Layout layout) throws PortalException {
        return this.layoutPersistence.update(layout);
    }

    @Override
    public void registerListener(VersionServiceListener<Layout, LayoutVersion> versionServiceListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException {
        if (layoutIds == null) {
            return;
        }
        if (parentLayoutId == 0L) {
            if (layoutIds.length < 1) {
                throw new RequiredLayoutException(1);
            }
            Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutIds[0], false);
            Object layoutType = layout.getLayoutType();
            if (!layoutType.isFirstPageable()) {
                throw new RequiredLayoutException(3);
            }
        }
        LinkedHashSet<Long> layoutIdsSet = new LinkedHashSet<Long>();
        for (long layoutId : layoutIds) {
            layoutIdsSet.add(layoutId);
        }
        HashSet<Long> newLayoutIdsSet = new HashSet<Long>();
        List<Layout> layouts = this.layoutPersistence.findByG_P_P_Head(groupId, privateLayout, parentLayoutId, false);
        for (Layout layout : layouts) {
            if (!layoutIdsSet.contains(layout.getLayoutId())) {
                this.deleteLayout(layout, true, serviceContext);
                continue;
            }
            newLayoutIdsSet.add(layout.getLayoutId());
        }
        int priority = 0;
        Iterator iterator = layoutIdsSet.iterator();
        while (iterator.hasNext()) {
            long layoutId = (Long)iterator.next();
            Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
            layout.setPriority(priority++);
            this.layoutLocalService.updateLayout(layout);
        }
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
    }

    @Override
    public void unregisterListener(VersionServiceListener<Layout, LayoutVersion> versionServiceListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsset(long userId, Layout layout, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        this.assetEntryLocalService.updateEntry(userId, layout.getGroupId(), layout.getCreateDate(), layout.getModifiedDate(), Layout.class.getName(), layout.getPlid(), layout.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, "text/html", layout.getName(LocaleUtil.getDefault()), null, null, null, null, 0, 0, null);
    }

    @Override
    public Layout updateDraft(Layout layout) throws PortalException {
        return this.layoutPersistence.update(layout);
    }

    @Override
    public Layout updateFriendlyURL(long userId, long plid, String friendlyURL, String languageId) throws PortalException {
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), "", friendlyURL);
        this.layoutLocalServiceHelper.validateFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), friendlyURL);
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURL(userId, layout.getCompanyId(), layout.getGroupId(), layout.getPlid(), layout.isPrivateLayout(), friendlyURL, languageId, new ServiceContext());
        layout.setModifiedDate(now);
        String defaultLanguageId = LocaleUtil.toLanguageId(LocaleUtil.getSiteDefault());
        if (languageId.equals(defaultLanguageId)) {
            layout.setFriendlyURL(friendlyURL);
        }
        return this.layoutLocalService.updateLayout(layout);
    }

    @Override
    public Layout updateIconImage(long plid, byte[] bytes) throws PortalException {
        Layout layout = this.layoutPersistence.fetchByPrimaryKey(plid);
        if (layout == null) {
            return null;
        }
        Layout draftLayout = this.getDraft(layout);
        PortalUtil.updateImageId(draftLayout, true, bytes, "iconImageId", 0L, 0, 0);
        return this.updateDraft(draftLayout);
    }

    @Override
    public Layout updateLayout(Layout layout) throws PortalException {
        return this.updateDraft(this.getDraft(layout));
    }

    @Override
    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, Date publishDate) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        Layout draftLayout = this.getDraft(layout);
        draftLayout.setPublishDate(publishDate);
        return this.updateDraft(draftLayout);
    }

    @Override
    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long classNameId, long classPK) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        Layout draftLayout = this.getDraft(layout);
        draftLayout.setClassNameId(classNameId);
        draftLayout.setClassPK(classPK);
        return this.updateDraft(draftLayout);
    }

    @Override
    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException {
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        friendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = friendlyURLMap.get(LocaleUtil.getSiteDefault());
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURLMap, serviceContext);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        Layout draftLayout = this.getDraft(layout);
        if (parentLayoutId != layout.getParentLayoutId()) {
            draftLayout.setParentPlid(this._getParentPlid(groupId, privateLayout, parentLayoutId));
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, draftLayout.getSourcePrototypeLayoutUuid(), -1);
            draftLayout.setPriority(priority);
        }
        draftLayout.setModifiedDate(serviceContext.getModifiedDate(now));
        draftLayout.setParentLayoutId(parentLayoutId);
        draftLayout.setNameMap(nameMap);
        draftLayout.setTitleMap(titleMap);
        draftLayout.setDescriptionMap(descriptionMap);
        draftLayout.setKeywordsMap(keywordsMap);
        draftLayout.setRobotsMap(robotsMap);
        draftLayout.setType(type);
        draftLayout.setHidden(hidden);
        draftLayout.setFriendlyURL(friendlyURL);
        PortalUtil.updateImageId(draftLayout, iconImage, iconBytes, "iconImageId", 0L, 0, 0);
        boolean layoutUpdateable = ParamUtil.getBoolean(serviceContext, "layoutUpdateable", true);
        UnicodeProperties typeSettingsProperties = draftLayout.getTypeSettingsProperties();
        typeSettingsProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
        if (privateLayout) {
            typeSettingsProperties.put("privateLayout", String.valueOf(privateLayout));
        }
        draftLayout.setTypeSettingsProperties(typeSettingsProperties);
        String layoutPrototypeUuid = ParamUtil.getString(serviceContext, "layoutPrototypeUuid");
        if (Validator.isNotNull(layoutPrototypeUuid)) {
            draftLayout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            boolean applyLayoutPrototype = ParamUtil.getBoolean(serviceContext, "applyLayoutPrototype");
            boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean(serviceContext, "layoutPrototypeLinkEnabled");
            draftLayout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
            if (applyLayoutPrototype) {
                serviceContext.setAttribute("applyLayoutPrototype", Boolean.FALSE);
                this._applyLayoutPrototype(layoutPrototypeUuid, draftLayout, layoutPrototypeLinkEnabled);
            }
        }
        draftLayout.setExpandoBridgeAttributes(serviceContext);
        layout = this.layoutLocalService.updateLayout(draftLayout);
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURLs(serviceContext.getUserId(), layout.getCompanyId(), layout.getGroupId(), layout.getPlid(), layout.isPrivateLayout(), friendlyURLMap, serviceContext);
        this.updateAsset(serviceContext.getUserId(), layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return layout;
    }

    @Override
    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        Date now = new Date();
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(typeSettings);
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        Layout draftLayout = this.getDraft(layout);
        this.validateTypeSettingsProperties(draftLayout, typeSettingsProperties);
        draftLayout.setModifiedDate(now);
        draftLayout.setTypeSettings(typeSettingsProperties.toString());
        if (draftLayout.isSystem() && draftLayout.getClassPK() > 0L) {
            draftLayout.setPublishDate(now);
        }
        return this.updateDraft(draftLayout);
    }

    @Override
    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        Layout draftLayout = this.getDraft(layout);
        draftLayout.setModifiedDate(now);
        draftLayout.setThemeId(themeId);
        draftLayout.setColorSchemeId(colorSchemeId);
        draftLayout.setCss(css);
        return this.updateDraft(draftLayout);
    }

    @Override
    public Layout updateName(Layout layout, String name, String languageId) throws PortalException {
        Date now = new Date();
        this.layoutLocalServiceHelper.validateName(name, languageId);
        Layout draftLayout = this.getDraft(layout);
        draftLayout.setModifiedDate(now);
        draftLayout.setName(name, LocaleUtil.fromLanguageId(languageId));
        layout = this.updateDraft(draftLayout);
        Group group = layout.getGroup();
        if (group.isLayoutPrototype()) {
            LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototype(group.getClassPK());
            layoutPrototype.setModifiedDate(now);
            layoutPrototype.setName(name, LocaleUtil.fromLanguageId(languageId));
            this.layoutPrototypePersistence.update(layoutPrototype);
        }
        return layout;
    }

    @Override
    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        return this.updateName(layout, name, languageId);
    }

    @Override
    public Layout updateName(long plid, String name, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updateName(layout, name, languageId);
    }

    @Override
    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        Layout draftLayout = this.getDraft(layout);
        if (parentLayoutId != draftLayout.getParentLayoutId()) {
            draftLayout.setParentPlid(this._getParentPlid(groupId, privateLayout, parentLayoutId));
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, draftLayout.getSourcePrototypeLayoutUuid(), -1);
            draftLayout.setPriority(priority);
        }
        draftLayout.setModifiedDate(now);
        draftLayout.setParentLayoutId(parentLayoutId);
        return this.layoutLocalService.updateLayout(draftLayout);
    }

    @Override
    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException {
        Layout parentLayout;
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        if (layout.getParentPlid() == parentPlid) {
            return layout;
        }
        Layout draftLayout = this.getDraft(layout);
        Date now = new Date();
        long parentLayoutId = 0L;
        if (parentPlid > 0L && (parentLayout = this.layoutPersistence.fetchByPrimaryKey(parentPlid)) != null) {
            parentLayoutId = parentLayout.getLayoutId();
        }
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), parentLayoutId);
        this.layoutLocalServiceHelper.validateParentLayoutId(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), parentLayoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), parentLayoutId, draftLayout.getSourcePrototypeLayoutUuid(), -1);
            draftLayout.setPriority(priority);
        }
        draftLayout.setModifiedDate(now);
        draftLayout.setParentPlid(parentPlid);
        draftLayout.setParentLayoutId(parentLayoutId);
        return this.layoutLocalService.updateLayout(draftLayout);
    }

    @Override
    public Layout updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws PortalException {
        Layout layout = this.updateParentLayoutId(plid, parentPlid);
        return this.layoutLocalService.updatePriority(layout, priority);
    }

    @Override
    public void updatePriorities(long groupId, boolean privateLayout) throws PortalException {
        List<Layout> layouts = this.layoutPersistence.findByG_P_Head(groupId, privateLayout, false);
        for (Layout layout : layouts) {
            int nextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), layout.getPriority());
            Layout draftLayout = this.getDraft(layout);
            draftLayout.setPriority(nextPriority);
            this.updateDraft(draftLayout);
        }
    }

    @Override
    public Layout updatePriority(Layout layout, int priority) throws PortalException {
        int nextPriority;
        if (layout.getPriority() == priority) {
            return layout;
        }
        int oldPriority = layout.getPriority();
        if (oldPriority == (nextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), priority))) {
            return layout;
        }
        Layout draftLayout = this.getDraft(layout);
        draftLayout.setModifiedDate(new Date());
        draftLayout.setPriority(nextPriority);
        layout = this.updateDraft(draftLayout);
        List<Layout> layouts = this.layoutPersistence.findByG_P_P_Head(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), false);
        boolean lessThan = false;
        if (oldPriority < nextPriority) {
            lessThan = true;
        }
        layouts = ListUtil.sort(layouts, new LayoutPriorityComparator(layout, lessThan));
        if (layout.getParentLayoutId() == 0L) {
            Layout firstLayout = layouts.get(0);
            this.layoutLocalServiceHelper.validateFirstLayout(firstLayout);
        }
        int newPriority = 0;
        for (Layout curLayout : layouts) {
            int curNextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), curLayout.getSourcePrototypeLayoutUuid(), newPriority++);
            if (curLayout.getPriority() == curNextPriority) continue;
            Layout curDraftLayout = this.getDraft(curLayout);
            curDraftLayout.setModifiedDate(layout.getModifiedDate());
            curDraftLayout.setPriority(curNextPriority);
            curLayout = this.updateDraft(curDraftLayout);
            if (!curLayout.equals(layout)) continue;
            layout = curLayout;
        }
        return layout;
    }

    @Override
    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        return this.updatePriority(layout, priority);
    }

    @Override
    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException {
        Layout layout = this.getLayout(groupId, privateLayout, layoutId);
        int priority = layout.getPriority();
        Layout nextLayout = null;
        if (nextLayoutId > 0L) {
            nextLayout = this.getLayout(groupId, privateLayout, nextLayoutId);
        }
        Layout previousLayout = null;
        if (previousLayoutId > 0L) {
            previousLayout = this.getLayout(groupId, privateLayout, previousLayoutId);
        }
        if (nextLayout != null && priority > nextLayout.getPriority()) {
            priority = nextLayout.getPriority();
        } else if (previousLayout != null && priority < previousLayout.getPriority()) {
            priority = previousLayout.getPriority();
        }
        return this.updatePriority(layout, priority);
    }

    @Override
    public Layout updatePriority(long plid, int priority) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updatePriority(layout, priority);
    }

    protected void validateTypeSettingsProperties(Layout layout, UnicodeProperties typeSettingsProperties) throws PortalException {
        boolean enableJavaScript;
        String sitemapChangeFrequency = typeSettingsProperties.getProperty("sitemap-changefreq");
        if (!(!Validator.isNotNull(sitemapChangeFrequency) || sitemapChangeFrequency.equals("always") || sitemapChangeFrequency.equals("hourly") || sitemapChangeFrequency.equals("daily") || sitemapChangeFrequency.equals("weekly") || sitemapChangeFrequency.equals("monthly") || sitemapChangeFrequency.equals("yearly") || sitemapChangeFrequency.equals("never"))) {
            throw new SitemapChangeFrequencyException();
        }
        String sitemapInclude = typeSettingsProperties.getProperty("sitemap-include");
        if (Validator.isNotNull(sitemapInclude) && !sitemapInclude.equals("0") && !sitemapInclude.equals("1")) {
            throw new SitemapIncludeException();
        }
        String sitemapPriority = typeSettingsProperties.getProperty("sitemap-priority");
        if (Validator.isNotNull(sitemapPriority)) {
            try {
                double priority = Double.parseDouble(sitemapPriority);
                if (priority < 0.0 || priority > 1.0) {
                    throw new SitemapPagePriorityException();
                }
            }
            catch (NumberFormatException nfe) {
                throw new SitemapPagePriorityException(nfe);
            }
        }
        if (!(enableJavaScript = PropsValues.FIELD_ENABLE_COM_LIFERAY_PORTAL_KERNEL_MODEL_LAYOUT_JAVASCRIPT)) {
            UnicodeProperties layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
            String javaScript = layoutTypeSettingsProperties.getProperty("javascript");
            typeSettingsProperties.setProperty("javascript", javaScript);
        }
    }

    private List<Layout> _addChildUserGroupLayouts(Group group, List<Layout> layouts) throws PortalException {
        ArrayList<Layout> childLayouts = new ArrayList<Layout>(layouts.size());
        for (Layout layout : layouts) {
            Group layoutGroup = layout.getGroup();
            if (layoutGroup.isUserGroup()) {
                childLayouts.add(new VirtualLayout(layout, group));
                continue;
            }
            childLayouts.add(layout);
        }
        return childLayouts;
    }

    private List<Layout> _addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long parentLayoutId) throws PortalException {
        layouts = new ArrayList<Layout>(layouts);
        List<UserGroup> userUserGroups = this.userGroupLocalService.getUserUserGroups(group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List<Layout> userGroupLayouts = this.getLayouts(userGroupGroup.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutId);
            for (Layout userGroupLayout : userGroupLayouts) {
                layouts.add(new VirtualLayout(userGroupLayout, group));
            }
        }
        return layouts;
    }

    private List<Layout> _addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long[] parentLayoutIds) throws PortalException {
        boolean copied = false;
        List<UserGroup> userUserGroups = this.userGroupLocalService.getUserUserGroups(group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List<Layout> userGroupLayouts = this.getLayouts(userGroupGroup.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds);
            for (Layout userGroupLayout : userGroupLayouts) {
                if (!copied) {
                    layouts = new ArrayList<Layout>(layouts);
                    copied = true;
                }
                layouts.add(new VirtualLayout(userGroupLayout, group));
            }
        }
        return layouts;
    }

    private void _applyLayoutPrototype(String layoutPrototypeUuid, Layout layout, boolean layoutPrototypeLinkEnabled) throws PortalException {
        LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototypeByUuidAndCompanyId(layoutPrototypeUuid, layout.getCompanyId());
        try {
            SitesUtil.applyLayoutPrototype(layoutPrototype, layout, layoutPrototypeLinkEnabled);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    private SearchContext _buildSearchContext(long groupId, Boolean privateLayout, String keywords, String[] types, int start, int end, OrderByComparator<Layout> obc) throws PortalException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("title", (Serializable)((Object)keywords));
        searchContext.setAttribute("type", (Serializable)types);
        searchContext.setAttribute("paginationType", (Serializable)((Object)"more"));
        if (privateLayout != null) {
            searchContext.setAttribute("privateLayout", (Serializable)((Object)String.valueOf(privateLayout)));
        }
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setKeywords(keywords);
        searchContext.setStart(start);
        if (obc != null) {
            searchContext.setSorts(this._getSortFromComparator(obc));
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private List<Layout> _getChildLayouts(LayoutSet layoutSet, long[] parentLayoutIds) {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return this.layoutPersistence.findByG_P_P_Head(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds, false);
        }
        try {
            Group group = this.groupPersistence.findByPrimaryKey(layoutSet.getGroupId());
            if (layoutSet.isLayoutSetPrototypeLinkActive() && !this._mergeLayouts(group, layoutSet, layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds)) {
                return this.layoutPersistence.findByG_P_P_Head(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds, false);
            }
            List<Layout> layouts = this.layoutPersistence.findByG_P_P_Head(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds, false);
            return this._injectVirtualLayouts(group, layoutSet, layouts, parentLayoutIds);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    private long _getParentPlid(long groupId, boolean privateLayout, long parentLayoutId) {
        if (parentLayoutId == 0L) {
            return 0L;
        }
        Layout parentLayout = this.layoutPersistence.fetchByG_P_L_Head(groupId, privateLayout, parentLayoutId, false);
        if (parentLayout == null) {
            return 0L;
        }
        return parentLayout.getPlid();
    }

    private Sort _getSortFromComparator(OrderByComparator<Layout> obc) {
        String[] fields = obc.getOrderByFields();
        boolean reverse = !obc.isAscending();
        String field = fields[0];
        return new Sort(field, 6, reverse);
    }

    private List<Layout> _injectVirtualLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long parentLayoutId) throws PortalException {
        long targetGroupId;
        if (MergeLayoutPrototypesThreadLocal.isInProgress() || PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            return layouts;
        }
        if (group.isUser()) {
            _virtualLayoutTargetGroupId.set(group.getGroupId());
            if (parentLayoutId == 0L) {
                return this._addUserGroupLayouts(group, layoutSet, layouts, parentLayoutId);
            }
            return this._addChildUserGroupLayouts(group, layouts);
        }
        if (group.isUserGroup() && parentLayoutId != 0L && (targetGroupId = _virtualLayoutTargetGroupId.get().longValue()) != 0L) {
            Group targetGroup = this.groupLocalService.getGroup(targetGroupId);
            return this._addChildUserGroupLayouts(targetGroup, layouts);
        }
        return layouts;
    }

    private List<Layout> _injectVirtualLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long[] parentLayoutIds) throws PortalException {
        long targetGroupId;
        if (MergeLayoutPrototypesThreadLocal.isInProgress() || PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            return layouts;
        }
        if (group.isUser()) {
            _virtualLayoutTargetGroupId.set(group.getGroupId());
            if (ArrayUtil.contains(parentLayoutIds, 0L)) {
                this._addUserGroupLayouts(group, layoutSet, layouts, parentLayoutIds);
                if (parentLayoutIds.length == 1) {
                    return layouts;
                }
            }
            return this._addChildUserGroupLayouts(group, layouts);
        }
        if (group.isUserGroup() && (targetGroupId = _virtualLayoutTargetGroupId.get().longValue()) != 0L) {
            Group targetGroup = this.groupLocalService.getGroup(targetGroupId);
            return this._addChildUserGroupLayouts(targetGroup, layouts);
        }
        return layouts;
    }

    private boolean _mergeLayout(Layout layout, Object ... arguments) throws PortalException {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return false;
        }
        Group group = layout.getGroup();
        if (MergeLayoutPrototypesThreadLocal.isMergeComplete("getLayout", arguments) && (!group.isUser() || PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE)) {
            return false;
        }
        if (Validator.isNull(layout.getLayoutPrototypeUuid()) && Validator.isNull(layout.getSourcePrototypeLayoutUuid())) {
            return false;
        }
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        LayoutSet layoutSet = layout.getLayoutSet();
        try {
            WorkflowThreadLocal.setEnabled(false);
            SitesUtil.mergeLayoutPrototypeLayout(group, layout);
            if (Validator.isNotNull(layout.getSourcePrototypeLayoutUuid())) {
                SitesUtil.mergeLayoutSetPrototypeLayouts(group, layoutSet);
            }
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setMergeComplete("getLayout", arguments);
            WorkflowThreadLocal.setEnabled(workflowEnabled);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _mergeLayouts(Group group, LayoutSet layoutSet, Object ... arguments) {
        if (MergeLayoutPrototypesThreadLocal.isMergeComplete("getLayouts", arguments) && (!group.isUser() || PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE)) {
            return false;
        }
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            if (SitesUtil.isLayoutSetMergeable(group, layoutSet)) {
                WorkflowThreadLocal.setEnabled(false);
                SitesUtil.mergeLayoutSetPrototypeLayouts(group, layoutSet);
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to merge layouts for site template", e);
            }
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setMergeComplete("getLayouts", arguments);
            WorkflowThreadLocal.setEnabled(workflowEnabled);
        }
        return true;
    }

    private void _resetPortalPreferences(Layout layout) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(PortalPreferences.class, this.getClassLoader());
        dynamicQuery.add(RestrictionsFactoryUtil.eq("ownerType", 4));
        dynamicQuery.add(RestrictionsFactoryUtil.like("preferences", "%" + CustomizedPages.namespacePlid(layout.getPlid()) + "%"));
        List portalPreferenceses = this.portalPreferencesLocalService.dynamicQuery(dynamicQuery);
        for (PortalPreferences portalPreferences : portalPreferenceses) {
            PortalPreferencesImpl portalPreferencesImpl = new PortalPreferencesImpl(portalPreferences, false);
            portalPreferencesImpl.resetValues(CustomizedPages.namespacePlid(layout.getPlid()));
        }
    }
}

