/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLsException;
import com.liferay.portal.kernel.exception.LayoutNameException;
import com.liferay.portal.kernel.exception.LayoutParentLayoutIdException;
import com.liferay.portal.kernel.exception.LayoutTypeException;
import com.liferay.portal.kernel.exception.LocalizedException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLResolverRegistryUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.LayoutFriendlyURLPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetPersistence;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.LayoutPriorityComparator;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LayoutLocalServiceHelper
implements IdentifiableOSGiService {
    @BeanReference(type=LayoutFriendlyURLPersistence.class)
    protected LayoutFriendlyURLPersistence layoutFriendlyURLPersistence;
    @BeanReference(type=LayoutPersistence.class)
    protected LayoutPersistence layoutPersistence;
    @BeanReference(type=LayoutSetPersistence.class)
    protected LayoutSetPersistence layoutSetPersistence;
    @BeanReference(type=ResourcePermissionLocalService.class)
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    private static final String _FRIENDLY_URL_SEPARATOR_HEAD = "/-/".substring(0, "/-/".length() - 1);
    private static final int _PRIORITY_BUFFER = 1000000;
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceHelper.class);
    private static final Pattern _urlSeparatorPattern = Pattern.compile("/[A-Za-z]");

    public String getFriendlyURL(long groupId, boolean privateLayout, long layoutId, String name, String friendlyURL) throws PortalException {
        if (Validator.isNotNull(friendlyURL = this.getFriendlyURL(friendlyURL))) {
            return friendlyURL;
        }
        String originalFriendlyURL = friendlyURL = "/" + this.getFriendlyURL(name);
        int i = 1;
        while (true) {
            try {
                this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
            }
            catch (LayoutFriendlyURLException lfurle) {
                int type = lfurle.getType();
                if (type != 6) {
                    friendlyURL = "/" + layoutId;
                    break;
                }
                friendlyURL = originalFriendlyURL + i;
                ++i;
                continue;
            }
            break;
        }
        return friendlyURL;
    }

    public String getFriendlyURL(String friendlyURL) {
        return FriendlyURLNormalizerUtil.normalizeWithEncoding(friendlyURL);
    }

    public Map<Locale, String> getFriendlyURLMap(long groupId, boolean privateLayout, long layoutId, String name, Map<Locale, String> friendlyURLMap) throws PortalException {
        HashMap<Locale, String> newFriendlyURLMap = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales(groupId)) {
            String friendlyURL = friendlyURLMap.get(locale);
            if (!Validator.isNotNull(friendlyURL)) continue;
            friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, name, friendlyURL);
            newFriendlyURLMap.put(locale, friendlyURL);
        }
        Locale siteDefaultLocale = LocaleUtil.getSiteDefault();
        if (newFriendlyURLMap.isEmpty() || Validator.isNull((String)newFriendlyURLMap.get(siteDefaultLocale))) {
            String friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, name, "");
            newFriendlyURLMap.put(siteDefaultLocale, friendlyURL);
        }
        return newFriendlyURLMap;
    }

    public int getNextPriority(long groupId, boolean privateLayout, long parentLayoutId, String sourcePrototypeLayoutUuid, int defaultPriority) {
        try {
            LayoutSet layoutSet;
            int priority = defaultPriority;
            if (priority < 0) {
                Layout layout = this.layoutPersistence.findByG_P_P_Head_First(groupId, privateLayout, parentLayoutId, false, new LayoutPriorityComparator(false));
                priority = layout.getPriority() + 1;
            }
            if (priority < 1000000 && Validator.isNull(sourcePrototypeLayoutUuid) && Validator.isNotNull((layoutSet = this.layoutSetPersistence.fetchByG_P_Head(groupId, privateLayout, false)).getLayoutSetPrototypeUuid()) && layoutSet.isLayoutSetPrototypeLinkEnabled()) {
                priority += 1000000;
            }
            return priority;
        }
        catch (NoSuchLayoutException nsle) {
            if (_log.isDebugEnabled()) {
                _log.debug(nsle, nsle);
            }
            return 0;
        }
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return LayoutLocalServiceHelper.class.getName();
    }

    public long getParentLayoutId(long groupId, boolean privateLayout, long parentLayoutId) {
        Layout parentLayout;
        if (parentLayoutId != 0L && (parentLayout = this.layoutPersistence.fetchByG_P_L_Head(groupId, privateLayout, parentLayoutId, false)) == null) {
            parentLayoutId = 0L;
        }
        return parentLayoutId;
    }

    public boolean hasLayoutSetPrototypeLayout(LayoutSetPrototype layoutSetPrototype, String layoutUuid) throws PortalException {
        Layout layout = this.layoutPersistence.fetchByUUID_G_P_Head(layoutUuid, layoutSetPrototype.getGroupId(), true, false);
        return layout != null;
    }

    public void validate(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, String name, String type, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        boolean layoutInstanceableAllowed;
        LayoutTypeController layoutTypeController;
        this.validateName(name);
        boolean firstLayout = false;
        if (parentLayoutId == 0L) {
            List<Layout> layouts = this.layoutPersistence.findByG_P_P_Head(groupId, privateLayout, parentLayoutId, false, 0, 1);
            if (layouts.isEmpty()) {
                firstLayout = true;
            } else {
                Layout layout = layouts.get(0);
                long firstLayoutId = layout.getLayoutId();
                if (firstLayoutId == layoutId) {
                    firstLayout = true;
                }
            }
        } else {
            Layout layout = this.layoutPersistence.fetchByG_P_L_Head(groupId, privateLayout, layoutId, false);
            Layout parentLayout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, parentLayoutId, false);
            if ((layout == null || Validator.isNull(layout.getSourcePrototypeLayoutUuid())) && !SitesUtil.isLayoutSortable(parentLayout)) {
                throw new LayoutParentLayoutIdException(5);
            }
        }
        if (firstLayout) {
            this.validateFirstLayout(type);
        }
        if (!(layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(type)).isInstanceable() && !(layoutInstanceableAllowed = GetterUtil.getBoolean(serviceContext.getAttribute("layout.instanceable.allowed")))) {
            throw new LayoutTypeException(4);
        }
        if (!layoutTypeController.isParentable() && this.layoutPersistence.countByG_P_P_Head(groupId, privateLayout, layoutId, false) > 0) {
            throw new LayoutTypeException(1);
        }
        this.validateFriendlyURLs(groupId, privateLayout, layoutId, friendlyURLMap);
    }

    public void validateFirstLayout(Layout layout) throws PortalException {
        Group group = layout.getGroup();
        if (group.isGuest() && layout.isPublicLayout() && !this.hasGuestViewPermission(layout)) {
            LayoutTypeException lte = new LayoutTypeException(3);
            throw lte;
        }
        this.validateFirstLayout(layout.getType());
    }

    public void validateFirstLayout(String type) throws PortalException {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(type);
        if (Validator.isNull(type) || !layoutTypeController.isFirstPageable()) {
            LayoutTypeException lte = new LayoutTypeException(2);
            lte.setLayoutType(type);
            throw lte;
        }
    }

    public void validateFriendlyURL(long groupId, boolean privateLayout, long layoutId, String friendlyURL) throws PortalException {
        String[] urlSeparators;
        if (Validator.isNull(friendlyURL)) {
            return;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new LayoutFriendlyURLException(exceptionType);
        }
        List<LayoutFriendlyURL> layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByG_P_F(groupId, privateLayout, friendlyURL);
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            String[] layout = this.layoutPersistence.findByPrimaryKey(layoutFriendlyURL.getPlid());
            if (layout.getLayoutId() == layoutId) continue;
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(6);
            lfurle.setDuplicateClassPK(layout.getPlid());
            lfurle.setDuplicateClassName(Layout.class.getName());
            throw lfurle;
        }
        LayoutImpl.validateFriendlyURLKeyword(friendlyURL);
        if (friendlyURL.contains("/-/") || friendlyURL.endsWith(_FRIENDLY_URL_SEPARATOR_HEAD)) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict("/-/");
            throw lfurle;
        }
        Matcher matcher = _urlSeparatorPattern.matcher(friendlyURL);
        if (matcher.matches()) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict(friendlyURL);
            throw lfurle;
        }
        for (String urlSeparator : urlSeparators = FriendlyURLResolverRegistryUtil.getURLSeparators()) {
            if (!urlSeparator.contains(friendlyURL)) continue;
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict(urlSeparator);
            throw lfurle;
        }
        List<FriendlyURLMapper> friendlyURLMappers = PortletLocalServiceUtil.getFriendlyURLMappers();
        for (FriendlyURLMapper friendlyURLMapper : friendlyURLMappers) {
            String mapping;
            if (friendlyURLMapper.isCheckMappingWithPrefix() || !friendlyURL.contains((mapping = "/" + friendlyURLMapper.getMapping()) + "/") && !friendlyURL.endsWith(mapping)) continue;
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict(friendlyURLMapper.getMapping());
            throw lfurle;
        }
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String languageId = StringUtil.toLowerCase(LocaleUtil.toLanguageId(locale));
            String i18nPathLanguageId = "/" + PortalUtil.getI18nPathLanguageId(locale, languageId);
            String underlineI18nPathLanguageId = StringUtil.replace(i18nPathLanguageId, '-', '_');
            if (!friendlyURL.startsWith(i18nPathLanguageId + "/") && !friendlyURL.startsWith(underlineI18nPathLanguageId + "/") && !friendlyURL.startsWith("/" + languageId + "/") && !friendlyURL.equals(i18nPathLanguageId) && !friendlyURL.equals(underlineI18nPathLanguageId) && !friendlyURL.equals("/" + languageId)) continue;
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict(i18nPathLanguageId);
            throw lfurle;
        }
        String layoutIdFriendlyURL = friendlyURL.substring(1);
        if (Validator.isNumber(layoutIdFriendlyURL) && !layoutIdFriendlyURL.equals(String.valueOf(layoutId))) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(8);
            lfurle.setKeywordConflict(layoutIdFriendlyURL);
            throw lfurle;
        }
    }

    public void validateFriendlyURLs(long groupId, boolean privateLayout, long layoutId, Map<Locale, String> friendlyURLMap) throws PortalException {
        Throwable layoutFriendlyURLsException = null;
        for (Map.Entry<Locale, String> entry : friendlyURLMap.entrySet()) {
            try {
                String friendlyURL = entry.getValue();
                this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
            }
            catch (LayoutFriendlyURLException lfurle) {
                Locale locale = entry.getKey();
                if (layoutFriendlyURLsException == null) {
                    layoutFriendlyURLsException = new LayoutFriendlyURLsException(lfurle);
                } else {
                    layoutFriendlyURLsException.addSuppressed(lfurle);
                }
                ((LocalizedException)layoutFriendlyURLsException).addLocalizedException(locale, lfurle);
            }
        }
        if (layoutFriendlyURLsException != null) {
            throw layoutFriendlyURLsException;
        }
    }

    public void validateName(String name) throws PortalException {
        if (Validator.isNull(name)) {
            throw new LayoutNameException();
        }
        int maxLength = ModelHintsUtil.getMaxLength(Layout.class.getName(), "friendlyURL");
        if (name.length() > maxLength) {
            throw new LayoutNameException(1);
        }
    }

    public void validateName(String name, String languageId) throws PortalException {
        String defaultLanguageId = LocaleUtil.toLanguageId(LocaleUtil.getSiteDefault());
        if (defaultLanguageId.equals(languageId)) {
            this.validateName(name);
        }
    }

    public void validateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        List<Layout> layouts;
        Layout firstLayout;
        long firstLayoutId;
        Layout layout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, layoutId, false);
        if (parentLayoutId == layout.getParentLayoutId()) {
            return;
        }
        if (parentLayoutId == 0L) {
            return;
        }
        Layout parentLayout = this.layoutPersistence.findByG_P_L_Head(groupId, privateLayout, parentLayoutId, false);
        LayoutType parentLayoutType = parentLayout.getLayoutType();
        if (!parentLayoutType.isParentable()) {
            throw new LayoutParentLayoutIdException(1);
        }
        if (Validator.isNull(layout.getSourcePrototypeLayoutUuid()) && !SitesUtil.isLayoutSortable(parentLayout)) {
            throw new LayoutParentLayoutIdException(5);
        }
        if (PortalUtil.isLayoutDescendant(layout, parentLayoutId)) {
            throw new LayoutParentLayoutIdException(2);
        }
        if (layout.getParentLayoutId() == 0L && (firstLayoutId = (firstLayout = (layouts = this.layoutPersistence.findByG_P_P_Head(groupId, privateLayout, 0L, false, 0, 2)).get(0)).getLayoutId()) == layoutId) {
            Layout secondLayout = layouts.get(1);
            LayoutType layoutType = secondLayout.getLayoutType();
            if (Validator.isNull(secondLayout.getType()) || !layoutType.isFirstPageable()) {
                throw new LayoutParentLayoutIdException(3);
            }
        }
    }

    protected boolean hasGuestViewPermission(Layout layout) throws PortalException {
        Role role = RoleLocalServiceUtil.getRole(layout.getCompanyId(), "Guest");
        return this.resourcePermissionLocalService.hasResourcePermission(layout.getCompanyId(), Layout.class.getName(), 4, String.valueOf(layout.getPlid()), role.getRoleId(), "VIEW");
    }
}

