/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.LayoutFriendlyURLLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutFriendlyURLLocalServiceImpl
extends LayoutFriendlyURLLocalServiceBaseImpl {
    @Override
    public LayoutFriendlyURL addLayoutFriendlyURL(long userId, long companyId, long groupId, long plid, boolean privateLayout, String friendlyURL, String languageId, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long layoutFriendlyURLId = this.counterLocalService.increment();
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.create(layoutFriendlyURLId);
        layoutFriendlyURL.setUuid(serviceContext.getUuid());
        layoutFriendlyURL.setGroupId(groupId);
        layoutFriendlyURL.setCompanyId(companyId);
        layoutFriendlyURL.setUserId(user.getUserId());
        layoutFriendlyURL.setUserName(user.getFullName());
        layoutFriendlyURL.setPlid(plid);
        layoutFriendlyURL.setPrivateLayout(privateLayout);
        layoutFriendlyURL.setFriendlyURL(friendlyURL);
        layoutFriendlyURL.setLanguageId(languageId);
        return this.layoutFriendlyURLPersistence.update(layoutFriendlyURL);
    }

    @Override
    public List<LayoutFriendlyURL> addLayoutFriendlyURLs(long userId, long companyId, long groupId, long plid, boolean privateLayout, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        ArrayList<LayoutFriendlyURL> layoutFriendlyURLs = new ArrayList<LayoutFriendlyURL>();
        for (Locale locale : LanguageUtil.getAvailableLocales(groupId)) {
            String friendlyURL = friendlyURLMap.get(locale);
            if (Validator.isNull(friendlyURL)) continue;
            LayoutFriendlyURL layoutFriendlyURL = this.addLayoutFriendlyURL(userId, companyId, groupId, plid, privateLayout, friendlyURL, LocaleUtil.toLanguageId(locale), serviceContext);
            layoutFriendlyURLs.add(layoutFriendlyURL);
        }
        return layoutFriendlyURLs;
    }

    @Override
    public LayoutFriendlyURL deleteLayoutFriendlyURL(LayoutFriendlyURL layoutFriendlyURL) {
        return this.layoutFriendlyURLPersistence.remove(layoutFriendlyURL);
    }

    @Override
    public void deleteLayoutFriendlyURL(long plid, String languageId) {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL != null) {
            this.deleteLayoutFriendlyURL(layoutFriendlyURL);
        }
    }

    @Override
    public void deleteLayoutFriendlyURLs(long plid) {
        List<LayoutFriendlyURL> layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByPlid(plid);
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            this.deleteLayoutFriendlyURL(layoutFriendlyURL);
        }
    }

    @Override
    public LayoutFriendlyURL fetchFirstLayoutFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        return this.layoutFriendlyURLPersistence.fetchByG_P_F_First(groupId, privateLayout, friendlyURL, null);
    }

    @Override
    public LayoutFriendlyURL fetchLayoutFriendlyURL(long groupId, boolean privateLayout, String friendlyURL, String languageId) {
        return this.layoutFriendlyURLPersistence.fetchByG_P_F_L(groupId, privateLayout, friendlyURL, languageId);
    }

    @Override
    public LayoutFriendlyURL fetchLayoutFriendlyURL(long plid, String languageId) {
        return this.fetchLayoutFriendlyURL(plid, languageId, true);
    }

    @Override
    public LayoutFriendlyURL fetchLayoutFriendlyURL(long plid, String languageId, boolean useDefault) {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL == null && !useDefault) {
            return null;
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, LocaleUtil.toLanguageId(LocaleUtil.getSiteDefault()));
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByPlid_First(plid, null);
        }
        return layoutFriendlyURL;
    }

    @Override
    public LayoutFriendlyURL getLayoutFriendlyURL(long plid, String languageId) throws PortalException {
        return this.getLayoutFriendlyURL(plid, languageId, true);
    }

    @Override
    public LayoutFriendlyURL getLayoutFriendlyURL(long plid, String languageId, boolean useDefault) throws PortalException {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL == null && !useDefault) {
            StringBundler sb = new StringBundler(5);
            sb.append("{plid=");
            sb.append(plid);
            sb.append(", languageId=");
            sb.append(languageId);
            sb.append("}");
            throw new NoSuchLayoutFriendlyURLException(sb.toString());
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, LocaleUtil.toLanguageId(LocaleUtil.getSiteDefault()));
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.findByPlid_First(plid, null);
        }
        return layoutFriendlyURL;
    }

    @Override
    public Map<Long, String> getLayoutFriendlyURLs(Group siteGroup, List<Layout> layouts, String languageId) {
        HashMap<Long, String> layoutFriendlyURLMap = new HashMap<Long, String>();
        UnicodeProperties typeSettingsProperties = siteGroup.getTypeSettingsProperties();
        List<LayoutFriendlyURL> layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByP_L(ListUtil.toLongArray(layouts, Layout.PLID_ACCESSOR), languageId);
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            layoutFriendlyURLMap.put(layoutFriendlyURL.getPlid(), layoutFriendlyURL.getFriendlyURL());
        }
        if (GetterUtil.getBoolean(typeSettingsProperties.getProperty("inheritLocales"), true)) {
            return layoutFriendlyURLMap;
        }
        HashMap<Long, String> filteredLayoutFriendlyURLMap = new HashMap<Long, String>();
        Object[] locales = StringUtil.split(typeSettingsProperties.getProperty("locales"));
        if (!ArrayUtil.contains(locales, languageId)) {
            for (Layout layout : layouts) {
                String friendlyURL = (String)layoutFriendlyURLMap.get(layout.getPlid());
                filteredLayoutFriendlyURLMap.put(layout.getPlid(), friendlyURL);
            }
        }
        return filteredLayoutFriendlyURLMap;
    }

    @Override
    public List<LayoutFriendlyURL> getLayoutFriendlyURLs(long plid) {
        return this.layoutFriendlyURLPersistence.findByPlid(plid);
    }

    @Override
    public List<LayoutFriendlyURL> getLayoutFriendlyURLs(long plid, String friendlyURL, int start, int end) {
        return this.layoutFriendlyURLPersistence.findByP_F(plid, friendlyURL, start, end);
    }

    @Override
    public LayoutFriendlyURL updateLayoutFriendlyURL(long userId, long companyId, long groupId, long plid, boolean privateLayout, String friendlyURL, String languageId, ServiceContext serviceContext) throws PortalException {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL == null) {
            return this.addLayoutFriendlyURL(userId, companyId, groupId, plid, privateLayout, friendlyURL, languageId, serviceContext);
        }
        layoutFriendlyURL.setFriendlyURL(friendlyURL);
        return this.layoutFriendlyURLPersistence.update(layoutFriendlyURL);
    }

    @Override
    public List<LayoutFriendlyURL> updateLayoutFriendlyURLs(long userId, long companyId, long groupId, long plid, boolean privateLayout, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        HashMap<String, LayoutFriendlyURL> layoutFriendlyURLMap = new HashMap<String, LayoutFriendlyURL>();
        for (LayoutFriendlyURL layoutFriendlyURL : this.layoutFriendlyURLPersistence.findByPlid(plid)) {
            layoutFriendlyURLMap.put(layoutFriendlyURL.getLanguageId(), layoutFriendlyURL);
        }
        ArrayList<LayoutFriendlyURL> layoutFriendlyURLs = new ArrayList<LayoutFriendlyURL>(friendlyURLMap.size());
        for (Locale locale : LanguageUtil.getAvailableLocales(groupId)) {
            String friendlyURL = friendlyURLMap.get(locale);
            String languageId = LocaleUtil.toLanguageId(locale);
            LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)layoutFriendlyURLMap.get(languageId);
            if (Validator.isNull(friendlyURL)) {
                if (layoutFriendlyURL == null) continue;
                this.deleteLayoutFriendlyURL(layoutFriendlyURL);
                continue;
            }
            if (layoutFriendlyURL == null) {
                layoutFriendlyURL = this.addLayoutFriendlyURL(userId, companyId, groupId, plid, privateLayout, friendlyURL, languageId, serviceContext);
            } else {
                layoutFriendlyURL.setFriendlyURL(friendlyURL);
                layoutFriendlyURL = this.layoutFriendlyURLPersistence.update(layoutFriendlyURL);
            }
            layoutFriendlyURLs.add(layoutFriendlyURL);
        }
        return layoutFriendlyURLs;
    }
}

