/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutBranchPermissionUtil;
import com.liferay.portal.service.base.LayoutBranchServiceBaseImpl;

public class LayoutBranchServiceImpl
extends LayoutBranchServiceBaseImpl {
    @Override
    public LayoutBranch addLayoutBranch(long layoutRevisionId, String name, String description, boolean master, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        GroupPermissionUtil.check(permissionChecker, serviceContext.getScopeGroupId(), "ADD_LAYOUT_BRANCH");
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutRevision.getLayoutSetBranchId());
        GroupPermissionUtil.check(permissionChecker, layoutSetBranch.getGroupId(), "ADD_LAYOUT_BRANCH");
        return this.layoutBranchLocalService.addLayoutBranch(layoutRevisionId, name, description, false, serviceContext);
    }

    @Override
    public void deleteLayoutBranch(long layoutBranchId) throws PortalException {
        LayoutBranchPermissionUtil.check(this.getPermissionChecker(), layoutBranchId, "DELETE");
        this.layoutBranchLocalService.deleteLayoutBranch(layoutBranchId);
    }

    @Override
    public LayoutBranch updateLayoutBranch(long layoutBranchId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LayoutBranchPermissionUtil.check(this.getPermissionChecker(), layoutBranchId, "UPDATE");
        return this.layoutBranchLocalService.updateLayoutBranch(layoutBranchId, name, description, serviceContext);
    }
}

