/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.CommonPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.ContactServiceBaseImpl;
import java.util.List;

public class ContactServiceImpl
extends ContactServiceBaseImpl {
    @Override
    public List<Contact> getCompanyContacts(long companyId, int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(companyId)) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
        return this.contactPersistence.findByCompanyId(companyId, start, end);
    }

    @Override
    public int getCompanyContactsCount(long companyId) {
        return this.contactPersistence.countByCompanyId(companyId);
    }

    @Override
    public Contact getContact(long contactId) throws PortalException {
        Contact contact = this.contactPersistence.findByPrimaryKey(contactId);
        CommonPermissionUtil.check(this.getPermissionChecker(), contact.getClassNameId(), contact.getClassPK(), "VIEW");
        return contact;
    }

    @Override
    public List<Contact> getContacts(long classNameId, long classPK, int start, int end, OrderByComparator<Contact> orderByComparator) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), classNameId, classPK, "VIEW");
        return this.contactPersistence.findByC_C(classNameId, classPK, start, end, orderByComparator);
    }

    @Override
    public int getContactsCount(long classNameId, long classPK) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), classNameId, classPK, "VIEW");
        return this.contactPersistence.countByC_C(classNameId, classPK);
    }
}

