/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.service.base.CompanyServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.ratings.kernel.transformer.RatingsDataTransformerUtil;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.InputStream;
import java.util.List;
import javax.portlet.PortletPreferences;

@JSONWebService
public class CompanyServiceImpl
extends CompanyServiceBaseImpl {
    @Override
    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public Company addCompany(String webId, String virtualHost, String mx, boolean system, int maxUsers, boolean active) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
        return this.companyLocalService.addCompany(webId, virtualHost, mx, system, maxUsers, active);
    }

    @Override
    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public Company deleteCompany(long companyId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
        return this.companyLocalService.deleteCompany(companyId);
    }

    @Override
    public void deleteLogo(long companyId) throws PortalException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.deleteLogo(companyId);
    }

    @Override
    public List<Company> getCompanies() {
        return this.companyLocalService.getCompanies();
    }

    @Override
    public Company getCompanyById(long companyId) throws PortalException {
        return this.companyLocalService.getCompanyById(companyId);
    }

    @Override
    public Company getCompanyByLogoId(long logoId) throws PortalException {
        return this.companyLocalService.getCompanyByLogoId(logoId);
    }

    @Override
    public Company getCompanyByMx(String mx) throws PortalException {
        return this.companyLocalService.getCompanyByMx(mx);
    }

    @Override
    public Company getCompanyByVirtualHost(String virtualHost) throws PortalException {
        return this.companyLocalService.getCompanyByVirtualHost(virtualHost);
    }

    @Override
    public Company getCompanyByWebId(String webId) throws PortalException {
        return this.companyLocalService.getCompanyByWebId(webId);
    }

    @Override
    public void removePreferences(long companyId, String[] keys) throws PortalException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.removePreferences(companyId, keys);
    }

    @Override
    public Company updateCompany(long companyId, String virtualHost, String mx, int maxUsers, boolean active) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
        return this.companyLocalService.updateCompany(companyId, virtualHost, mx, maxUsers, active);
    }

    @Override
    public Company updateCompany(long companyId, String virtualHost, String mx, String homeURL, boolean logo, byte[] logoBytes, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        return this.companyLocalService.updateCompany(companyId, virtualHost, mx, homeURL, logo, logoBytes, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
    }

    @Override
    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public Company updateCompany(long companyId, String virtualHost, String mx, String homeURL, boolean logo, byte[] logoBytes, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size, String languageId, String timeZoneId, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, UnicodeProperties properties) throws PortalException {
        PortletPreferences oldCompanyPortletPreferences = PrefsPropsUtil.getPreferences(companyId);
        Company company = this.updateCompany(companyId, virtualHost, mx, homeURL, logo, logoBytes, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
        this.updateDisplay(company.getCompanyId(), languageId, timeZoneId);
        this.updatePreferences(company.getCompanyId(), properties);
        RatingsDataTransformerUtil.transformCompanyRatingsData(companyId, oldCompanyPortletPreferences, properties);
        UsersAdminUtil.updateAddresses(Account.class.getName(), company.getAccountId(), addresses);
        UsersAdminUtil.updateEmailAddresses(Account.class.getName(), company.getAccountId(), emailAddresses);
        UsersAdminUtil.updatePhones(Account.class.getName(), company.getAccountId(), phones);
        UsersAdminUtil.updateWebsites(Account.class.getName(), company.getAccountId(), websites);
        return company;
    }

    @Override
    public void updateDisplay(long companyId, String languageId, String timeZoneId) throws PortalException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updateDisplay(companyId, languageId, timeZoneId);
    }

    @Override
    public Company updateLogo(long companyId, byte[] bytes) throws PortalException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        return this.companyLocalService.updateLogo(companyId, bytes);
    }

    @Override
    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public Company updateLogo(long companyId, InputStream inputStream) throws PortalException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        return this.companyLocalService.updateLogo(companyId, inputStream);
    }

    @Override
    public void updatePreferences(long companyId, UnicodeProperties properties) throws PortalException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updatePreferences(companyId, properties);
    }

    @Override
    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public void updateSecurity(long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean siteLogo) throws PortalException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updateSecurity(companyId, authType, autoLogin, sendPassword, strangers, strangersWithMx, strangersVerify, siteLogo);
    }
}

