/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.service.base.ClassNameLocalServiceBaseImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassNameLocalServiceImpl
extends ClassNameLocalServiceBaseImpl
implements CacheRegistryItem {
    private static final Map<String, ClassName> _classNames = new ConcurrentHashMap<String, ClassName>();
    private static final ClassName _nullClassName = new ClassNameImpl();

    @Override
    public ClassName addClassName(String value) {
        ClassName className = this.classNamePersistence.fetchByValue(value);
        if (className == null) {
            long classNameId = this.counterLocalService.increment();
            className = this.classNamePersistence.create(classNameId);
            className.setValue(value);
            this.classNamePersistence.update(className);
        }
        return className;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkClassNames() {
        List<ClassName> classNames = this.classNamePersistence.findAll();
        for (ClassName className : classNames) {
            _classNames.put(className.getValue(), className);
        }
        List<String> models = ModelHintsUtil.getModels();
        for (String model : models) {
            this.getClassName(model);
        }
    }

    @Override
    public ClassName fetchByClassNameId(long classNameId) {
        return this.classNamePersistence.fetchByPrimaryKey(classNameId);
    }

    @Override
    public ClassName fetchClassName(String value) {
        if (Validator.isNull(value)) {
            return _nullClassName;
        }
        ClassName className = _classNames.get(value);
        if (className == null) {
            className = this.classNamePersistence.fetchByValue(value);
            if (className == null) {
                return _nullClassName;
            }
            ClassName callbackClassName = className;
            TransactionCommitCallbackUtil.registerCallback(() -> _classNames.put(value, callbackClassName));
        }
        return className;
    }

    @Override
    @Transactional(enabled=false)
    public ClassName getClassName(String value) {
        ClassName className;
        block4: {
            if (Validator.isNull(value)) {
                return _nullClassName;
            }
            className = _classNames.get(value);
            if (className == null) {
                try {
                    ClassName callbackClassName = className = this.classNameLocalService.addClassName(value);
                    TransactionCommitCallbackUtil.registerCallback(() -> _classNames.put(value, callbackClassName));
                }
                catch (Throwable t) {
                    className = this.classNameLocalService.fetchClassName(value);
                    if (className != _nullClassName) break block4;
                    throw t;
                }
            }
        }
        return className;
    }

    @Override
    @Transactional(enabled=false)
    public long getClassNameId(Class<?> clazz) {
        return this.getClassNameId(clazz.getName());
    }

    @Override
    @Transactional(enabled=false)
    public long getClassNameId(String value) {
        ClassName className = this.getClassName(value);
        return className.getClassNameId();
    }

    @Override
    public String getRegistryName() {
        return ClassNameLocalServiceImpl.class.getName();
    }

    @Override
    public void invalidate() {
        _classNames.clear();
    }
}

