/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.CommonPermissionUtil;
import com.liferay.portal.service.base.AddressServiceBaseImpl;
import java.util.List;

public class AddressServiceImpl
extends AddressServiceBaseImpl {
    @Override
    public Address addAddress(String className, long classPK, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary, ServiceContext serviceContext) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.addressLocalService.addAddress(this.getUserId(), className, classPK, street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary, serviceContext);
    }

    @Override
    public void deleteAddress(long addressId) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), address.getClassNameId(), address.getClassPK(), "UPDATE");
        this.addressLocalService.deleteAddress(address);
    }

    @Override
    public Address getAddress(long addressId) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), address.getClassNameId(), address.getClassPK(), "VIEW");
        return address;
    }

    @Override
    public List<Address> getAddresses(String className, long classPK) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "VIEW");
        User user = this.getUser();
        return this.addressLocalService.getAddresses(user.getCompanyId(), className, classPK);
    }

    @Override
    public Address updateAddress(long addressId, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), address.getClassNameId(), address.getClassPK(), "UPDATE");
        return this.addressLocalService.updateAddress(addressId, street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary);
    }
}

