/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.model.WebsiteSoap;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WebsiteServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class WebsiteServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(WebsiteServiceSoap.class);

    public static WebsiteSoap addWebsite(String className, long classPK, String url, long typeId, boolean primary, ServiceContext serviceContext) throws RemoteException {
        try {
            Website returnValue = WebsiteServiceUtil.addWebsite(className, classPK, url, typeId, primary, serviceContext);
            return WebsiteSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteWebsite(long websiteId) throws RemoteException {
        try {
            WebsiteServiceUtil.deleteWebsite(websiteId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WebsiteSoap getWebsite(long websiteId) throws RemoteException {
        try {
            Website returnValue = WebsiteServiceUtil.getWebsite(websiteId);
            return WebsiteSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WebsiteSoap[] getWebsites(String className, long classPK) throws RemoteException {
        try {
            List<Website> returnValue = WebsiteServiceUtil.getWebsites(className, classPK);
            return WebsiteSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WebsiteSoap updateWebsite(long websiteId, String url, long typeId, boolean primary) throws RemoteException {
        try {
            Website returnValue = WebsiteServiceUtil.updateWebsite(websiteId, url, typeId, primary);
            return WebsiteSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

