/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WebsiteServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class WebsiteServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(WebsiteServiceHttp.class);
    private static final Class<?>[] _addWebsiteParameterTypes0 = new Class[]{String.class, Long.TYPE, String.class, Long.TYPE, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _deleteWebsiteParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getWebsiteParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getWebsitesParameterTypes3 = new Class[]{String.class, Long.TYPE};
    private static final Class<?>[] _updateWebsiteParameterTypes4 = new Class[]{Long.TYPE, String.class, Long.TYPE, Boolean.TYPE};

    public static Website addWebsite(HttpPrincipal httpPrincipal, String className, long classPK, String url, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class, "addWebsite", _addWebsiteParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, className, classPK, url, typeId, primary, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Website)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteWebsite(HttpPrincipal httpPrincipal, long websiteId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class, "deleteWebsite", _deleteWebsiteParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, websiteId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Website getWebsite(HttpPrincipal httpPrincipal, long websiteId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class, "getWebsite", _getWebsiteParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, websiteId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Website)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Website> getWebsites(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class, "getWebsites", _getWebsitesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, className, classPK);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Website updateWebsite(HttpPrincipal httpPrincipal, long websiteId, String url, long typeId, boolean primary) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class, "updateWebsite", _updateWebsiteParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, websiteId, url, typeId, primary);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Website)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

