/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.announcements.kernel.model.AnnouncementsDeliverySoap;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AddressSoap;
import com.liferay.portal.kernel.model.EmailAddressSoap;
import com.liferay.portal.kernel.model.PhoneSoap;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRoleSoap;
import com.liferay.portal.kernel.model.UserSoap;
import com.liferay.portal.kernel.model.WebsiteSoap;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.impl.AddressModelImpl;
import com.liferay.portal.model.impl.EmailAddressModelImpl;
import com.liferay.portal.model.impl.PhoneModelImpl;
import com.liferay.portal.model.impl.UserGroupRoleModelImpl;
import com.liferay.portal.model.impl.WebsiteModelImpl;
import com.liferay.portlet.announcements.model.impl.AnnouncementsDeliveryModelImpl;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class UserServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(UserServiceSoap.class);

    public static void addGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws RemoteException {
        try {
            UserServiceUtil.addGroupUsers(groupId, userIds, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addOrganizationUsers(long organizationId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.addOrganizationUsers(organizationId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.addPasswordPolicyUsers(passwordPolicyId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addRoleUsers(long roleId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.addRoleUsers(roleId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addTeamUsers(long teamId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.addTeamUsers(teamId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap addUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, String locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.addUser(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, LocaleUtil.fromLanguageId(locale), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap addUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, String locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, AddressSoap[] addresses, EmailAddressSoap[] emailAddresses, PhoneSoap[] phones, WebsiteSoap[] websites, AnnouncementsDeliverySoap[] announcementsDelivers, boolean sendEmail, ServiceContext serviceContext) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.addUser(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, LocaleUtil.fromLanguageId(locale), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, AddressModelImpl.toModels(addresses), EmailAddressModelImpl.toModels(emailAddresses), PhoneModelImpl.toModels(phones), WebsiteModelImpl.toModels(websites), AnnouncementsDeliveryModelImpl.toModels(announcementsDelivers), sendEmail, serviceContext);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addUserGroupUsers(long userGroupId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.addUserGroupUsers(userGroupId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap addUserWithWorkflow(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, String locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, LocaleUtil.fromLanguageId(locale), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap addUserWithWorkflow(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, String locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, AddressSoap[] addresses, EmailAddressSoap[] emailAddresses, PhoneSoap[] phones, WebsiteSoap[] websites, AnnouncementsDeliverySoap[] announcementsDelivers, boolean sendEmail, ServiceContext serviceContext) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, LocaleUtil.fromLanguageId(locale), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, AddressModelImpl.toModels(addresses), EmailAddressModelImpl.toModels(emailAddresses), PhoneModelImpl.toModels(phones), WebsiteModelImpl.toModels(websites), AnnouncementsDeliveryModelImpl.toModels(announcementsDelivers), sendEmail, serviceContext);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deletePortrait(long userId) throws RemoteException {
        try {
            UserServiceUtil.deletePortrait(userId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteRoleUser(long roleId, long userId) throws RemoteException {
        try {
            UserServiceUtil.deleteRoleUser(roleId, userId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteUser(long userId) throws RemoteException {
        try {
            UserServiceUtil.deleteUser(userId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getCompanyUsers(long companyId, int start, int end) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getCompanyUsers(companyId, start, end);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCompanyUsersCount(long companyId) throws RemoteException {
        try {
            int returnValue = UserServiceUtil.getCompanyUsersCount(companyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap getCurrentUser() throws RemoteException {
        try {
            User returnValue = UserServiceUtil.getCurrentUser();
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long[] getGroupUserIds(long groupId) throws RemoteException {
        try {
            long[] returnValue = UserServiceUtil.getGroupUserIds(groupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getGroupUsers(long groupId) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getGroupUsers(groupId);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getGroupUsers(long groupId, int status, int start, int end, OrderByComparator<User> obc) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getGroupUsers(groupId, status, start, end, obc);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getGroupUsers(long groupId, int status, OrderByComparator<User> obc) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getGroupUsers(groupId, status, obc);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupUsersCount(long groupId, int status) throws RemoteException {
        try {
            int returnValue = UserServiceUtil.getGroupUsersCount(groupId, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getGtCompanyUsers(long gtUserId, long companyId, int size) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getGtCompanyUsers(gtUserId, companyId, size);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getGtOrganizationUsers(long gtUserId, long organizationId, int size) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getGtOrganizationUsers(gtUserId, organizationId, size);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getGtUserGroupUsers(long gtUserId, long userGroupId, int size) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getGtUserGroupUsers(gtUserId, userGroupId, size);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getOrganizationsAndUserGroupsUsersCount(long[] organizationIds, long[] userGroupIds) throws RemoteException {
        try {
            int returnValue = UserServiceUtil.getOrganizationsAndUserGroupsUsersCount(organizationIds, userGroupIds);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long[] getOrganizationUserIds(long organizationId) throws RemoteException {
        try {
            long[] returnValue = UserServiceUtil.getOrganizationUserIds(organizationId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getOrganizationUsers(long organizationId) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getOrganizationUsers(organizationId);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getOrganizationUsers(long organizationId, int status, int start, int end, OrderByComparator<User> obc) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getOrganizationUsers(organizationId, status, start, end, obc);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getOrganizationUsers(long organizationId, int status, OrderByComparator<User> obc) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getOrganizationUsers(organizationId, status, obc);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getOrganizationUsersCount(long organizationId, int status) throws RemoteException {
        try {
            int returnValue = UserServiceUtil.getOrganizationUsersCount(organizationId, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long[] getRoleUserIds(long roleId) throws RemoteException {
        try {
            long[] returnValue = UserServiceUtil.getRoleUserIds(roleId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap getUserByEmailAddress(long companyId, String emailAddress) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.getUserByEmailAddress(companyId, emailAddress);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap getUserById(long userId) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.getUserById(userId);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap getUserByScreenName(long companyId, String screenName) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.getUserByScreenName(companyId, screenName);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getUserGroupUsers(long userGroupId) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getUserGroupUsers(userGroupId);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap[] getUserGroupUsers(long userGroupId, int start, int end) throws RemoteException {
        try {
            List<User> returnValue = UserServiceUtil.getUserGroupUsers(userGroupId, start, end);
            return UserSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long getUserIdByEmailAddress(long companyId, String emailAddress) throws RemoteException {
        try {
            long returnValue = UserServiceUtil.getUserIdByEmailAddress(companyId, emailAddress);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long getUserIdByScreenName(long companyId, String screenName) throws RemoteException {
        try {
            long returnValue = UserServiceUtil.getUserIdByScreenName(companyId, screenName);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasGroupUser(long groupId, long userId) throws RemoteException {
        try {
            boolean returnValue = UserServiceUtil.hasGroupUser(groupId, userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasRoleUser(long roleId, long userId) throws RemoteException {
        try {
            boolean returnValue = UserServiceUtil.hasRoleUser(roleId, userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasRoleUser(long companyId, String name, long userId, boolean inherited) throws RemoteException {
        try {
            boolean returnValue = UserServiceUtil.hasRoleUser(companyId, name, userId, inherited);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean sendPasswordByEmailAddress(long companyId, String emailAddress) throws RemoteException {
        try {
            boolean returnValue = UserServiceUtil.sendPasswordByEmailAddress(companyId, emailAddress);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean sendPasswordByScreenName(long companyId, String screenName) throws RemoteException {
        try {
            boolean returnValue = UserServiceUtil.sendPasswordByScreenName(companyId, screenName);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean sendPasswordByUserId(long userId) throws RemoteException {
        try {
            boolean returnValue = UserServiceUtil.sendPasswordByUserId(userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void setRoleUsers(long roleId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.setRoleUsers(roleId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void setUserGroupUsers(long userGroupId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.setUserGroupUsers(userGroupId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetGroupTeamsUsers(long groupId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.unsetGroupTeamsUsers(groupId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws RemoteException {
        try {
            UserServiceUtil.unsetGroupUsers(groupId, userIds, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetOrganizationUsers(long organizationId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.unsetOrganizationUsers(organizationId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.unsetPasswordPolicyUsers(passwordPolicyId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetRoleUsers(long roleId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.unsetRoleUsers(roleId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetTeamUsers(long teamId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.unsetTeamUsers(teamId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetUserGroupUsers(long userGroupId, long[] userIds) throws RemoteException {
        try {
            UserServiceUtil.unsetUserGroupUsers(userGroupId, userIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateAgreedToTermsOfUse(long userId, boolean agreedToTermsOfUse) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateAgreedToTermsOfUse(userId, agreedToTermsOfUse);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2, ServiceContext serviceContext) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateEmailAddress(userId, password, emailAddress1, emailAddress2, serviceContext);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateIncompleteUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, String locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, boolean updateUserInformation, boolean sendEmail, ServiceContext serviceContext) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateIncompleteUser(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, LocaleUtil.fromLanguageId(locale), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, updateUserInformation, sendEmail, serviceContext);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateLockoutById(long userId, boolean lockout) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateLockoutById(userId, lockout);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateOpenId(long userId, String openId) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateOpenId(userId, openId);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateOrganizations(long userId, long[] organizationIds, ServiceContext serviceContext) throws RemoteException {
        try {
            UserServiceUtil.updateOrganizations(userId, organizationIds, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updatePassword(long userId, String password1, String password2, boolean passwordReset) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updatePassword(userId, password1, password2, passwordReset);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updatePortrait(long userId, byte[] bytes) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updatePortrait(userId, bytes);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateReminderQuery(long userId, String question, String answer) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateReminderQuery(userId, question, answer);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateScreenName(long userId, String screenName) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateScreenName(userId, screenName);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateStatus(long userId, int status, ServiceContext serviceContext) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateStatus(userId, status, serviceContext);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, boolean portrait, byte[] portraitBytes, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, UserGroupRoleSoap[] userGroupRoles, long[] userGroupIds, AddressSoap[] addresses, EmailAddressSoap[] emailAddresses, PhoneSoap[] phones, WebsiteSoap[] websites, AnnouncementsDeliverySoap[] announcementsDelivers, ServiceContext serviceContext) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, portrait, portraitBytes, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, UserGroupRoleModelImpl.toModels(userGroupRoles), userGroupIds, AddressModelImpl.toModels(addresses), EmailAddressModelImpl.toModels(emailAddresses), PhoneModelImpl.toModels(phones), WebsiteModelImpl.toModels(websites), AnnouncementsDeliveryModelImpl.toModels(announcementsDelivers), serviceContext);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserSoap updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, UserGroupRoleSoap[] userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws RemoteException {
        try {
            User returnValue = UserServiceUtil.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, UserGroupRoleModelImpl.toModels(userGroupRoles), userGroupIds, serviceContext);
            return UserSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

