/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupSoap;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class UserGroupServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(UserGroupServiceSoap.class);

    public static void addGroupUserGroups(long groupId, long[] userGroupIds) throws RemoteException {
        try {
            UserGroupServiceUtil.addGroupUserGroups(groupId, userGroupIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addTeamUserGroups(long teamId, long[] userGroupIds) throws RemoteException {
        try {
            UserGroupServiceUtil.addTeamUserGroups(teamId, userGroupIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserGroupSoap addUserGroup(String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            UserGroup returnValue = UserGroupServiceUtil.addUserGroup(name, description, serviceContext);
            return UserGroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteUserGroup(long userGroupId) throws RemoteException {
        try {
            UserGroupServiceUtil.deleteUserGroup(userGroupId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserGroupSoap fetchUserGroup(long userGroupId) throws RemoteException {
        try {
            UserGroup returnValue = UserGroupServiceUtil.fetchUserGroup(userGroupId);
            return UserGroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserGroupSoap[] getGtUserGroups(long gtUserGroupId, long companyId, long parentUserGroupId, int size) throws RemoteException {
        try {
            List<UserGroup> returnValue = UserGroupServiceUtil.getGtUserGroups(gtUserGroupId, companyId, parentUserGroupId, size);
            return UserGroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserGroupSoap getUserGroup(long userGroupId) throws RemoteException {
        try {
            UserGroup returnValue = UserGroupServiceUtil.getUserGroup(userGroupId);
            return UserGroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserGroupSoap getUserGroup(String name) throws RemoteException {
        try {
            UserGroup returnValue = UserGroupServiceUtil.getUserGroup(name);
            return UserGroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserGroupSoap[] getUserGroups(long companyId) throws RemoteException {
        try {
            List<UserGroup> returnValue = UserGroupServiceUtil.getUserGroups(companyId);
            return UserGroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserGroupSoap[] getUserGroups(long companyId, String name, int start, int end) throws RemoteException {
        try {
            List<UserGroup> returnValue = UserGroupServiceUtil.getUserGroups(companyId, name, start, end);
            return UserGroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getUserGroupsCount(long companyId, String name) throws RemoteException {
        try {
            int returnValue = UserGroupServiceUtil.getUserGroupsCount(companyId, name);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserGroupSoap[] getUserUserGroups(long userId) throws RemoteException {
        try {
            List<UserGroup> returnValue = UserGroupServiceUtil.getUserUserGroups(userId);
            return UserGroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetGroupUserGroups(long groupId, long[] userGroupIds) throws RemoteException {
        try {
            UserGroupServiceUtil.unsetGroupUserGroups(groupId, userGroupIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetTeamUserGroups(long teamId, long[] userGroupIds) throws RemoteException {
        try {
            UserGroupServiceUtil.unsetTeamUserGroups(teamId, userGroupIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UserGroupSoap updateUserGroup(long userGroupId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            UserGroup returnValue = UserGroupServiceUtil.updateUserGroup(userGroupId, name, description, serviceContext);
            return UserGroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

