/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class UserGroupServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(UserGroupServiceHttp.class);
    private static final Class<?>[] _addGroupUserGroupsParameterTypes0 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _addTeamUserGroupsParameterTypes1 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _addUserGroupParameterTypes2 = new Class[]{String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteUserGroupParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchUserGroupParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGtUserGroupsParameterTypes5 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _getUserGroupParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserGroupParameterTypes7 = new Class[]{String.class};
    private static final Class<?>[] _getUserGroupsParameterTypes8 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserGroupsParameterTypes9 = new Class[]{Long.TYPE, String.class, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getUserGroupsCountParameterTypes10 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getUserUserGroupsParameterTypes11 = new Class[]{Long.TYPE};
    private static final Class<?>[] _unsetGroupUserGroupsParameterTypes12 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _unsetTeamUserGroupsParameterTypes13 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _updateUserGroupParameterTypes14 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};

    public static void addGroupUserGroups(HttpPrincipal httpPrincipal, long groupId, long[] userGroupIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "addGroupUserGroups", _addGroupUserGroupsParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, userGroupIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void addTeamUserGroups(HttpPrincipal httpPrincipal, long teamId, long[] userGroupIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "addTeamUserGroups", _addTeamUserGroupsParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, teamId, userGroupIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static UserGroup addUserGroup(HttpPrincipal httpPrincipal, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "addUserGroup", _addUserGroupParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, name, description, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (UserGroup)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteUserGroup(HttpPrincipal httpPrincipal, long userGroupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "deleteUserGroup", _deleteUserGroupParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, userGroupId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static UserGroup fetchUserGroup(HttpPrincipal httpPrincipal, long userGroupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "fetchUserGroup", _fetchUserGroupParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, userGroupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (UserGroup)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<UserGroup> getGtUserGroups(HttpPrincipal httpPrincipal, long gtUserGroupId, long companyId, long parentUserGroupId, int size) {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "getGtUserGroups", _getGtUserGroupsParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, gtUserGroupId, companyId, parentUserGroupId, size);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static UserGroup getUserGroup(HttpPrincipal httpPrincipal, long userGroupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "getUserGroup", _getUserGroupParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, userGroupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (UserGroup)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static UserGroup getUserGroup(HttpPrincipal httpPrincipal, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "getUserGroup", _getUserGroupParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, name);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (UserGroup)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<UserGroup> getUserGroups(HttpPrincipal httpPrincipal, long companyId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "getUserGroups", _getUserGroupsParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<UserGroup> getUserGroups(HttpPrincipal httpPrincipal, long companyId, String name, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "getUserGroups", _getUserGroupsParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, name, start, end);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int getUserGroupsCount(HttpPrincipal httpPrincipal, long companyId, String name) {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "getUserGroupsCount", _getUserGroupsCountParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, name);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<UserGroup> getUserUserGroups(HttpPrincipal httpPrincipal, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "getUserUserGroups", _getUserUserGroupsParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void unsetGroupUserGroups(HttpPrincipal httpPrincipal, long groupId, long[] userGroupIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "unsetGroupUserGroups", _unsetGroupUserGroupsParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, userGroupIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void unsetTeamUserGroups(HttpPrincipal httpPrincipal, long teamId, long[] userGroupIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "unsetTeamUserGroups", _unsetTeamUserGroupsParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, teamId, userGroupIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static UserGroup updateUserGroup(HttpPrincipal httpPrincipal, long userGroupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class, "updateUserGroup", _updateUserGroupParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, userGroupId, name, description, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (UserGroup)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

