/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.TeamSoap;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class TeamServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(TeamServiceSoap.class);

    public static TeamSoap addTeam(long groupId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            Team returnValue = TeamServiceUtil.addTeam(groupId, name, description, serviceContext);
            return TeamSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteTeam(long teamId) throws RemoteException {
        try {
            TeamServiceUtil.deleteTeam(teamId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TeamSoap[] getGroupTeams(long groupId) throws RemoteException {
        try {
            List<Team> returnValue = TeamServiceUtil.getGroupTeams(groupId);
            return TeamSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TeamSoap getTeam(long teamId) throws RemoteException {
        try {
            Team returnValue = TeamServiceUtil.getTeam(teamId);
            return TeamSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TeamSoap getTeam(long groupId, String name) throws RemoteException {
        try {
            Team returnValue = TeamServiceUtil.getTeam(groupId, name);
            return TeamSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TeamSoap[] getUserTeams(long userId) throws RemoteException {
        try {
            List<Team> returnValue = TeamServiceUtil.getUserTeams(userId);
            return TeamSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TeamSoap[] getUserTeams(long userId, long groupId) throws RemoteException {
        try {
            List<Team> returnValue = TeamServiceUtil.getUserTeams(userId, groupId);
            return TeamSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasUserTeam(long userId, long teamId) throws RemoteException {
        try {
            boolean returnValue = TeamServiceUtil.hasUserTeam(userId, teamId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TeamSoap updateTeam(long teamId, String name, String description) throws RemoteException {
        try {
            Team returnValue = TeamServiceUtil.updateTeam(teamId, name, description);
            return TeamSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

