/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class TeamServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(TeamServiceHttp.class);
    private static final Class<?>[] _addTeamParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteTeamParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupTeamsParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getTeamParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getTeamParameterTypes4 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getUserTeamsParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserTeamsParameterTypes6 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _hasUserTeamParameterTypes7 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _searchParameterTypes8 = new Class[]{Long.TYPE, String.class, String.class, LinkedHashMap.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _searchCountParameterTypes9 = new Class[]{Long.TYPE, String.class, String.class, LinkedHashMap.class};
    private static final Class<?>[] _updateTeamParameterTypes10 = new Class[]{Long.TYPE, String.class, String.class};

    public static Team addTeam(HttpPrincipal httpPrincipal, long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "addTeam", _addTeamParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, name, description, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteTeam(HttpPrincipal httpPrincipal, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "deleteTeam", _deleteTeamParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, teamId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Team> getGroupTeams(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getGroupTeams", _getGroupTeamsParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Team getTeam(HttpPrincipal httpPrincipal, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getTeam", _getTeamParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, teamId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Team getTeam(HttpPrincipal httpPrincipal, long groupId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getTeam", _getTeamParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, name);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Team> getUserTeams(HttpPrincipal httpPrincipal, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getUserTeams", _getUserTeamsParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Team> getUserTeams(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getUserTeams", _getUserTeamsParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, groupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static boolean hasUserTeam(HttpPrincipal httpPrincipal, long userId, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "hasUserTeam", _hasUserTeamParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, teamId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Team> search(HttpPrincipal httpPrincipal, long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> obc) {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "search", _searchParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, name, description, params, start, end, obc);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "searchCount", _searchCountParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, name, description, params);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Team updateTeam(HttpPrincipal httpPrincipal, long teamId, String name, String description) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "updateTeam", _updateTeamParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, teamId, name, description);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

