/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.GroupSoap;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleSoap;
import com.liferay.portal.kernel.service.RoleServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.model.impl.GroupModelImpl;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RoleServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(RoleServiceSoap.class);

    public static RoleSoap addRole(String className, long classPK, String name, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, int type, String subtype, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> titleMap = LocalizationUtil.getLocalizationMap(titleMapLanguageIds, titleMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            Role returnValue = RoleServiceUtil.addRole(className, classPK, name, titleMap, descriptionMap, type, subtype, serviceContext);
            return RoleSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addUserRoles(long userId, long[] roleIds) throws RemoteException {
        try {
            RoleServiceUtil.addUserRoles(userId, roleIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteRole(long roleId) throws RemoteException {
        try {
            RoleServiceUtil.deleteRole(roleId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap fetchRole(long roleId) throws RemoteException {
        try {
            Role returnValue = RoleServiceUtil.fetchRole(roleId);
            return RoleSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getGroupRoles(long groupId) throws RemoteException {
        try {
            List<Role> returnValue = RoleServiceUtil.getGroupRoles(groupId);
            return RoleSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getGroupRolesAndTeamRoles(long companyId, String keywords, List<String> excludedNames, int[] types, long excludedTeamRoleId, long teamGroupId, int start, int end) throws RemoteException {
        try {
            List<Role> returnValue = RoleServiceUtil.getGroupRolesAndTeamRoles(companyId, keywords, excludedNames, types, excludedTeamRoleId, teamGroupId, start, end);
            return RoleSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupRolesAndTeamRolesCount(long companyId, String keywords, List<String> excludedNames, int[] types, long excludedTeamRoleId, long teamGroupId) throws RemoteException {
        try {
            int returnValue = RoleServiceUtil.getGroupRolesAndTeamRolesCount(companyId, keywords, excludedNames, types, excludedTeamRoleId, teamGroupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap getRole(long roleId) throws RemoteException {
        try {
            Role returnValue = RoleServiceUtil.getRole(roleId);
            return RoleSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap getRole(long companyId, String name) throws RemoteException {
        try {
            Role returnValue = RoleServiceUtil.getRole(companyId, name);
            return RoleSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getRoles(int type, String subtype) throws RemoteException {
        try {
            List<Role> returnValue = RoleServiceUtil.getRoles(type, subtype);
            return RoleSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getRoles(long companyId, int[] types) throws RemoteException {
        try {
            List<Role> returnValue = RoleServiceUtil.getRoles(companyId, types);
            return RoleSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getUserGroupGroupRoles(long userId, long groupId) throws RemoteException {
        try {
            List<Role> returnValue = RoleServiceUtil.getUserGroupGroupRoles(userId, groupId);
            return RoleSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getUserGroupRoles(long userId, long groupId) throws RemoteException {
        try {
            List<Role> returnValue = RoleServiceUtil.getUserGroupRoles(userId, groupId);
            return RoleSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getUserRelatedRoles(long userId, GroupSoap[] groups) throws RemoteException {
        try {
            List<Role> returnValue = RoleServiceUtil.getUserRelatedRoles(userId, GroupModelImpl.toModels(groups));
            return RoleSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getUserRoles(long userId) throws RemoteException {
        try {
            List<Role> returnValue = RoleServiceUtil.getUserRoles(userId);
            return RoleSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws RemoteException {
        try {
            boolean returnValue = RoleServiceUtil.hasUserRole(userId, companyId, name, inherited);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws RemoteException {
        try {
            boolean returnValue = RoleServiceUtil.hasUserRoles(userId, companyId, names, inherited);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetUserRoles(long userId, long[] roleIds) throws RemoteException {
        try {
            RoleServiceUtil.unsetUserRoles(userId, roleIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap updateRole(long roleId, String name, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, String subtype, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> titleMap = LocalizationUtil.getLocalizationMap(titleMapLanguageIds, titleMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            Role returnValue = RoleServiceUtil.updateRole(roleId, name, titleMap, descriptionMap, subtype, serviceContext);
            return RoleSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

