/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.RoleServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RoleServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RoleServiceHttp.class);
    private static final Class<?>[] _addRoleParameterTypes0 = new Class[]{String.class, Long.TYPE, String.class, Map.class, Map.class, Integer.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _addUserRolesParameterTypes1 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _deleteRoleParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchRoleParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupRolesParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupRolesAndTeamRolesParameterTypes5 = new Class[]{Long.TYPE, String.class, List.class, int[].class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupRolesAndTeamRolesCountParameterTypes6 = new Class[]{Long.TYPE, String.class, List.class, int[].class, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getRoleParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRoleParameterTypes8 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getRolesParameterTypes9 = new Class[]{Integer.TYPE, String.class};
    private static final Class<?>[] _getRolesParameterTypes10 = new Class[]{Long.TYPE, int[].class};
    private static final Class<?>[] _getUserGroupGroupRolesParameterTypes11 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getUserGroupRolesParameterTypes12 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getUserRelatedRolesParameterTypes13 = new Class[]{Long.TYPE, List.class};
    private static final Class<?>[] _getUserRolesParameterTypes14 = new Class[]{Long.TYPE};
    private static final Class<?>[] _hasUserRoleParameterTypes15 = new Class[]{Long.TYPE, Long.TYPE, String.class, Boolean.TYPE};
    private static final Class<?>[] _hasUserRolesParameterTypes16 = new Class[]{Long.TYPE, Long.TYPE, String[].class, Boolean.TYPE};
    private static final Class<?>[] _searchParameterTypes17 = new Class[]{Long.TYPE, String.class, Integer[].class, LinkedHashMap.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _searchCountParameterTypes18 = new Class[]{Long.TYPE, String.class, Integer[].class, LinkedHashMap.class};
    private static final Class<?>[] _unsetUserRolesParameterTypes19 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _updateRoleParameterTypes20 = new Class[]{Long.TYPE, String.class, Map.class, Map.class, String.class, ServiceContext.class};

    public static Role addRole(HttpPrincipal httpPrincipal, String className, long classPK, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type, String subtype, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "addRole", _addRoleParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, className, classPK, name, titleMap, descriptionMap, type, subtype, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void addUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "addUserRoles", _addUserRolesParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, roleIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "deleteRole", _deleteRoleParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, roleId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Role fetchRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "fetchRole", _fetchRoleParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, roleId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Role> getGroupRoles(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getGroupRoles", _getGroupRolesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Role> getGroupRolesAndTeamRoles(HttpPrincipal httpPrincipal, long companyId, String keywords, List<String> excludedNames, int[] types, long excludedTeamRoleId, long teamGroupId, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getGroupRolesAndTeamRoles", _getGroupRolesAndTeamRolesParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, keywords, excludedNames, types, excludedTeamRoleId, teamGroupId, start, end);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int getGroupRolesAndTeamRolesCount(HttpPrincipal httpPrincipal, long companyId, String keywords, List<String> excludedNames, int[] types, long excludedTeamRoleId, long teamGroupId) {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getGroupRolesAndTeamRolesCount", _getGroupRolesAndTeamRolesCountParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, keywords, excludedNames, types, excludedTeamRoleId, teamGroupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getRole", _getRoleParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, roleId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getRole", _getRoleParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, name);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Role> getRoles(HttpPrincipal httpPrincipal, int type, String subtype) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getRoles", _getRolesParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, type, subtype);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Role> getRoles(HttpPrincipal httpPrincipal, long companyId, int[] types) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getRoles", _getRolesParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, types);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Role> getUserGroupGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getUserGroupGroupRoles", _getUserGroupGroupRolesParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, groupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Role> getUserGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getUserGroupRoles", _getUserGroupRolesParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, groupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Role> getUserRelatedRoles(HttpPrincipal httpPrincipal, long userId, List<Group> groups) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getUserRelatedRoles", _getUserRelatedRolesParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, groups);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Role> getUserRoles(HttpPrincipal httpPrincipal, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getUserRoles", _getUserRolesParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static boolean hasUserRole(HttpPrincipal httpPrincipal, long userId, long companyId, String name, boolean inherited) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "hasUserRole", _hasUserRoleParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, companyId, name, inherited);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static boolean hasUserRoles(HttpPrincipal httpPrincipal, long userId, long companyId, String[] names, boolean inherited) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "hasUserRoles", _hasUserRolesParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, companyId, names, inherited);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Role> search(HttpPrincipal httpPrincipal, long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Role> obc) {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "search", _searchParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, keywords, types, params, start, end, obc);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params) {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "searchCount", _searchCountParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, keywords, types, params);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void unsetUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "unsetUserRoles", _unsetUserRolesParameterTypes19);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, roleIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Role updateRole(HttpPrincipal httpPrincipal, long roleId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String subtype, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "updateRole", _updateRoleParameterTypes20);
            MethodHandler methodHandler = new MethodHandler(methodKey, roleId, name, titleMap, descriptionMap, subtype, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

