/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.RepositorySoap;
import com.liferay.portal.kernel.service.RepositoryServiceUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.rmi.RemoteException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RepositoryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(RepositoryServiceSoap.class);

    public static void checkRepository(long repositoryId) throws RemoteException {
        try {
            RepositoryServiceUtil.checkRepository(repositoryId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteRepository(long repositoryId) throws RemoteException {
        try {
            RepositoryServiceUtil.deleteRepository(repositoryId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RepositorySoap getRepository(long repositoryId) throws RemoteException {
        try {
            Repository returnValue = RepositoryServiceUtil.getRepository(repositoryId);
            return RepositorySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static UnicodeProperties getTypeSettingsProperties(long repositoryId) throws RemoteException {
        try {
            UnicodeProperties returnValue = RepositoryServiceUtil.getTypeSettingsProperties(repositoryId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateRepository(long repositoryId, String name, String description) throws RemoteException {
        try {
            RepositoryServiceUtil.updateRepository(repositoryId, name, description);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

