/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.RepositoryServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.UnicodeProperties;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RepositoryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RepositoryServiceHttp.class);
    private static final Class<?>[] _addRepositoryParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, String.class, UnicodeProperties.class, ServiceContext.class};
    private static final Class<?>[] _checkRepositoryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteRepositoryParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRepositoryParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getTypeSettingsPropertiesParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateRepositoryParameterTypes5 = new Class[]{Long.TYPE, String.class, String.class};

    public static Repository addRepository(HttpPrincipal httpPrincipal, long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "addRepository", _addRepositoryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsProperties, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Repository)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void checkRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "checkRepository", _checkRepositoryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, repositoryId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "deleteRepository", _deleteRepositoryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, repositoryId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Repository getRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getRepository", _getRepositoryParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, repositoryId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Repository)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static UnicodeProperties getTypeSettingsProperties(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getTypeSettingsProperties", _getTypeSettingsPropertiesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, repositoryId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (UnicodeProperties)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void updateRepository(HttpPrincipal httpPrincipal, long repositoryId, String name, String description) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "updateRepository", _updateRepositoryParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, repositoryId, name, description);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

