/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.RegionSoap;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RegionServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(RegionServiceSoap.class);

    public static RegionSoap addRegion(long countryId, String regionCode, String name, boolean active) throws RemoteException {
        try {
            Region returnValue = RegionServiceUtil.addRegion(countryId, regionCode, name, active);
            return RegionSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RegionSoap fetchRegion(long regionId) throws RemoteException {
        try {
            Region returnValue = RegionServiceUtil.fetchRegion(regionId);
            return RegionSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RegionSoap fetchRegion(long countryId, String regionCode) throws RemoteException {
        try {
            Region returnValue = RegionServiceUtil.fetchRegion(countryId, regionCode);
            return RegionSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RegionSoap getRegion(long regionId) throws RemoteException {
        try {
            Region returnValue = RegionServiceUtil.getRegion(regionId);
            return RegionSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RegionSoap getRegion(long countryId, String regionCode) throws RemoteException {
        try {
            Region returnValue = RegionServiceUtil.getRegion(countryId, regionCode);
            return RegionSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RegionSoap[] getRegions() throws RemoteException {
        try {
            List<Region> returnValue = RegionServiceUtil.getRegions();
            return RegionSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RegionSoap[] getRegions(boolean active) throws RemoteException {
        try {
            List<Region> returnValue = RegionServiceUtil.getRegions(active);
            return RegionSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RegionSoap[] getRegions(long countryId) throws RemoteException {
        try {
            List<Region> returnValue = RegionServiceUtil.getRegions(countryId);
            return RegionSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RegionSoap[] getRegions(long countryId, boolean active) throws RemoteException {
        try {
            List<Region> returnValue = RegionServiceUtil.getRegions(countryId, active);
            return RegionSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

