/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.PortletServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PortletServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(PortletServiceHttp.class);
    private static final Class<?>[] _getWARPortletsParameterTypes0 = new Class[0];
    private static final Class<?>[] _updatePortletParameterTypes1 = new Class[]{Long.TYPE, String.class, String.class, Boolean.TYPE};

    public static JSONArray getWARPortlets(HttpPrincipal httpPrincipal) {
        try {
            MethodKey methodKey = new MethodKey(PortletServiceUtil.class, "getWARPortlets", _getWARPortletsParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[0]);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (JSONArray)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Portlet updatePortlet(HttpPrincipal httpPrincipal, long companyId, String portletId, String roles, boolean active) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PortletServiceUtil.class, "updatePortlet", _updatePortletParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, portletId, roles, active);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Portlet)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

