/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.PortletPreferencesServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import javax.portlet.PortletPreferences;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PortletPreferencesServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesServiceHttp.class);
    private static final Class<?>[] _deleteArchivedPreferencesParameterTypes0 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreArchivedPreferencesParameterTypes1 = new Class[]{Long.TYPE, Layout.class, String.class, Long.TYPE, PortletPreferences.class};
    private static final Class<?>[] _restoreArchivedPreferencesParameterTypes2 = new Class[]{Long.TYPE, Layout.class, String.class, PortletItem.class, PortletPreferences.class};
    private static final Class<?>[] _restoreArchivedPreferencesParameterTypes3 = new Class[]{Long.TYPE, String.class, Layout.class, String.class, PortletPreferences.class};
    private static final Class<?>[] _updateArchivePreferencesParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, PortletPreferences.class};

    public static void deleteArchivedPreferences(HttpPrincipal httpPrincipal, long portletItemId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PortletPreferencesServiceUtil.class, "deleteArchivedPreferences", _deleteArchivedPreferencesParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, portletItemId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void restoreArchivedPreferences(HttpPrincipal httpPrincipal, long groupId, Layout layout, String portletId, long portletItemId, PortletPreferences jxPortletPreferences) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PortletPreferencesServiceUtil.class, "restoreArchivedPreferences", _restoreArchivedPreferencesParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, layout, portletId, portletItemId, jxPortletPreferences);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void restoreArchivedPreferences(HttpPrincipal httpPrincipal, long groupId, Layout layout, String portletId, PortletItem portletItem, PortletPreferences jxPortletPreferences) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PortletPreferencesServiceUtil.class, "restoreArchivedPreferences", _restoreArchivedPreferencesParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, layout, portletId, portletItem, jxPortletPreferences);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void restoreArchivedPreferences(HttpPrincipal httpPrincipal, long groupId, String name, Layout layout, String portletId, PortletPreferences jxPortletPreferences) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PortletPreferencesServiceUtil.class, "restoreArchivedPreferences", _restoreArchivedPreferencesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, name, layout, portletId, jxPortletPreferences);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void updateArchivePreferences(HttpPrincipal httpPrincipal, long userId, long groupId, String name, String portletId, PortletPreferences jxPortletPreferences) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PortletPreferencesServiceUtil.class, "updateArchivePreferences", _updateArchivePreferencesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, groupId, name, portletId, jxPortletPreferences);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

