/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.PhoneSoap;
import com.liferay.portal.kernel.service.PhoneServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PhoneServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(PhoneServiceSoap.class);

    public static PhoneSoap addPhone(String className, long classPK, String number, String extension, long typeId, boolean primary, ServiceContext serviceContext) throws RemoteException {
        try {
            Phone returnValue = PhoneServiceUtil.addPhone(className, classPK, number, extension, typeId, primary, serviceContext);
            return PhoneSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deletePhone(long phoneId) throws RemoteException {
        try {
            PhoneServiceUtil.deletePhone(phoneId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static PhoneSoap getPhone(long phoneId) throws RemoteException {
        try {
            Phone returnValue = PhoneServiceUtil.getPhone(phoneId);
            return PhoneSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static PhoneSoap[] getPhones(String className, long classPK) throws RemoteException {
        try {
            List<Phone> returnValue = PhoneServiceUtil.getPhones(className, classPK);
            return PhoneSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static PhoneSoap updatePhone(long phoneId, String number, String extension, long typeId, boolean primary) throws RemoteException {
        try {
            Phone returnValue = PhoneServiceUtil.updatePhone(phoneId, number, extension, typeId, primary);
            return PhoneSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

