/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.PermissionServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PermissionServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(PermissionServiceHttp.class);
    private static final Class<?>[] _checkPermissionParameterTypes0 = new Class[]{Long.TYPE, String.class, Long.TYPE};
    private static final Class<?>[] _checkPermissionParameterTypes1 = new Class[]{Long.TYPE, String.class, String.class};

    public static void checkPermission(HttpPrincipal httpPrincipal, long groupId, String name, long primKey) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class, "checkPermission", _checkPermissionParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, name, primKey);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void checkPermission(HttpPrincipal httpPrincipal, long groupId, String name, String primKey) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class, "checkPermission", _checkPermissionParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, name, primKey);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

