/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.PasswordPolicyServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PasswordPolicyServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(PasswordPolicyServiceHttp.class);
    private static final Class<?>[] _addPasswordPolicyParameterTypes0 = new Class[]{String.class, String.class, Boolean.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _deletePasswordPolicyParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchPasswordPolicyParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _searchParameterTypes3 = new Class[]{Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _searchCountParameterTypes4 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _updatePasswordPolicyParameterTypes5 = new Class[]{Long.TYPE, String.class, String.class, Boolean.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, ServiceContext.class};

    public static PasswordPolicy addPasswordPolicy(HttpPrincipal httpPrincipal, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, String regex, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PasswordPolicyServiceUtil.class, "addPasswordPolicy", _addPasswordPolicyParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, name, description, changeable, changeRequired, minAge, checkSyntax, allowDictionaryWords, minAlphanumeric, minLength, minLowerCase, minNumbers, minSymbols, minUpperCase, regex, history, historyCount, expireable, maxAge, warningTime, graceLimit, lockout, maxFailure, lockoutDuration, resetFailureCount, resetTicketMaxAge, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (PasswordPolicy)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deletePasswordPolicy(HttpPrincipal httpPrincipal, long passwordPolicyId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PasswordPolicyServiceUtil.class, "deletePasswordPolicy", _deletePasswordPolicyParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, passwordPolicyId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static PasswordPolicy fetchPasswordPolicy(HttpPrincipal httpPrincipal, long passwordPolicyId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PasswordPolicyServiceUtil.class, "fetchPasswordPolicy", _fetchPasswordPolicyParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, passwordPolicyId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (PasswordPolicy)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<PasswordPolicy> search(HttpPrincipal httpPrincipal, long companyId, String name, int start, int end, OrderByComparator<PasswordPolicy> obc) {
        try {
            MethodKey methodKey = new MethodKey(PasswordPolicyServiceUtil.class, "search", _searchParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, name, start, end, obc);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long companyId, String name) {
        try {
            MethodKey methodKey = new MethodKey(PasswordPolicyServiceUtil.class, "searchCount", _searchCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, name);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static PasswordPolicy updatePasswordPolicy(HttpPrincipal httpPrincipal, long passwordPolicyId, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, String regex, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(PasswordPolicyServiceUtil.class, "updatePasswordPolicy", _updatePasswordPolicyParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, passwordPolicyId, name, description, changeable, changeRequired, minAge, checkSyntax, allowDictionaryWords, minAlphanumeric, minLength, minLowerCase, minNumbers, minSymbols, minUpperCase, regex, history, historyCount, expireable, maxAge, warningTime, graceLimit, lockout, maxFailure, lockoutDuration, resetFailureCount, resetTicketMaxAge, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (PasswordPolicy)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

