/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AddressSoap;
import com.liferay.portal.kernel.model.EmailAddressSoap;
import com.liferay.portal.kernel.model.OrgLaborSoap;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.OrganizationSoap;
import com.liferay.portal.kernel.model.PhoneSoap;
import com.liferay.portal.kernel.model.WebsiteSoap;
import com.liferay.portal.kernel.service.OrganizationServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.model.impl.AddressModelImpl;
import com.liferay.portal.model.impl.EmailAddressModelImpl;
import com.liferay.portal.model.impl.OrgLaborModelImpl;
import com.liferay.portal.model.impl.PhoneModelImpl;
import com.liferay.portal.model.impl.WebsiteModelImpl;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class OrganizationServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(OrganizationServiceSoap.class);

    public static void addGroupOrganizations(long groupId, long[] organizationIds) throws RemoteException {
        try {
            OrganizationServiceUtil.addGroupOrganizations(groupId, organizationIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap addOrganization(long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean site, AddressSoap[] addresses, EmailAddressSoap[] emailAddresses, OrgLaborSoap[] orgLabors, PhoneSoap[] phones, WebsiteSoap[] websites, ServiceContext serviceContext) throws RemoteException {
        try {
            Organization returnValue = OrganizationServiceUtil.addOrganization(parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, AddressModelImpl.toModels(addresses), EmailAddressModelImpl.toModels(emailAddresses), OrgLaborModelImpl.toModels(orgLabors), PhoneModelImpl.toModels(phones), WebsiteModelImpl.toModels(websites), serviceContext);
            return OrganizationSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap addOrganization(long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean site, ServiceContext serviceContext) throws RemoteException {
        try {
            Organization returnValue = OrganizationServiceUtil.addOrganization(parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
            return OrganizationSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws RemoteException {
        try {
            OrganizationServiceUtil.addPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteLogo(long organizationId) throws RemoteException {
        try {
            OrganizationServiceUtil.deleteLogo(organizationId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteOrganization(long organizationId) throws RemoteException {
        try {
            OrganizationServiceUtil.deleteOrganization(organizationId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap fetchOrganization(long organizationId) throws RemoteException {
        try {
            Organization returnValue = OrganizationServiceUtil.fetchOrganization(organizationId);
            return OrganizationSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap[] getGtOrganizations(long gtOrganizationId, long companyId, long parentOrganizationId, int size) throws RemoteException {
        try {
            List<Organization> returnValue = OrganizationServiceUtil.getGtOrganizations(gtOrganizationId, companyId, parentOrganizationId, size);
            return OrganizationSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap getOrganization(long organizationId) throws RemoteException {
        try {
            Organization returnValue = OrganizationServiceUtil.getOrganization(organizationId);
            return OrganizationSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long getOrganizationId(long companyId, String name) throws RemoteException {
        try {
            long returnValue = OrganizationServiceUtil.getOrganizationId(companyId, name);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap[] getOrganizations(long companyId, long parentOrganizationId) throws RemoteException {
        try {
            List<Organization> returnValue = OrganizationServiceUtil.getOrganizations(companyId, parentOrganizationId);
            return OrganizationSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap[] getOrganizations(long companyId, long parentOrganizationId, int start, int end) throws RemoteException {
        try {
            List<Organization> returnValue = OrganizationServiceUtil.getOrganizations(companyId, parentOrganizationId, start, end);
            return OrganizationSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap[] getOrganizations(long companyId, long parentOrganizationId, String name, int start, int end) throws RemoteException {
        try {
            List<Organization> returnValue = OrganizationServiceUtil.getOrganizations(companyId, parentOrganizationId, name, start, end);
            return OrganizationSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getOrganizationsCount(long companyId, long parentOrganizationId) throws RemoteException {
        try {
            int returnValue = OrganizationServiceUtil.getOrganizationsCount(companyId, parentOrganizationId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getOrganizationsCount(long companyId, long parentOrganizationId, String name) throws RemoteException {
        try {
            int returnValue = OrganizationServiceUtil.getOrganizationsCount(companyId, parentOrganizationId, name);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap[] getUserOrganizations(long userId) throws RemoteException {
        try {
            List<Organization> returnValue = OrganizationServiceUtil.getUserOrganizations(userId);
            return OrganizationSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void setGroupOrganizations(long groupId, long[] organizationIds) throws RemoteException {
        try {
            OrganizationServiceUtil.setGroupOrganizations(groupId, organizationIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetGroupOrganizations(long groupId, long[] organizationIds) throws RemoteException {
        try {
            OrganizationServiceUtil.unsetGroupOrganizations(groupId, organizationIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws RemoteException {
        try {
            OrganizationServiceUtil.unsetPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap updateOrganization(long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean logo, byte[] logoBytes, boolean site, AddressSoap[] addresses, EmailAddressSoap[] emailAddresses, OrgLaborSoap[] orgLabors, PhoneSoap[] phones, WebsiteSoap[] websites, ServiceContext serviceContext) throws RemoteException {
        try {
            Organization returnValue = OrganizationServiceUtil.updateOrganization(organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, logo, logoBytes, site, AddressModelImpl.toModels(addresses), EmailAddressModelImpl.toModels(emailAddresses), OrgLaborModelImpl.toModels(orgLabors), PhoneModelImpl.toModels(phones), WebsiteModelImpl.toModels(websites), serviceContext);
            return OrganizationSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrganizationSoap updateOrganization(long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean site, ServiceContext serviceContext) throws RemoteException {
        try {
            Organization returnValue = OrganizationServiceUtil.updateOrganization(organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
            return OrganizationSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

