/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.OrgLaborSoap;
import com.liferay.portal.kernel.service.OrgLaborServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class OrgLaborServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(OrgLaborServiceSoap.class);

    public static OrgLaborSoap addOrgLabor(long organizationId, long typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws RemoteException {
        try {
            OrgLabor returnValue = OrgLaborServiceUtil.addOrgLabor(organizationId, typeId, sunOpen, sunClose, monOpen, monClose, tueOpen, tueClose, wedOpen, wedClose, thuOpen, thuClose, friOpen, friClose, satOpen, satClose);
            return OrgLaborSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteOrgLabor(long orgLaborId) throws RemoteException {
        try {
            OrgLaborServiceUtil.deleteOrgLabor(orgLaborId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrgLaborSoap getOrgLabor(long orgLaborId) throws RemoteException {
        try {
            OrgLabor returnValue = OrgLaborServiceUtil.getOrgLabor(orgLaborId);
            return OrgLaborSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrgLaborSoap[] getOrgLabors(long organizationId) throws RemoteException {
        try {
            List<OrgLabor> returnValue = OrgLaborServiceUtil.getOrgLabors(organizationId);
            return OrgLaborSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static OrgLaborSoap updateOrgLabor(long orgLaborId, long typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws RemoteException {
        try {
            OrgLabor returnValue = OrgLaborServiceUtil.updateOrgLabor(orgLaborId, typeId, sunOpen, sunClose, monOpen, monClose, tueOpen, tueClose, wedOpen, wedClose, thuOpen, thuClose, friOpen, friClose, satOpen, satClose);
            return OrgLaborSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

