/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.MembershipRequest;
import com.liferay.portal.kernel.model.MembershipRequestSoap;
import com.liferay.portal.kernel.service.MembershipRequestServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import java.rmi.RemoteException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class MembershipRequestServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(MembershipRequestServiceSoap.class);

    public static MembershipRequestSoap addMembershipRequest(long groupId, String comments, ServiceContext serviceContext) throws RemoteException {
        try {
            MembershipRequest returnValue = MembershipRequestServiceUtil.addMembershipRequest(groupId, comments, serviceContext);
            return MembershipRequestSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteMembershipRequests(long groupId, long statusId) throws RemoteException {
        try {
            MembershipRequestServiceUtil.deleteMembershipRequests(groupId, statusId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static MembershipRequestSoap getMembershipRequest(long membershipRequestId) throws RemoteException {
        try {
            MembershipRequest returnValue = MembershipRequestServiceUtil.getMembershipRequest(membershipRequestId);
            return MembershipRequestSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateStatus(long membershipRequestId, String reviewComments, long statusId, ServiceContext serviceContext) throws RemoteException {
        try {
            MembershipRequestServiceUtil.updateStatus(membershipRequestId, reviewComments, statusId, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

