/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.MembershipRequest;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.MembershipRequestServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class MembershipRequestServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(MembershipRequestServiceHttp.class);
    private static final Class<?>[] _addMembershipRequestParameterTypes0 = new Class[]{Long.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteMembershipRequestsParameterTypes1 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getMembershipRequestParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateStatusParameterTypes3 = new Class[]{Long.TYPE, String.class, Long.TYPE, ServiceContext.class};

    public static MembershipRequest addMembershipRequest(HttpPrincipal httpPrincipal, long groupId, String comments, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(MembershipRequestServiceUtil.class, "addMembershipRequest", _addMembershipRequestParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, comments, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (MembershipRequest)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteMembershipRequests(HttpPrincipal httpPrincipal, long groupId, long statusId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(MembershipRequestServiceUtil.class, "deleteMembershipRequests", _deleteMembershipRequestsParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, statusId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static MembershipRequest getMembershipRequest(HttpPrincipal httpPrincipal, long membershipRequestId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(MembershipRequestServiceUtil.class, "getMembershipRequest", _getMembershipRequestParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, membershipRequestId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (MembershipRequest)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void updateStatus(HttpPrincipal httpPrincipal, long membershipRequestId, String reviewComments, long statusId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(MembershipRequestServiceUtil.class, "updateStatus", _updateStatusParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, membershipRequestId, reviewComments, statusId, serviceContext);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

