/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeSoap;
import com.liferay.portal.kernel.service.ListTypeServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ListTypeServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(ListTypeServiceSoap.class);

    public static ListTypeSoap getListType(long listTypeId) throws RemoteException {
        try {
            ListType returnValue = ListTypeServiceUtil.getListType(listTypeId);
            return ListTypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ListTypeSoap getListType(String name, String type) throws RemoteException {
        try {
            ListType returnValue = ListTypeServiceUtil.getListType(name, type);
            return ListTypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ListTypeSoap[] getListTypes(String type) throws RemoteException {
        try {
            List<ListType> returnValue = ListTypeServiceUtil.getListTypes(type);
            return ListTypeSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void validate(long listTypeId, long classNameId, String type) throws RemoteException {
        try {
            ListTypeServiceUtil.validate(listTypeId, classNameId, type);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void validate(long listTypeId, String type) throws RemoteException {
        try {
            ListTypeServiceUtil.validate(listTypeId, type);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

