/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetSoap;
import com.liferay.portal.kernel.service.LayoutSetServiceUtil;
import java.rmi.RemoteException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class LayoutSetServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetServiceSoap.class);

    public static void updateLayoutSetPrototypeLinkEnabled(long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled, String layoutSetPrototypeUuid) throws RemoteException {
        try {
            LayoutSetServiceUtil.updateLayoutSetPrototypeLinkEnabled(groupId, privateLayout, layoutSetPrototypeLinkEnabled, layoutSetPrototypeUuid);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateLogo(long groupId, boolean privateLayout, boolean logo, byte[] bytes) throws RemoteException {
        try {
            LayoutSetServiceUtil.updateLogo(groupId, privateLayout, logo, bytes);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetSoap updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css) throws RemoteException {
        try {
            LayoutSet returnValue = LayoutSetServiceUtil.updateLookAndFeel(groupId, privateLayout, themeId, colorSchemeId, css);
            return LayoutSetSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetSoap updateSettings(long groupId, boolean privateLayout, String settings) throws RemoteException {
        try {
            LayoutSet returnValue = LayoutSetServiceUtil.updateSettings(groupId, privateLayout, settings);
            return LayoutSetSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetSoap updateVirtualHost(long groupId, boolean privateLayout, String virtualHost) throws RemoteException {
        try {
            LayoutSet returnValue = LayoutSetServiceUtil.updateVirtualHost(groupId, privateLayout, virtualHost);
            return LayoutSetSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

